<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlinePrefType StructType
 * @subpackage Structs
 */
class AirlinePrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The AirportOriginPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AirportPrefType[]
     */
    public $AirportOriginPref;
    /**
     * The AirportRoutePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AirportPrefType[]
     */
    public $AirportRoutePref;
    /**
     * The FareRestrictPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\FlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CabinPref[]
     */
    public $CabinPref;
    /**
     * The SeatPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SeatPref[]
     */
    public $SeatPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\MealPrefType[]
     */
    public $MealPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The SSR_Pref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SSR_Pref[]
     */
    public $SSR_Pref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\MediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AirTicketType
     * @var string
     */
    public $AirTicketType;
    /**
     * Constructor method for AirlinePrefType
     * @uses AirlinePrefType::setLoyaltyPref()
     * @uses AirlinePrefType::setVendorPref()
     * @uses AirlinePrefType::setPaymentFormPref()
     * @uses AirlinePrefType::setAirportOriginPref()
     * @uses AirlinePrefType::setAirportRoutePref()
     * @uses AirlinePrefType::setFareRestrictPref()
     * @uses AirlinePrefType::setFlightTypePref()
     * @uses AirlinePrefType::setEquipPref()
     * @uses AirlinePrefType::setCabinPref()
     * @uses AirlinePrefType::setSeatPref()
     * @uses AirlinePrefType::setTicketDistribPref()
     * @uses AirlinePrefType::setMealPref()
     * @uses AirlinePrefType::setSpecRequestPref()
     * @uses AirlinePrefType::setSSR_Pref()
     * @uses AirlinePrefType::setTPA_Extensions()
     * @uses AirlinePrefType::setMediaEntertainPref()
     * @uses AirlinePrefType::setPetInfoPref()
     * @uses AirlinePrefType::setShareSynchInd()
     * @uses AirlinePrefType::setShareMarketInd()
     * @uses AirlinePrefType::setPreferLevel()
     * @uses AirlinePrefType::setSmokingAllowed()
     * @uses AirlinePrefType::setPassengerTypeCode()
     * @uses AirlinePrefType::setAirTicketType()
     * @param \rdyescapiacontent\StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \rdyescapiacontent\StructType\CompanyNamePrefType[] $vendorPref
     * @param \rdyescapiacontent\StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \rdyescapiacontent\StructType\AirportPrefType[] $airportOriginPref
     * @param \rdyescapiacontent\StructType\AirportPrefType[] $airportRoutePref
     * @param \rdyescapiacontent\StructType\FareRestrictPref[] $fareRestrictPref
     * @param \rdyescapiacontent\StructType\FlightTypePref[] $flightTypePref
     * @param \rdyescapiacontent\StructType\EquipmentTypePref[] $equipPref
     * @param \rdyescapiacontent\StructType\CabinPref[] $cabinPref
     * @param \rdyescapiacontent\StructType\SeatPref[] $seatPref
     * @param \rdyescapiacontent\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @param \rdyescapiacontent\StructType\MealPrefType[] $mealPref
     * @param \rdyescapiacontent\StructType\SpecRequestPrefType[] $specRequestPref
     * @param \rdyescapiacontent\StructType\SSR_Pref[] $sSR_Pref
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param \rdyescapiacontent\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @param \rdyescapiacontent\StructType\PetInfoPrefType[] $petInfoPref
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $preferLevel
     * @param bool $smokingAllowed
     * @param string $passengerTypeCode
     * @param string $airTicketType
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $airportOriginPref = array(), array $airportRoutePref = array(), array $fareRestrictPref = array(), array $flightTypePref = array(), array $equipPref = array(), array $cabinPref = array(), array $seatPref = array(), array $ticketDistribPref = array(), array $mealPref = array(), array $specRequestPref = array(), array $sSR_Pref = array(), \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, array $mediaEntertainPref = array(), array $petInfoPref = array(), $shareSynchInd = null, $shareMarketInd = null, $preferLevel = 'Preferred', $smokingAllowed = false, $passengerTypeCode = null, $airTicketType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setAirportOriginPref($airportOriginPref)
            ->setAirportRoutePref($airportRoutePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setSeatPref($seatPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMealPref($mealPref)
            ->setSpecRequestPref($specRequestPref)
            ->setSSR_Pref($sSR_Pref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPreferLevel($preferLevel)
            ->setSmokingAllowed($smokingAllowed)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAirTicketType($airTicketType);
    }
    /**
     * Get LoyaltyPref value
     * @return \rdyescapiacontent\StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $airlinePrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeLoyaltyPrefItem instanceof \rdyescapiacontent\StructType\LoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapiacontent\StructType\LoyaltyPrefType, "%s" given', is_object($airlinePrefTypeLoyaltyPrefItem) ? get_class($airlinePrefTypeLoyaltyPrefItem) : gettype($airlinePrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToLoyaltyPref(\rdyescapiacontent\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapiacontent\StructType\LoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \rdyescapiacontent\StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNamePrefType[] $vendorPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $airlinePrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeVendorPrefItem instanceof \rdyescapiacontent\StructType\CompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapiacontent\StructType\CompanyNamePrefType, "%s" given', is_object($airlinePrefTypeVendorPrefItem) ? get_class($airlinePrefTypeVendorPrefItem) : gettype($airlinePrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNamePrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToVendorPref(\rdyescapiacontent\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapiacontent\StructType\CompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \rdyescapiacontent\StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $airlinePrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePaymentFormPrefItem instanceof \rdyescapiacontent\StructType\PaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapiacontent\StructType\PaymentFormPrefType, "%s" given', is_object($airlinePrefTypePaymentFormPrefItem) ? get_class($airlinePrefTypePaymentFormPrefItem) : gettype($airlinePrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToPaymentFormPref(\rdyescapiacontent\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapiacontent\StructType\PaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get AirportOriginPref value
     * @return \rdyescapiacontent\StructType\AirportPrefType[]|null
     */
    public function getAirportOriginPref()
    {
        return $this->AirportOriginPref;
    }
    /**
     * Set AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AirportPrefType[] $airportOriginPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setAirportOriginPref(array $airportOriginPref = array())
    {
        foreach ($airportOriginPref as $airlinePrefTypeAirportOriginPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportOriginPrefItem instanceof \rdyescapiacontent\StructType\AirportPrefType) {
                throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of \rdyescapiacontent\StructType\AirportPrefType, "%s" given', is_object($airlinePrefTypeAirportOriginPrefItem) ? get_class($airlinePrefTypeAirportOriginPrefItem) : gettype($airlinePrefTypeAirportOriginPrefItem)), __LINE__);
            }
        }
        $this->AirportOriginPref = $airportOriginPref;
        return $this;
    }
    /**
     * Add item to AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AirportPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToAirportOriginPref(\rdyescapiacontent\StructType\AirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of \rdyescapiacontent\StructType\AirportPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportOriginPref[] = $item;
        return $this;
    }
    /**
     * Get AirportRoutePref value
     * @return \rdyescapiacontent\StructType\AirportPrefType[]|null
     */
    public function getAirportRoutePref()
    {
        return $this->AirportRoutePref;
    }
    /**
     * Set AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AirportPrefType[] $airportRoutePref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setAirportRoutePref(array $airportRoutePref = array())
    {
        foreach ($airportRoutePref as $airlinePrefTypeAirportRoutePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportRoutePrefItem instanceof \rdyescapiacontent\StructType\AirportPrefType) {
                throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of \rdyescapiacontent\StructType\AirportPrefType, "%s" given', is_object($airlinePrefTypeAirportRoutePrefItem) ? get_class($airlinePrefTypeAirportRoutePrefItem) : gettype($airlinePrefTypeAirportRoutePrefItem)), __LINE__);
            }
        }
        $this->AirportRoutePref = $airportRoutePref;
        return $this;
    }
    /**
     * Add item to AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AirportPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToAirportRoutePref(\rdyescapiacontent\StructType\AirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of \rdyescapiacontent\StructType\AirportPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportRoutePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \rdyescapiacontent\StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\FareRestrictPref[] $fareRestrictPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        foreach ($fareRestrictPref as $airlinePrefTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFareRestrictPrefItem instanceof \rdyescapiacontent\StructType\FareRestrictPref) {
                throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \rdyescapiacontent\StructType\FareRestrictPref, "%s" given', is_object($airlinePrefTypeFareRestrictPrefItem) ? get_class($airlinePrefTypeFareRestrictPrefItem) : gettype($airlinePrefTypeFareRestrictPrefItem)), __LINE__);
            }
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\FareRestrictPref $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToFareRestrictPref(\rdyescapiacontent\StructType\FareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\FareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \rdyescapiacontent\StructType\FareRestrictPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \rdyescapiacontent\StructType\FlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\FlightTypePref[] $flightTypePref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        foreach ($flightTypePref as $airlinePrefTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFlightTypePrefItem instanceof \rdyescapiacontent\StructType\FlightTypePref) {
                throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \rdyescapiacontent\StructType\FlightTypePref, "%s" given', is_object($airlinePrefTypeFlightTypePrefItem) ? get_class($airlinePrefTypeFlightTypePrefItem) : gettype($airlinePrefTypeFlightTypePrefItem)), __LINE__);
            }
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\FlightTypePref $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToFlightTypePref(\rdyescapiacontent\StructType\FlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\FlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \rdyescapiacontent\StructType\FlightTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \rdyescapiacontent\StructType\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EquipmentTypePref[] $equipPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setEquipPref(array $equipPref = array())
    {
        foreach ($equipPref as $airlinePrefTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeEquipPrefItem instanceof \rdyescapiacontent\StructType\EquipmentTypePref) {
                throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \rdyescapiacontent\StructType\EquipmentTypePref, "%s" given', is_object($airlinePrefTypeEquipPrefItem) ? get_class($airlinePrefTypeEquipPrefItem) : gettype($airlinePrefTypeEquipPrefItem)), __LINE__);
            }
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EquipmentTypePref $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToEquipPref(\rdyescapiacontent\StructType\EquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\EquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \rdyescapiacontent\StructType\EquipmentTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \rdyescapiacontent\StructType\CabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CabinPref[] $cabinPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        foreach ($cabinPref as $airlinePrefTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeCabinPrefItem instanceof \rdyescapiacontent\StructType\CabinPref) {
                throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \rdyescapiacontent\StructType\CabinPref, "%s" given', is_object($airlinePrefTypeCabinPrefItem) ? get_class($airlinePrefTypeCabinPrefItem) : gettype($airlinePrefTypeCabinPrefItem)), __LINE__);
            }
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CabinPref $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToCabinPref(\rdyescapiacontent\StructType\CabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \rdyescapiacontent\StructType\CabinPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get SeatPref value
     * @return \rdyescapiacontent\StructType\SeatPref[]|null
     */
    public function getSeatPref()
    {
        return $this->SeatPref;
    }
    /**
     * Set SeatPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SeatPref[] $seatPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setSeatPref(array $seatPref = array())
    {
        foreach ($seatPref as $airlinePrefTypeSeatPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSeatPrefItem instanceof \rdyescapiacontent\StructType\SeatPref) {
                throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of \rdyescapiacontent\StructType\SeatPref, "%s" given', is_object($airlinePrefTypeSeatPrefItem) ? get_class($airlinePrefTypeSeatPrefItem) : gettype($airlinePrefTypeSeatPrefItem)), __LINE__);
            }
        }
        $this->SeatPref = $seatPref;
        return $this;
    }
    /**
     * Add item to SeatPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SeatPref $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToSeatPref(\rdyescapiacontent\StructType\SeatPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\SeatPref) {
            throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of \rdyescapiacontent\StructType\SeatPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \rdyescapiacontent\StructType\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        foreach ($ticketDistribPref as $airlinePrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeTicketDistribPrefItem instanceof \rdyescapiacontent\StructType\TicketDistribPrefType) {
                throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \rdyescapiacontent\StructType\TicketDistribPrefType, "%s" given', is_object($airlinePrefTypeTicketDistribPrefItem) ? get_class($airlinePrefTypeTicketDistribPrefItem) : gettype($airlinePrefTypeTicketDistribPrefItem)), __LINE__);
            }
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TicketDistribPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToTicketDistribPref(\rdyescapiacontent\StructType\TicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \rdyescapiacontent\StructType\TicketDistribPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \rdyescapiacontent\StructType\MealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\MealPrefType[] $mealPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $airlinePrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMealPrefItem instanceof \rdyescapiacontent\StructType\MealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \rdyescapiacontent\StructType\MealPrefType, "%s" given', is_object($airlinePrefTypeMealPrefItem) ? get_class($airlinePrefTypeMealPrefItem) : gettype($airlinePrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\MealPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToMealPref(\rdyescapiacontent\StructType\MealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\MealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \rdyescapiacontent\StructType\MealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \rdyescapiacontent\StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SpecRequestPrefType[] $specRequestPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $airlinePrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSpecRequestPrefItem instanceof \rdyescapiacontent\StructType\SpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \rdyescapiacontent\StructType\SpecRequestPrefType, "%s" given', is_object($airlinePrefTypeSpecRequestPrefItem) ? get_class($airlinePrefTypeSpecRequestPrefItem) : gettype($airlinePrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SpecRequestPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToSpecRequestPref(\rdyescapiacontent\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \rdyescapiacontent\StructType\SpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get SSR_Pref value
     * @return \rdyescapiacontent\StructType\SSR_Pref[]|null
     */
    public function getSSR_Pref()
    {
        return $this->SSR_Pref;
    }
    /**
     * Set SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SSR_Pref[] $sSR_Pref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setSSR_Pref(array $sSR_Pref = array())
    {
        foreach ($sSR_Pref as $airlinePrefTypeSSR_PrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSSR_PrefItem instanceof \rdyescapiacontent\StructType\SSR_Pref) {
                throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of \rdyescapiacontent\StructType\SSR_Pref, "%s" given', is_object($airlinePrefTypeSSR_PrefItem) ? get_class($airlinePrefTypeSSR_PrefItem) : gettype($airlinePrefTypeSSR_PrefItem)), __LINE__);
            }
        }
        $this->SSR_Pref = $sSR_Pref;
        return $this;
    }
    /**
     * Add item to SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SSR_Pref $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToSSR_Pref(\rdyescapiacontent\StructType\SSR_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\SSR_Pref) {
            throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of \rdyescapiacontent\StructType\SSR_Pref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SSR_Pref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \rdyescapiacontent\StructType\MediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $airlinePrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMediaEntertainPrefItem instanceof \rdyescapiacontent\StructType\MediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \rdyescapiacontent\StructType\MediaEntertainPrefType, "%s" given', is_object($airlinePrefTypeMediaEntertainPrefItem) ? get_class($airlinePrefTypeMediaEntertainPrefItem) : gettype($airlinePrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\MediaEntertainPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToMediaEntertainPref(\rdyescapiacontent\StructType\MediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\MediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \rdyescapiacontent\StructType\MediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \rdyescapiacontent\StructType\PetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PetInfoPrefType[] $petInfoPref
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $airlinePrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePetInfoPrefItem instanceof \rdyescapiacontent\StructType\PetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \rdyescapiacontent\StructType\PetInfoPrefType, "%s" given', is_object($airlinePrefTypePetInfoPrefItem) ? get_class($airlinePrefTypePetInfoPrefItem) : gettype($airlinePrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PetInfoPrefType $item
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function addToPetInfoPref(\rdyescapiacontent\StructType\PetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\PetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \rdyescapiacontent\StructType\PetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AirTicketType value
     * @return string|null
     */
    public function getAirTicketType()
    {
        return $this->AirTicketType;
    }
    /**
     * Set AirTicketType value
     * @uses \rdyescapiacontent\EnumType\TicketType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airTicketType
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public function setAirTicketType($airTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TicketType::valueIsValid($airTicketType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airTicketType, implode(', ', \rdyescapiacontent\EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->AirTicketType = $airTicketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\AirlinePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
