<?php

namespace rdyescapiacontent\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unit ServiceType
 * @subpackage Services
 */
class Unit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnitDescriptiveInfoStream
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapiacontent\StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoStream|bool
     */
    public function UnitDescriptiveInfoStream(\rdyescapiacontent\StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitDescriptiveInfoStream($eVRN_UnitDescriptiveInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvailBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapiacontent\StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ
     * @return \rdyescapiacontent\StructType\EVRN_UnitCalendarAvailBatchRS|bool
     */
    public function UnitCalendarAvailBatch(\rdyescapiacontent\StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitCalendarAvailBatch($eVRN_UnitCalendarAvailBatchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \rdyescapiacontent\StructType\EVRN_UnitCalendarAvailBatchRS|\rdyescapiacontent\StructType\UnitDescriptiveInfoStream
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
