<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfileRentalPrefType StructType
 * @subpackage Structs
 */
class VehicleProfileRentalPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\LoyaltyPref[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PaymentFormPref[]
     */
    public $PaymentFormPref;
    /**
     * The CoveragePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CoveragePref[]
     */
    public $CoveragePref;
    /**
     * The SpecialReqPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\VehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The VehTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\VehiclePrefType[]
     */
    public $VehTypePref;
    /**
     * The SpecialEquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SpecialEquipPref[]
     */
    public $SpecialEquipPref;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The GasPrePay
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $GasPrePay;
    /**
     * Constructor method for VehicleProfileRentalPrefType
     * @uses VehicleProfileRentalPrefType::setLoyaltyPref()
     * @uses VehicleProfileRentalPrefType::setVendorPref()
     * @uses VehicleProfileRentalPrefType::setPaymentFormPref()
     * @uses VehicleProfileRentalPrefType::setCoveragePref()
     * @uses VehicleProfileRentalPrefType::setSpecialReqPref()
     * @uses VehicleProfileRentalPrefType::setVehTypePref()
     * @uses VehicleProfileRentalPrefType::setSpecialEquipPref()
     * @uses VehicleProfileRentalPrefType::setPreferLevel()
     * @uses VehicleProfileRentalPrefType::setShareSynchInd()
     * @uses VehicleProfileRentalPrefType::setShareMarketInd()
     * @uses VehicleProfileRentalPrefType::setSmokingAllowed()
     * @uses VehicleProfileRentalPrefType::setGasPrePay()
     * @param \rdyescapiacontent\StructType\LoyaltyPref[] $loyaltyPref
     * @param \rdyescapiacontent\StructType\CompanyNamePrefType[] $vendorPref
     * @param \rdyescapiacontent\StructType\PaymentFormPref[] $paymentFormPref
     * @param \rdyescapiacontent\StructType\CoveragePref[] $coveragePref
     * @param \rdyescapiacontent\StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @param \rdyescapiacontent\StructType\VehiclePrefType[] $vehTypePref
     * @param \rdyescapiacontent\StructType\SpecialEquipPref[] $specialEquipPref
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param bool $gasPrePay
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $coveragePref = array(), array $specialReqPref = array(), array $vehTypePref = array(), array $specialEquipPref = array(), $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $gasPrePay = false)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setCoveragePref($coveragePref)
            ->setSpecialReqPref($specialReqPref)
            ->setVehTypePref($vehTypePref)
            ->setSpecialEquipPref($specialEquipPref)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setGasPrePay($gasPrePay);
    }
    /**
     * Get LoyaltyPref value
     * @return \rdyescapiacontent\StructType\LoyaltyPref[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyPref[] $loyaltyPref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $vehicleProfileRentalPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeLoyaltyPrefItem instanceof \rdyescapiacontent\StructType\LoyaltyPref) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapiacontent\StructType\LoyaltyPref, "%s" given', is_object($vehicleProfileRentalPrefTypeLoyaltyPrefItem) ? get_class($vehicleProfileRentalPrefTypeLoyaltyPrefItem) : gettype($vehicleProfileRentalPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyPref $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToLoyaltyPref(\rdyescapiacontent\StructType\LoyaltyPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\LoyaltyPref) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapiacontent\StructType\LoyaltyPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \rdyescapiacontent\StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNamePrefType[] $vendorPref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $vehicleProfileRentalPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVendorPrefItem instanceof \rdyescapiacontent\StructType\CompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapiacontent\StructType\CompanyNamePrefType, "%s" given', is_object($vehicleProfileRentalPrefTypeVendorPrefItem) ? get_class($vehicleProfileRentalPrefTypeVendorPrefItem) : gettype($vehicleProfileRentalPrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNamePrefType $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToVendorPref(\rdyescapiacontent\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapiacontent\StructType\CompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \rdyescapiacontent\StructType\PaymentFormPref[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormPref[] $paymentFormPref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $vehicleProfileRentalPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypePaymentFormPrefItem instanceof \rdyescapiacontent\StructType\PaymentFormPref) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapiacontent\StructType\PaymentFormPref, "%s" given', is_object($vehicleProfileRentalPrefTypePaymentFormPrefItem) ? get_class($vehicleProfileRentalPrefTypePaymentFormPrefItem) : gettype($vehicleProfileRentalPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormPref $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToPaymentFormPref(\rdyescapiacontent\StructType\PaymentFormPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\PaymentFormPref) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapiacontent\StructType\PaymentFormPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePref value
     * @return \rdyescapiacontent\StructType\CoveragePref[]|null
     */
    public function getCoveragePref()
    {
        return $this->CoveragePref;
    }
    /**
     * Set CoveragePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CoveragePref[] $coveragePref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setCoveragePref(array $coveragePref = array())
    {
        foreach ($coveragePref as $vehicleProfileRentalPrefTypeCoveragePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeCoveragePrefItem instanceof \rdyescapiacontent\StructType\CoveragePref) {
                throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of \rdyescapiacontent\StructType\CoveragePref, "%s" given', is_object($vehicleProfileRentalPrefTypeCoveragePrefItem) ? get_class($vehicleProfileRentalPrefTypeCoveragePrefItem) : gettype($vehicleProfileRentalPrefTypeCoveragePrefItem)), __LINE__);
            }
        }
        $this->CoveragePref = $coveragePref;
        return $this;
    }
    /**
     * Add item to CoveragePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CoveragePref $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToCoveragePref(\rdyescapiacontent\StructType\CoveragePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CoveragePref) {
            throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of \rdyescapiacontent\StructType\CoveragePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CoveragePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return \rdyescapiacontent\StructType\VehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        foreach ($specialReqPref as $vehicleProfileRentalPrefTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialReqPrefItem instanceof \rdyescapiacontent\StructType\VehicleSpecialReqPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \rdyescapiacontent\StructType\VehicleSpecialReqPrefType, "%s" given', is_object($vehicleProfileRentalPrefTypeSpecialReqPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialReqPrefItem) : gettype($vehicleProfileRentalPrefTypeSpecialReqPrefItem)), __LINE__);
            }
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VehicleSpecialReqPrefType $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToSpecialReqPref(\rdyescapiacontent\StructType\VehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\VehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \rdyescapiacontent\StructType\VehicleSpecialReqPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get VehTypePref value
     * @return \rdyescapiacontent\StructType\VehiclePrefType[]|null
     */
    public function getVehTypePref()
    {
        return $this->VehTypePref;
    }
    /**
     * Set VehTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VehiclePrefType[] $vehTypePref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setVehTypePref(array $vehTypePref = array())
    {
        foreach ($vehTypePref as $vehicleProfileRentalPrefTypeVehTypePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVehTypePrefItem instanceof \rdyescapiacontent\StructType\VehiclePrefType) {
                throw new \InvalidArgumentException(sprintf('The VehTypePref property can only contain items of \rdyescapiacontent\StructType\VehiclePrefType, "%s" given', is_object($vehicleProfileRentalPrefTypeVehTypePrefItem) ? get_class($vehicleProfileRentalPrefTypeVehTypePrefItem) : gettype($vehicleProfileRentalPrefTypeVehTypePrefItem)), __LINE__);
            }
        }
        $this->VehTypePref = $vehTypePref;
        return $this;
    }
    /**
     * Add item to VehTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VehiclePrefType $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToVehTypePref(\rdyescapiacontent\StructType\VehiclePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\VehiclePrefType) {
            throw new \InvalidArgumentException(sprintf('The VehTypePref property can only contain items of \rdyescapiacontent\StructType\VehiclePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehTypePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialEquipPref value
     * @return \rdyescapiacontent\StructType\SpecialEquipPref[]|null
     */
    public function getSpecialEquipPref()
    {
        return $this->SpecialEquipPref;
    }
    /**
     * Set SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SpecialEquipPref[] $specialEquipPref
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setSpecialEquipPref(array $specialEquipPref = array())
    {
        foreach ($specialEquipPref as $vehicleProfileRentalPrefTypeSpecialEquipPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialEquipPrefItem instanceof \rdyescapiacontent\StructType\SpecialEquipPref) {
                throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of \rdyescapiacontent\StructType\SpecialEquipPref, "%s" given', is_object($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) : gettype($vehicleProfileRentalPrefTypeSpecialEquipPrefItem)), __LINE__);
            }
        }
        $this->SpecialEquipPref = $specialEquipPref;
        return $this;
    }
    /**
     * Add item to SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SpecialEquipPref $item
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function addToSpecialEquipPref(\rdyescapiacontent\StructType\SpecialEquipPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\SpecialEquipPref) {
            throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of \rdyescapiacontent\StructType\SpecialEquipPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialEquipPref[] = $item;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public function setGasPrePay($gasPrePay = false)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
