<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitsType StructType
 * @subpackage Structs
 */
class UnitsType extends AbstractStructBase
{
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitValueMatchType[]
     */
    public $Unit;
    /**
     * Constructor method for UnitsType
     * @uses UnitsType::setUnit()
     * @param \rdyescapiacontent\StructType\UnitValueMatchType[] $unit
     */
    public function __construct(array $unit = array())
    {
        $this
            ->setUnit($unit);
    }
    /**
     * Get Unit value
     * @return \rdyescapiacontent\StructType\UnitValueMatchType[]|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitValueMatchType[] $unit
     * @return \rdyescapiacontent\StructType\UnitsType
     */
    public function setUnit(array $unit = array())
    {
        foreach ($unit as $unitsTypeUnitItem) {
            // validation for constraint: itemType
            if (!$unitsTypeUnitItem instanceof \rdyescapiacontent\StructType\UnitValueMatchType) {
                throw new \InvalidArgumentException(sprintf('The Unit property can only contain items of \rdyescapiacontent\StructType\UnitValueMatchType, "%s" given', is_object($unitsTypeUnitItem) ? get_class($unitsTypeUnitItem) : gettype($unitsTypeUnitItem)), __LINE__);
            }
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Add item to Unit value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitValueMatchType $item
     * @return \rdyescapiacontent\StructType\UnitsType
     */
    public function addToUnit(\rdyescapiacontent\StructType\UnitValueMatchType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\UnitValueMatchType) {
            throw new \InvalidArgumentException(sprintf('The Unit property can only contain items of \rdyescapiacontent\StructType\UnitValueMatchType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Unit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
