<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStayType StructType
 * @subpackage Structs
 */
class UnitStayType extends AbstractStructBase
{
    /**
     * The UnitRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfUnitStayTypeUnitRate
     */
    public $UnitRates;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\DateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TotalType
     */
    public $Total;
    /**
     * The BasicUnitInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public $BasicUnitInfo;
    /**
     * The RentalAgreement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfParagraphType
     */
    public $RentalAgreement;
    /**
     * The Pets
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public $Pets;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for UnitStayType
     * @uses UnitStayType::setUnitRates()
     * @uses UnitStayType::setGuestCounts()
     * @uses UnitStayType::setTimeSpan()
     * @uses UnitStayType::setDepositPayments()
     * @uses UnitStayType::setCancelPenalties()
     * @uses UnitStayType::setTotal()
     * @uses UnitStayType::setBasicUnitInfo()
     * @uses UnitStayType::setRentalAgreement()
     * @uses UnitStayType::setPets()
     * @uses UnitStayType::setAvailabilityStatus()
     * @param \rdyescapiacontent\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @param \rdyescapiacontent\StructType\DateTimeSpanType $timeSpan
     * @param \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \rdyescapiacontent\StructType\CancelPenaltiesType $cancelPenalties
     * @param \rdyescapiacontent\StructType\TotalType $total
     * @param \rdyescapiacontent\StructType\BasicUnitInfoType $basicUnitInfo
     * @param \rdyescapiacontent\ArrayType\ArrayOfParagraphType $rentalAgreement
     * @param \rdyescapiacontent\StructType\PetsPoliciesType $pets
     * @param string $availabilityStatus
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates = null, \rdyescapiacontent\StructType\GuestCountType $guestCounts = null, \rdyescapiacontent\StructType\DateTimeSpanType $timeSpan = null, \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \rdyescapiacontent\StructType\CancelPenaltiesType $cancelPenalties = null, \rdyescapiacontent\StructType\TotalType $total = null, \rdyescapiacontent\StructType\BasicUnitInfoType $basicUnitInfo = null, \rdyescapiacontent\ArrayType\ArrayOfParagraphType $rentalAgreement = null, \rdyescapiacontent\StructType\PetsPoliciesType $pets = null, $availabilityStatus = null)
    {
        $this
            ->setUnitRates($unitRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setTotal($total)
            ->setBasicUnitInfo($basicUnitInfo)
            ->setRentalAgreement($rentalAgreement)
            ->setPets($pets)
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get UnitRates value
     * @return \rdyescapiacontent\ArrayType\ArrayOfUnitStayTypeUnitRate|null
     */
    public function getUnitRates()
    {
        return $this->UnitRates;
    }
    /**
     * Set UnitRates value
     * @param \rdyescapiacontent\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setUnitRates(\rdyescapiacontent\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates = null)
    {
        $this->UnitRates = $unitRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapiacontent\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setGuestCounts(\rdyescapiacontent\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \rdyescapiacontent\StructType\DateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \rdyescapiacontent\StructType\DateTimeSpanType $timeSpan
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setTimeSpan(\rdyescapiacontent\StructType\DateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setDepositPayments(\rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \rdyescapiacontent\StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \rdyescapiacontent\StructType\CancelPenaltiesType $cancelPenalties
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setCancelPenalties(\rdyescapiacontent\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Total value
     * @return \rdyescapiacontent\StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \rdyescapiacontent\StructType\TotalType $total
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setTotal(\rdyescapiacontent\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BasicUnitInfo value
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType|null
     */
    public function getBasicUnitInfo()
    {
        return $this->BasicUnitInfo;
    }
    /**
     * Set BasicUnitInfo value
     * @param \rdyescapiacontent\StructType\BasicUnitInfoType $basicUnitInfo
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setBasicUnitInfo(\rdyescapiacontent\StructType\BasicUnitInfoType $basicUnitInfo = null)
    {
        $this->BasicUnitInfo = $basicUnitInfo;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \rdyescapiacontent\ArrayType\ArrayOfParagraphType|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \rdyescapiacontent\ArrayType\ArrayOfParagraphType $rentalAgreement
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setRentalAgreement(\rdyescapiacontent\ArrayType\ArrayOfParagraphType $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get Pets value
     * @return \rdyescapiacontent\StructType\PetsPoliciesType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \rdyescapiacontent\StructType\PetsPoliciesType $pets
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setPets(\rdyescapiacontent\StructType\PetsPoliciesType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \rdyescapiacontent\EnumType\RateIndicatorType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \rdyescapiacontent\EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
