<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStayCandidateType StructType
 * @subpackage Structs
 */
class UnitStayCandidateType extends AbstractStructBase
{
    /**
     * The RoomCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfRoomCountType
     */
    public $RoomCounts;
    /**
     * The BedCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfBedCountType
     */
    public $BedCounts;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The PetsPolicies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public $PetsPolicies;
    /**
     * The NumberFloors
     * @var int
     */
    public $NumberFloors;
    /**
     * The NonSmoking
     * @var bool
     */
    public $NonSmoking;
    /**
     * The AreaSquareFeet
     * @var int
     */
    public $AreaSquareFeet;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The WhenBuilt
     * @var string
     */
    public $WhenBuilt;
    /**
     * Constructor method for UnitStayCandidateType
     * @uses UnitStayCandidateType::setRoomCounts()
     * @uses UnitStayCandidateType::setBedCounts()
     * @uses UnitStayCandidateType::setGuestCounts()
     * @uses UnitStayCandidateType::setPetsPolicies()
     * @uses UnitStayCandidateType::setNumberFloors()
     * @uses UnitStayCandidateType::setNonSmoking()
     * @uses UnitStayCandidateType::setAreaSquareFeet()
     * @uses UnitStayCandidateType::setMaxOccupancy()
     * @uses UnitStayCandidateType::setWhenBuilt()
     * @param \rdyescapiacontent\ArrayType\ArrayOfRoomCountType $roomCounts
     * @param \rdyescapiacontent\ArrayType\ArrayOfBedCountType $bedCounts
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @param \rdyescapiacontent\StructType\PetsPoliciesType $petsPolicies
     * @param int $numberFloors
     * @param bool $nonSmoking
     * @param int $areaSquareFeet
     * @param int $maxOccupancy
     * @param string $whenBuilt
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfRoomCountType $roomCounts = null, \rdyescapiacontent\ArrayType\ArrayOfBedCountType $bedCounts = null, \rdyescapiacontent\StructType\GuestCountType $guestCounts = null, \rdyescapiacontent\StructType\PetsPoliciesType $petsPolicies = null, $numberFloors = null, $nonSmoking = null, $areaSquareFeet = null, $maxOccupancy = null, $whenBuilt = null)
    {
        $this
            ->setRoomCounts($roomCounts)
            ->setBedCounts($bedCounts)
            ->setGuestCounts($guestCounts)
            ->setPetsPolicies($petsPolicies)
            ->setNumberFloors($numberFloors)
            ->setNonSmoking($nonSmoking)
            ->setAreaSquareFeet($areaSquareFeet)
            ->setMaxOccupancy($maxOccupancy)
            ->setWhenBuilt($whenBuilt);
    }
    /**
     * Get RoomCounts value
     * @return \rdyescapiacontent\ArrayType\ArrayOfRoomCountType|null
     */
    public function getRoomCounts()
    {
        return $this->RoomCounts;
    }
    /**
     * Set RoomCounts value
     * @param \rdyescapiacontent\ArrayType\ArrayOfRoomCountType $roomCounts
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setRoomCounts(\rdyescapiacontent\ArrayType\ArrayOfRoomCountType $roomCounts = null)
    {
        $this->RoomCounts = $roomCounts;
        return $this;
    }
    /**
     * Get BedCounts value
     * @return \rdyescapiacontent\ArrayType\ArrayOfBedCountType|null
     */
    public function getBedCounts()
    {
        return $this->BedCounts;
    }
    /**
     * Set BedCounts value
     * @param \rdyescapiacontent\ArrayType\ArrayOfBedCountType $bedCounts
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setBedCounts(\rdyescapiacontent\ArrayType\ArrayOfBedCountType $bedCounts = null)
    {
        $this->BedCounts = $bedCounts;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapiacontent\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setGuestCounts(\rdyescapiacontent\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get PetsPolicies value
     * @return \rdyescapiacontent\StructType\PetsPoliciesType|null
     */
    public function getPetsPolicies()
    {
        return $this->PetsPolicies;
    }
    /**
     * Set PetsPolicies value
     * @param \rdyescapiacontent\StructType\PetsPoliciesType $petsPolicies
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setPetsPolicies(\rdyescapiacontent\StructType\PetsPoliciesType $petsPolicies = null)
    {
        $this->PetsPolicies = $petsPolicies;
        return $this;
    }
    /**
     * Get NumberFloors value
     * @return int|null
     */
    public function getNumberFloors()
    {
        return $this->NumberFloors;
    }
    /**
     * Set NumberFloors value
     * @param int $numberFloors
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setNumberFloors($numberFloors = null)
    {
        // validation for constraint: int
        if (!is_null($numberFloors) && !is_numeric($numberFloors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberFloors)), __LINE__);
        }
        $this->NumberFloors = $numberFloors;
        return $this;
    }
    /**
     * Get NonSmoking value
     * @return bool|null
     */
    public function getNonSmoking()
    {
        return $this->NonSmoking;
    }
    /**
     * Set NonSmoking value
     * @param bool $nonSmoking
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setNonSmoking($nonSmoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonSmoking) && !is_bool($nonSmoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonSmoking)), __LINE__);
        }
        $this->NonSmoking = $nonSmoking;
        return $this;
    }
    /**
     * Get AreaSquareFeet value
     * @return int|null
     */
    public function getAreaSquareFeet()
    {
        return $this->AreaSquareFeet;
    }
    /**
     * Set AreaSquareFeet value
     * @param int $areaSquareFeet
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setAreaSquareFeet($areaSquareFeet = null)
    {
        // validation for constraint: int
        if (!is_null($areaSquareFeet) && !is_numeric($areaSquareFeet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($areaSquareFeet)), __LINE__);
        }
        $this->AreaSquareFeet = $areaSquareFeet;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !is_numeric($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get WhenBuilt value
     * @return string|null
     */
    public function getWhenBuilt()
    {
        return $this->WhenBuilt;
    }
    /**
     * Set WhenBuilt value
     * @param string $whenBuilt
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public function setWhenBuilt($whenBuilt = null)
    {
        // validation for constraint: string
        if (!is_null($whenBuilt) && !is_string($whenBuilt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($whenBuilt)), __LINE__);
        }
        $this->WhenBuilt = $whenBuilt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
