<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transportation StructType
 * @subpackage Structs
 */
class Transportation extends AbstractStructBase
{
    /**
     * The MultimediaDescriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\MultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The OperationSchedules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public $OperationSchedules;
    /**
     * The DescriptiveText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The NotificationRequired
     * @var string
     */
    public $NotificationRequired;
    /**
     * The TransportationCode
     * @var string
     */
    public $TransportationCode;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The Included
     * @var bool
     */
    public $Included;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The TypicalTravelTime
     * @var string
     */
    public $TypicalTravelTime;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * Constructor method for Transportation
     * @uses Transportation::setMultimediaDescriptions()
     * @uses Transportation::setOperationSchedules()
     * @uses Transportation::setDescriptiveText()
     * @uses Transportation::setNotificationRequired()
     * @uses Transportation::setTransportationCode()
     * @uses Transportation::setChargeUnit()
     * @uses Transportation::setIncluded()
     * @uses Transportation::setCodeDetail()
     * @uses Transportation::setDescription()
     * @uses Transportation::setTypicalTravelTime()
     * @uses Transportation::setAmount()
     * @uses Transportation::setExistsCode()
     * @param \rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @param \rdyescapiacontent\StructType\OperationSchedulesType $operationSchedules
     * @param string $descriptiveText
     * @param string $notificationRequired
     * @param string $transportationCode
     * @param string $chargeUnit
     * @param bool $included
     * @param string $codeDetail
     * @param string $description
     * @param string $typicalTravelTime
     * @param float $amount
     * @param string $existsCode
     */
    public function __construct(\rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions = null, \rdyescapiacontent\StructType\OperationSchedulesType $operationSchedules = null, $descriptiveText = null, $notificationRequired = null, $transportationCode = null, $chargeUnit = null, $included = null, $codeDetail = null, $description = null, $typicalTravelTime = null, $amount = null, $existsCode = null)
    {
        $this
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setOperationSchedules($operationSchedules)
            ->setDescriptiveText($descriptiveText)
            ->setNotificationRequired($notificationRequired)
            ->setTransportationCode($transportationCode)
            ->setChargeUnit($chargeUnit)
            ->setIncluded($included)
            ->setCodeDetail($codeDetail)
            ->setDescription($description)
            ->setTypicalTravelTime($typicalTravelTime)
            ->setAmount($amount)
            ->setExistsCode($existsCode);
    }
    /**
     * Get MultimediaDescriptions value
     * @return \rdyescapiacontent\StructType\MultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setMultimediaDescriptions(\rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return \rdyescapiacontent\StructType\OperationSchedulesType|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param \rdyescapiacontent\StructType\OperationSchedulesType $operationSchedules
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setOperationSchedules(\rdyescapiacontent\StructType\OperationSchedulesType $operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get NotificationRequired value
     * @return string|null
     */
    public function getNotificationRequired()
    {
        return $this->NotificationRequired;
    }
    /**
     * Set NotificationRequired value
     * @param string $notificationRequired
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setNotificationRequired($notificationRequired = null)
    {
        // validation for constraint: string
        if (!is_null($notificationRequired) && !is_string($notificationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationRequired)), __LINE__);
        }
        $this->NotificationRequired = $notificationRequired;
        return $this;
    }
    /**
     * Get TransportationCode value
     * @return string|null
     */
    public function getTransportationCode()
    {
        return $this->TransportationCode;
    }
    /**
     * Set TransportationCode value
     * @param string $transportationCode
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setTransportationCode($transportationCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportationCode) && !is_string($transportationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportationCode)), __LINE__);
        }
        $this->TransportationCode = $transportationCode;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get Included value
     * @return bool|null
     */
    public function getIncluded()
    {
        return $this->Included;
    }
    /**
     * Set Included value
     * @param bool $included
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setIncluded($included = null)
    {
        // validation for constraint: boolean
        if (!is_null($included) && !is_bool($included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($included)), __LINE__);
        }
        $this->Included = $included;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TypicalTravelTime value
     * @return string|null
     */
    public function getTypicalTravelTime()
    {
        return $this->TypicalTravelTime;
    }
    /**
     * Set TypicalTravelTime value
     * @param string $typicalTravelTime
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setTypicalTravelTime($typicalTravelTime = null)
    {
        // validation for constraint: string
        if (!is_null($typicalTravelTime) && !is_string($typicalTravelTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typicalTravelTime)), __LINE__);
        }
        $this->TypicalTravelTime = $typicalTravelTime;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\Transportation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
