<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxesType StructType
 * @subpackage Structs
 */
class TaxesType extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TaxType[]
     */
    public $Tax;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for TaxesType
     * @uses TaxesType::setTax()
     * @uses TaxesType::setAmount()
     * @param \rdyescapiacontent\StructType\TaxType[] $tax
     * @param float $amount
     */
    public function __construct(array $tax = array(), $amount = null)
    {
        $this
            ->setTax($tax)
            ->setAmount($amount);
    }
    /**
     * Get Tax value
     * @return \rdyescapiacontent\StructType\TaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TaxType[] $tax
     * @return \rdyescapiacontent\StructType\TaxesType
     */
    public function setTax(array $tax = array())
    {
        foreach ($tax as $taxesTypeTaxItem) {
            // validation for constraint: itemType
            if (!$taxesTypeTaxItem instanceof \rdyescapiacontent\StructType\TaxType) {
                throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of \rdyescapiacontent\StructType\TaxType, "%s" given', is_object($taxesTypeTaxItem) ? get_class($taxesTypeTaxItem) : gettype($taxesTypeTaxItem)), __LINE__);
            }
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TaxType $item
     * @return \rdyescapiacontent\StructType\TaxesType
     */
    public function addToTax(\rdyescapiacontent\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of \rdyescapiacontent\StructType\TaxType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \rdyescapiacontent\StructType\TaxesType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\TaxesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
