<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartDateWindow StructType
 * @subpackage Structs
 */
class StartDateWindow extends AbstractStructBase
{
    /**
     * The EarliestDate
     * @var string
     */
    public $EarliestDate;
    /**
     * The LatestDate
     * @var string
     */
    public $LatestDate;
    /**
     * The DOW
     * @var string
     */
    public $DOW;
    /**
     * Constructor method for StartDateWindow
     * @uses StartDateWindow::setEarliestDate()
     * @uses StartDateWindow::setLatestDate()
     * @uses StartDateWindow::setDOW()
     * @param string $earliestDate
     * @param string $latestDate
     * @param string $dOW
     */
    public function __construct($earliestDate = null, $latestDate = null, $dOW = null)
    {
        $this
            ->setEarliestDate($earliestDate)
            ->setLatestDate($latestDate)
            ->setDOW($dOW);
    }
    /**
     * Get EarliestDate value
     * @return string|null
     */
    public function getEarliestDate()
    {
        return $this->EarliestDate;
    }
    /**
     * Set EarliestDate value
     * @param string $earliestDate
     * @return \rdyescapiacontent\StructType\StartDateWindow
     */
    public function setEarliestDate($earliestDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDate) && !is_string($earliestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earliestDate)), __LINE__);
        }
        $this->EarliestDate = $earliestDate;
        return $this;
    }
    /**
     * Get LatestDate value
     * @return string|null
     */
    public function getLatestDate()
    {
        return $this->LatestDate;
    }
    /**
     * Set LatestDate value
     * @param string $latestDate
     * @return \rdyescapiacontent\StructType\StartDateWindow
     */
    public function setLatestDate($latestDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestDate) && !is_string($latestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latestDate)), __LINE__);
        }
        $this->LatestDate = $latestDate;
        return $this;
    }
    /**
     * Get DOW value
     * @return string|null
     */
    public function getDOW()
    {
        return $this->DOW;
    }
    /**
     * Set DOW value
     * @uses \rdyescapiacontent\EnumType\DayOfWeekType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dOW
     * @return \rdyescapiacontent\StructType\StartDateWindow
     */
    public function setDOW($dOW = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\DayOfWeekType::valueIsValid($dOW)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dOW, implode(', ', \rdyescapiacontent\EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DOW = $dOW;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\StartDateWindow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
