<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviewCommentType StructType
 * @subpackage Structs
 */
class ReviewCommentType extends AbstractStructBase
{
    /**
     * The Comment
     * @var string
     */
    public $Comment;
    /**
     * The CategoryID
     * @var int
     */
    public $CategoryID;
    /**
     * The CategoryName
     * @var string
     */
    public $CategoryName;
    /**
     * The CategoryType
     * @var string
     */
    public $CategoryType;
    /**
     * The SortOrder
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for ReviewCommentType
     * @uses ReviewCommentType::setComment()
     * @uses ReviewCommentType::setCategoryID()
     * @uses ReviewCommentType::setCategoryName()
     * @uses ReviewCommentType::setCategoryType()
     * @uses ReviewCommentType::setSortOrder()
     * @param string $comment
     * @param int $categoryID
     * @param string $categoryName
     * @param string $categoryType
     * @param int $sortOrder
     */
    public function __construct($comment = null, $categoryID = null, $categoryName = null, $categoryType = null, $sortOrder = null)
    {
        $this
            ->setComment($comment)
            ->setCategoryID($categoryID)
            ->setCategoryName($categoryName)
            ->setCategoryType($categoryType)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \rdyescapiacontent\StructType\ReviewCommentType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \rdyescapiacontent\StructType\ReviewCommentType
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \rdyescapiacontent\StructType\ReviewCommentType
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param string $categoryType
     * @return \rdyescapiacontent\StructType\ReviewCommentType
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: string
        if (!is_null($categoryType) && !is_string($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \rdyescapiacontent\StructType\ReviewCommentType
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\ReviewCommentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
