<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRange StructType
 * @subpackage Structs
 */
class RateRange extends AbstractStructBase
{
    /**
     * The RateType
     * @var string
     */
    public $RateType;
    /**
     * The MinRate
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * @var float
     */
    public $MaxRate;
    /**
     * The FixedRate
     * @var float
     */
    public $FixedRate;
    /**
     * The FullRate
     * @var float
     */
    public $FullRate;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The MinRent
     * @var float
     */
    public $MinRent;
    /**
     * The MaxRent
     * @var float
     */
    public $MaxRent;
    /**
     * The FixedRent
     * @var float
     */
    public $FixedRent;
    /**
     * The FullRent
     * @var float
     */
    public $FullRent;
    /**
     * The MinFees
     * @var float
     */
    public $MinFees;
    /**
     * The MaxFees
     * @var float
     */
    public $MaxFees;
    /**
     * The FixedFees
     * @var float
     */
    public $FixedFees;
    /**
     * The FullFees
     * @var float
     */
    public $FullFees;
    /**
     * The MinTax
     * @var float
     */
    public $MinTax;
    /**
     * The MaxTax
     * @var float
     */
    public $MaxTax;
    /**
     * The FixedTax
     * @var float
     */
    public $FixedTax;
    /**
     * The FullTax
     * @var float
     */
    public $FullTax;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The TaxRate
     * @var float
     */
    public $TaxRate;
    /**
     * The RateInfoNotAvailableInd
     * @var bool
     */
    public $RateInfoNotAvailableInd;
    /**
     * The CommissionPercent
     * @var float
     */
    public $CommissionPercent;
    /**
     * The MinCommissionPercent
     * @var float
     */
    public $MinCommissionPercent;
    /**
     * The MaxCommissionPercent
     * @var float
     */
    public $MaxCommissionPercent;
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * Constructor method for RateRange
     * @uses RateRange::setRateType()
     * @uses RateRange::setMinRate()
     * @uses RateRange::setMaxRate()
     * @uses RateRange::setFixedRate()
     * @uses RateRange::setFullRate()
     * @uses RateRange::setRateTimeUnit()
     * @uses RateRange::setMinRent()
     * @uses RateRange::setMaxRent()
     * @uses RateRange::setFixedRent()
     * @uses RateRange::setFullRent()
     * @uses RateRange::setMinFees()
     * @uses RateRange::setMaxFees()
     * @uses RateRange::setFixedFees()
     * @uses RateRange::setFullFees()
     * @uses RateRange::setMinTax()
     * @uses RateRange::setMaxTax()
     * @uses RateRange::setFixedTax()
     * @uses RateRange::setFullTax()
     * @uses RateRange::setInfoSource()
     * @uses RateRange::setTaxRate()
     * @uses RateRange::setRateInfoNotAvailableInd()
     * @uses RateRange::setCommissionPercent()
     * @uses RateRange::setMinCommissionPercent()
     * @uses RateRange::setMaxCommissionPercent()
     * @uses RateRange::setRoomStayCandidateRPH()
     * @param string $rateType
     * @param float $minRate
     * @param float $maxRate
     * @param float $fixedRate
     * @param float $fullRate
     * @param string $rateTimeUnit
     * @param float $minRent
     * @param float $maxRent
     * @param float $fixedRent
     * @param float $fullRent
     * @param float $minFees
     * @param float $maxFees
     * @param float $fixedFees
     * @param float $fullFees
     * @param float $minTax
     * @param float $maxTax
     * @param float $fixedTax
     * @param float $fullTax
     * @param string $infoSource
     * @param float $taxRate
     * @param bool $rateInfoNotAvailableInd
     * @param float $commissionPercent
     * @param float $minCommissionPercent
     * @param float $maxCommissionPercent
     * @param string $roomStayCandidateRPH
     */
    public function __construct($rateType = null, $minRate = null, $maxRate = null, $fixedRate = null, $fullRate = null, $rateTimeUnit = null, $minRent = null, $maxRent = null, $fixedRent = null, $fullRent = null, $minFees = null, $maxFees = null, $fixedFees = null, $fullFees = null, $minTax = null, $maxTax = null, $fixedTax = null, $fullTax = null, $infoSource = null, $taxRate = null, $rateInfoNotAvailableInd = null, $commissionPercent = null, $minCommissionPercent = null, $maxCommissionPercent = null, $roomStayCandidateRPH = null)
    {
        $this
            ->setRateType($rateType)
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setFixedRate($fixedRate)
            ->setFullRate($fullRate)
            ->setRateTimeUnit($rateTimeUnit)
            ->setMinRent($minRent)
            ->setMaxRent($maxRent)
            ->setFixedRent($fixedRent)
            ->setFullRent($fullRent)
            ->setMinFees($minFees)
            ->setMaxFees($maxFees)
            ->setFixedFees($fixedFees)
            ->setFullFees($fullFees)
            ->setMinTax($minTax)
            ->setMaxTax($maxTax)
            ->setFixedTax($fixedTax)
            ->setFullTax($fullTax)
            ->setInfoSource($infoSource)
            ->setTaxRate($taxRate)
            ->setRateInfoNotAvailableInd($rateInfoNotAvailableInd)
            ->setCommissionPercent($commissionPercent)
            ->setMinCommissionPercent($minCommissionPercent)
            ->setMaxCommissionPercent($maxCommissionPercent)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH);
    }
    /**
     * Get RateType value
     * @return string|null
     */
    public function getRateType()
    {
        return $this->RateType;
    }
    /**
     * Set RateType value
     * @uses \rdyescapiacontent\EnumType\RateTypeType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\RateTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateType
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setRateType($rateType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\RateTypeType::valueIsValid($rateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rateType, implode(', ', \rdyescapiacontent\EnumType\RateTypeType::getValidValues())), __LINE__);
        }
        $this->RateType = $rateType;
        return $this;
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMinRate($minRate = null)
    {
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMaxRate($maxRate = null)
    {
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get FixedRate value
     * @return float|null
     */
    public function getFixedRate()
    {
        return $this->FixedRate;
    }
    /**
     * Set FixedRate value
     * @param float $fixedRate
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFixedRate($fixedRate = null)
    {
        $this->FixedRate = $fixedRate;
        return $this;
    }
    /**
     * Get FullRate value
     * @return float|null
     */
    public function getFullRate()
    {
        return $this->FullRate;
    }
    /**
     * Set FullRate value
     * @param float $fullRate
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFullRate($fullRate = null)
    {
        $this->FullRate = $fullRate;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rateTimeUnit, implode(', ', \rdyescapiacontent\EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get MinRent value
     * @return float|null
     */
    public function getMinRent()
    {
        return $this->MinRent;
    }
    /**
     * Set MinRent value
     * @param float $minRent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMinRent($minRent = null)
    {
        $this->MinRent = $minRent;
        return $this;
    }
    /**
     * Get MaxRent value
     * @return float|null
     */
    public function getMaxRent()
    {
        return $this->MaxRent;
    }
    /**
     * Set MaxRent value
     * @param float $maxRent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMaxRent($maxRent = null)
    {
        $this->MaxRent = $maxRent;
        return $this;
    }
    /**
     * Get FixedRent value
     * @return float|null
     */
    public function getFixedRent()
    {
        return $this->FixedRent;
    }
    /**
     * Set FixedRent value
     * @param float $fixedRent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFixedRent($fixedRent = null)
    {
        $this->FixedRent = $fixedRent;
        return $this;
    }
    /**
     * Get FullRent value
     * @return float|null
     */
    public function getFullRent()
    {
        return $this->FullRent;
    }
    /**
     * Set FullRent value
     * @param float $fullRent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFullRent($fullRent = null)
    {
        $this->FullRent = $fullRent;
        return $this;
    }
    /**
     * Get MinFees value
     * @return float|null
     */
    public function getMinFees()
    {
        return $this->MinFees;
    }
    /**
     * Set MinFees value
     * @param float $minFees
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMinFees($minFees = null)
    {
        $this->MinFees = $minFees;
        return $this;
    }
    /**
     * Get MaxFees value
     * @return float|null
     */
    public function getMaxFees()
    {
        return $this->MaxFees;
    }
    /**
     * Set MaxFees value
     * @param float $maxFees
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMaxFees($maxFees = null)
    {
        $this->MaxFees = $maxFees;
        return $this;
    }
    /**
     * Get FixedFees value
     * @return float|null
     */
    public function getFixedFees()
    {
        return $this->FixedFees;
    }
    /**
     * Set FixedFees value
     * @param float $fixedFees
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFixedFees($fixedFees = null)
    {
        $this->FixedFees = $fixedFees;
        return $this;
    }
    /**
     * Get FullFees value
     * @return float|null
     */
    public function getFullFees()
    {
        return $this->FullFees;
    }
    /**
     * Set FullFees value
     * @param float $fullFees
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFullFees($fullFees = null)
    {
        $this->FullFees = $fullFees;
        return $this;
    }
    /**
     * Get MinTax value
     * @return float|null
     */
    public function getMinTax()
    {
        return $this->MinTax;
    }
    /**
     * Set MinTax value
     * @param float $minTax
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMinTax($minTax = null)
    {
        $this->MinTax = $minTax;
        return $this;
    }
    /**
     * Get MaxTax value
     * @return float|null
     */
    public function getMaxTax()
    {
        return $this->MaxTax;
    }
    /**
     * Set MaxTax value
     * @param float $maxTax
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMaxTax($maxTax = null)
    {
        $this->MaxTax = $maxTax;
        return $this;
    }
    /**
     * Get FixedTax value
     * @return float|null
     */
    public function getFixedTax()
    {
        return $this->FixedTax;
    }
    /**
     * Set FixedTax value
     * @param float $fixedTax
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFixedTax($fixedTax = null)
    {
        $this->FixedTax = $fixedTax;
        return $this;
    }
    /**
     * Get FullTax value
     * @return float|null
     */
    public function getFullTax()
    {
        return $this->FullTax;
    }
    /**
     * Set FullTax value
     * @param float $fullTax
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setFullTax($fullTax = null)
    {
        $this->FullTax = $fullTax;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setTaxRate($taxRate = null)
    {
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get RateInfoNotAvailableInd value
     * @return bool|null
     */
    public function getRateInfoNotAvailableInd()
    {
        return $this->RateInfoNotAvailableInd;
    }
    /**
     * Set RateInfoNotAvailableInd value
     * @param bool $rateInfoNotAvailableInd
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setRateInfoNotAvailableInd($rateInfoNotAvailableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateInfoNotAvailableInd) && !is_bool($rateInfoNotAvailableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rateInfoNotAvailableInd)), __LINE__);
        }
        $this->RateInfoNotAvailableInd = $rateInfoNotAvailableInd;
        return $this;
    }
    /**
     * Get CommissionPercent value
     * @return float|null
     */
    public function getCommissionPercent()
    {
        return $this->CommissionPercent;
    }
    /**
     * Set CommissionPercent value
     * @param float $commissionPercent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setCommissionPercent($commissionPercent = null)
    {
        $this->CommissionPercent = $commissionPercent;
        return $this;
    }
    /**
     * Get MinCommissionPercent value
     * @return float|null
     */
    public function getMinCommissionPercent()
    {
        return $this->MinCommissionPercent;
    }
    /**
     * Set MinCommissionPercent value
     * @param float $minCommissionPercent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMinCommissionPercent($minCommissionPercent = null)
    {
        $this->MinCommissionPercent = $minCommissionPercent;
        return $this;
    }
    /**
     * Get MaxCommissionPercent value
     * @return float|null
     */
    public function getMaxCommissionPercent()
    {
        return $this->MaxCommissionPercent;
    }
    /**
     * Set MaxCommissionPercent value
     * @param float $maxCommissionPercent
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setMaxCommissionPercent($maxCommissionPercent = null)
    {
        $this->MaxCommissionPercent = $maxCommissionPercent;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\RateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
