<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * @subpackage Structs
 */
class ProfileType extends AbstractStructBase
{
    /**
     * The Accesses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AccessesType
     */
    public $Accesses;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CustomerType
     */
    public $Customer;
    /**
     * The PrefCollections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PreferencesType
     */
    public $PrefCollections;
    /**
     * The CompanyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyInfoType
     */
    public $CompanyInfo;
    /**
     * The Affiliations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AffiliationsType
     */
    public $Affiliations;
    /**
     * The Agreements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AgreementsType
     */
    public $Agreements;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareAllSynchInd
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $ShareAllSynchInd;
    /**
     * The ShareAllMarketInd
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $ShareAllMarketInd;
    /**
     * The ProfileType
     * @var string
     */
    public $ProfileType;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for ProfileType
     * @uses ProfileType::setAccesses()
     * @uses ProfileType::setCustomer()
     * @uses ProfileType::setPrefCollections()
     * @uses ProfileType::setCompanyInfo()
     * @uses ProfileType::setAffiliations()
     * @uses ProfileType::setAgreements()
     * @uses ProfileType::setTPA_Extensions()
     * @uses ProfileType::setShareAllSynchInd()
     * @uses ProfileType::setShareAllMarketInd()
     * @uses ProfileType::setProfileType()
     * @uses ProfileType::setCreateDateTime()
     * @uses ProfileType::setCreatorID()
     * @uses ProfileType::setLastModifyDateTime()
     * @uses ProfileType::setLastModifierID()
     * @uses ProfileType::setRPH()
     * @param \rdyescapiacontent\StructType\AccessesType $accesses
     * @param \rdyescapiacontent\StructType\CustomerType $customer
     * @param \rdyescapiacontent\StructType\PreferencesType $prefCollections
     * @param \rdyescapiacontent\StructType\CompanyInfoType $companyInfo
     * @param \rdyescapiacontent\StructType\AffiliationsType $affiliations
     * @param \rdyescapiacontent\StructType\AgreementsType $agreements
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareAllSynchInd
     * @param string $shareAllMarketInd
     * @param string $profileType
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $rPH
     */
    public function __construct(\rdyescapiacontent\StructType\AccessesType $accesses = null, \rdyescapiacontent\StructType\CustomerType $customer = null, \rdyescapiacontent\StructType\PreferencesType $prefCollections = null, \rdyescapiacontent\StructType\CompanyInfoType $companyInfo = null, \rdyescapiacontent\StructType\AffiliationsType $affiliations = null, \rdyescapiacontent\StructType\AgreementsType $agreements = null, \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareAllSynchInd = 'No', $shareAllMarketInd = 'No', $profileType = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $rPH = null)
    {
        $this
            ->setAccesses($accesses)
            ->setCustomer($customer)
            ->setPrefCollections($prefCollections)
            ->setCompanyInfo($companyInfo)
            ->setAffiliations($affiliations)
            ->setAgreements($agreements)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareAllSynchInd($shareAllSynchInd)
            ->setShareAllMarketInd($shareAllMarketInd)
            ->setProfileType($profileType)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setRPH($rPH);
    }
    /**
     * Get Accesses value
     * @return \rdyescapiacontent\StructType\AccessesType|null
     */
    public function getAccesses()
    {
        return $this->Accesses;
    }
    /**
     * Set Accesses value
     * @param \rdyescapiacontent\StructType\AccessesType $accesses
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setAccesses(\rdyescapiacontent\StructType\AccessesType $accesses = null)
    {
        $this->Accesses = $accesses;
        return $this;
    }
    /**
     * Get Customer value
     * @return \rdyescapiacontent\StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \rdyescapiacontent\StructType\CustomerType $customer
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setCustomer(\rdyescapiacontent\StructType\CustomerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get PrefCollections value
     * @return \rdyescapiacontent\StructType\PreferencesType|null
     */
    public function getPrefCollections()
    {
        return $this->PrefCollections;
    }
    /**
     * Set PrefCollections value
     * @param \rdyescapiacontent\StructType\PreferencesType $prefCollections
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setPrefCollections(\rdyescapiacontent\StructType\PreferencesType $prefCollections = null)
    {
        $this->PrefCollections = $prefCollections;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return \rdyescapiacontent\StructType\CompanyInfoType|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param \rdyescapiacontent\StructType\CompanyInfoType $companyInfo
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setCompanyInfo(\rdyescapiacontent\StructType\CompanyInfoType $companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get Affiliations value
     * @return \rdyescapiacontent\StructType\AffiliationsType|null
     */
    public function getAffiliations()
    {
        return $this->Affiliations;
    }
    /**
     * Set Affiliations value
     * @param \rdyescapiacontent\StructType\AffiliationsType $affiliations
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setAffiliations(\rdyescapiacontent\StructType\AffiliationsType $affiliations = null)
    {
        $this->Affiliations = $affiliations;
        return $this;
    }
    /**
     * Get Agreements value
     * @return \rdyescapiacontent\StructType\AgreementsType|null
     */
    public function getAgreements()
    {
        return $this->Agreements;
    }
    /**
     * Set Agreements value
     * @param \rdyescapiacontent\StructType\AgreementsType $agreements
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setAgreements(\rdyescapiacontent\StructType\AgreementsType $agreements = null)
    {
        $this->Agreements = $agreements;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareAllSynchInd value
     * @return string|null
     */
    public function getShareAllSynchInd()
    {
        return $this->ShareAllSynchInd;
    }
    /**
     * Set ShareAllSynchInd value
     * @uses \rdyescapiacontent\EnumType\YesNoType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllSynchInd
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setShareAllSynchInd($shareAllSynchInd = 'No')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\YesNoType::valueIsValid($shareAllSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shareAllSynchInd, implode(', ', \rdyescapiacontent\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllSynchInd = $shareAllSynchInd;
        return $this;
    }
    /**
     * Get ShareAllMarketInd value
     * @return string|null
     */
    public function getShareAllMarketInd()
    {
        return $this->ShareAllMarketInd;
    }
    /**
     * Set ShareAllMarketInd value
     * @uses \rdyescapiacontent\EnumType\YesNoType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllMarketInd
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setShareAllMarketInd($shareAllMarketInd = 'No')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\YesNoType::valueIsValid($shareAllMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shareAllMarketInd, implode(', ', \rdyescapiacontent\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllMarketInd = $shareAllMarketInd;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\ProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
