<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrefCollection StructType
 * @subpackage Structs
 */
class PrefCollection extends AbstractStructBase
{
    /**
     * The CommonPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CommonPrefType[]
     */
    public $CommonPref;
    /**
     * The VehicleRentalPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\VehicleProfileRentalPrefType[]
     */
    public $VehicleRentalPref;
    /**
     * The AirlinePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AirlinePrefType[]
     */
    public $AirlinePref;
    /**
     * The HotelPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\HotelPrefType[]
     */
    public $HotelPref;
    /**
     * The OtherSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\OtherSrvcPrefType[]
     */
    public $OtherSrvcPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for PrefCollection
     * @uses PrefCollection::setCommonPref()
     * @uses PrefCollection::setVehicleRentalPref()
     * @uses PrefCollection::setAirlinePref()
     * @uses PrefCollection::setHotelPref()
     * @uses PrefCollection::setOtherSrvcPref()
     * @uses PrefCollection::setTPA_Extensions()
     * @uses PrefCollection::setShareSynchInd()
     * @uses PrefCollection::setShareMarketInd()
     * @uses PrefCollection::setTravelPurpose()
     * @param \rdyescapiacontent\StructType\CommonPrefType[] $commonPref
     * @param \rdyescapiacontent\StructType\VehicleProfileRentalPrefType[] $vehicleRentalPref
     * @param \rdyescapiacontent\StructType\AirlinePrefType[] $airlinePref
     * @param \rdyescapiacontent\StructType\HotelPrefType[] $hotelPref
     * @param \rdyescapiacontent\StructType\OtherSrvcPrefType[] $otherSrvcPref
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $travelPurpose
     */
    public function __construct(array $commonPref = array(), array $vehicleRentalPref = array(), array $airlinePref = array(), array $hotelPref = array(), array $otherSrvcPref = array(), \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $travelPurpose = null)
    {
        $this
            ->setCommonPref($commonPref)
            ->setVehicleRentalPref($vehicleRentalPref)
            ->setAirlinePref($airlinePref)
            ->setHotelPref($hotelPref)
            ->setOtherSrvcPref($otherSrvcPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get CommonPref value
     * @return \rdyescapiacontent\StructType\CommonPrefType[]|null
     */
    public function getCommonPref()
    {
        return $this->CommonPref;
    }
    /**
     * Set CommonPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CommonPrefType[] $commonPref
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setCommonPref(array $commonPref = array())
    {
        foreach ($commonPref as $prefCollectionCommonPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionCommonPrefItem instanceof \rdyescapiacontent\StructType\CommonPrefType) {
                throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of \rdyescapiacontent\StructType\CommonPrefType, "%s" given', is_object($prefCollectionCommonPrefItem) ? get_class($prefCollectionCommonPrefItem) : gettype($prefCollectionCommonPrefItem)), __LINE__);
            }
        }
        $this->CommonPref = $commonPref;
        return $this;
    }
    /**
     * Add item to CommonPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CommonPrefType $item
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function addToCommonPref(\rdyescapiacontent\StructType\CommonPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CommonPrefType) {
            throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of \rdyescapiacontent\StructType\CommonPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommonPref[] = $item;
        return $this;
    }
    /**
     * Get VehicleRentalPref value
     * @return \rdyescapiacontent\StructType\VehicleProfileRentalPrefType[]|null
     */
    public function getVehicleRentalPref()
    {
        return $this->VehicleRentalPref;
    }
    /**
     * Set VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VehicleProfileRentalPrefType[] $vehicleRentalPref
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setVehicleRentalPref(array $vehicleRentalPref = array())
    {
        foreach ($vehicleRentalPref as $prefCollectionVehicleRentalPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionVehicleRentalPrefItem instanceof \rdyescapiacontent\StructType\VehicleProfileRentalPrefType) {
                throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of \rdyescapiacontent\StructType\VehicleProfileRentalPrefType, "%s" given', is_object($prefCollectionVehicleRentalPrefItem) ? get_class($prefCollectionVehicleRentalPrefItem) : gettype($prefCollectionVehicleRentalPrefItem)), __LINE__);
            }
        }
        $this->VehicleRentalPref = $vehicleRentalPref;
        return $this;
    }
    /**
     * Add item to VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VehicleProfileRentalPrefType $item
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function addToVehicleRentalPref(\rdyescapiacontent\StructType\VehicleProfileRentalPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\VehicleProfileRentalPrefType) {
            throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of \rdyescapiacontent\StructType\VehicleProfileRentalPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleRentalPref[] = $item;
        return $this;
    }
    /**
     * Get AirlinePref value
     * @return \rdyescapiacontent\StructType\AirlinePrefType[]|null
     */
    public function getAirlinePref()
    {
        return $this->AirlinePref;
    }
    /**
     * Set AirlinePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AirlinePrefType[] $airlinePref
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setAirlinePref(array $airlinePref = array())
    {
        foreach ($airlinePref as $prefCollectionAirlinePrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionAirlinePrefItem instanceof \rdyescapiacontent\StructType\AirlinePrefType) {
                throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of \rdyescapiacontent\StructType\AirlinePrefType, "%s" given', is_object($prefCollectionAirlinePrefItem) ? get_class($prefCollectionAirlinePrefItem) : gettype($prefCollectionAirlinePrefItem)), __LINE__);
            }
        }
        $this->AirlinePref = $airlinePref;
        return $this;
    }
    /**
     * Add item to AirlinePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AirlinePrefType $item
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function addToAirlinePref(\rdyescapiacontent\StructType\AirlinePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AirlinePrefType) {
            throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of \rdyescapiacontent\StructType\AirlinePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirlinePref[] = $item;
        return $this;
    }
    /**
     * Get HotelPref value
     * @return \rdyescapiacontent\StructType\HotelPrefType[]|null
     */
    public function getHotelPref()
    {
        return $this->HotelPref;
    }
    /**
     * Set HotelPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\HotelPrefType[] $hotelPref
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setHotelPref(array $hotelPref = array())
    {
        foreach ($hotelPref as $prefCollectionHotelPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionHotelPrefItem instanceof \rdyescapiacontent\StructType\HotelPrefType) {
                throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of \rdyescapiacontent\StructType\HotelPrefType, "%s" given', is_object($prefCollectionHotelPrefItem) ? get_class($prefCollectionHotelPrefItem) : gettype($prefCollectionHotelPrefItem)), __LINE__);
            }
        }
        $this->HotelPref = $hotelPref;
        return $this;
    }
    /**
     * Add item to HotelPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\HotelPrefType $item
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function addToHotelPref(\rdyescapiacontent\StructType\HotelPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\HotelPrefType) {
            throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of \rdyescapiacontent\StructType\HotelPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelPref[] = $item;
        return $this;
    }
    /**
     * Get OtherSrvcPref value
     * @return \rdyescapiacontent\StructType\OtherSrvcPrefType[]|null
     */
    public function getOtherSrvcPref()
    {
        return $this->OtherSrvcPref;
    }
    /**
     * Set OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\OtherSrvcPrefType[] $otherSrvcPref
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setOtherSrvcPref(array $otherSrvcPref = array())
    {
        foreach ($otherSrvcPref as $prefCollectionOtherSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionOtherSrvcPrefItem instanceof \rdyescapiacontent\StructType\OtherSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of \rdyescapiacontent\StructType\OtherSrvcPrefType, "%s" given', is_object($prefCollectionOtherSrvcPrefItem) ? get_class($prefCollectionOtherSrvcPrefItem) : gettype($prefCollectionOtherSrvcPrefItem)), __LINE__);
            }
        }
        $this->OtherSrvcPref = $otherSrvcPref;
        return $this;
    }
    /**
     * Add item to OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\OtherSrvcPrefType $item
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function addToOtherSrvcPref(\rdyescapiacontent\StructType\OtherSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\OtherSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of \rdyescapiacontent\StructType\OtherSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OtherSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\PrefCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
