<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PetsPoliciesType StructType
 * @subpackage Structs
 */
class PetsPoliciesType extends AbstractStructBase
{
    /**
     * The PetsPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PetsPolicy[]
     */
    public $PetsPolicy;
    /**
     * The PetsAllowedCode
     * @var string
     */
    public $PetsAllowedCode;
    /**
     * Constructor method for PetsPoliciesType
     * @uses PetsPoliciesType::setPetsPolicy()
     * @uses PetsPoliciesType::setPetsAllowedCode()
     * @param \rdyescapiacontent\StructType\PetsPolicy[] $petsPolicy
     * @param string $petsAllowedCode
     */
    public function __construct(array $petsPolicy = array(), $petsAllowedCode = null)
    {
        $this
            ->setPetsPolicy($petsPolicy)
            ->setPetsAllowedCode($petsAllowedCode);
    }
    /**
     * Get PetsPolicy value
     * @return \rdyescapiacontent\StructType\PetsPolicy[]|null
     */
    public function getPetsPolicy()
    {
        return $this->PetsPolicy;
    }
    /**
     * Set PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PetsPolicy[] $petsPolicy
     * @return \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public function setPetsPolicy(array $petsPolicy = array())
    {
        foreach ($petsPolicy as $petsPoliciesTypePetsPolicyItem) {
            // validation for constraint: itemType
            if (!$petsPoliciesTypePetsPolicyItem instanceof \rdyescapiacontent\StructType\PetsPolicy) {
                throw new \InvalidArgumentException(sprintf('The PetsPolicy property can only contain items of \rdyescapiacontent\StructType\PetsPolicy, "%s" given', is_object($petsPoliciesTypePetsPolicyItem) ? get_class($petsPoliciesTypePetsPolicyItem) : gettype($petsPoliciesTypePetsPolicyItem)), __LINE__);
            }
        }
        $this->PetsPolicy = $petsPolicy;
        return $this;
    }
    /**
     * Add item to PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PetsPolicy $item
     * @return \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public function addToPetsPolicy(\rdyescapiacontent\StructType\PetsPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\PetsPolicy) {
            throw new \InvalidArgumentException(sprintf('The PetsPolicy property can only contain items of \rdyescapiacontent\StructType\PetsPolicy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetsPolicy[] = $item;
        return $this;
    }
    /**
     * Get PetsAllowedCode value
     * @return string|null
     */
    public function getPetsAllowedCode()
    {
        return $this->PetsAllowedCode;
    }
    /**
     * Set PetsAllowedCode value
     * @uses \rdyescapiacontent\EnumType\PetsAllowedCodeType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PetsAllowedCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $petsAllowedCode
     * @return \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public function setPetsAllowedCode($petsAllowedCode = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PetsAllowedCodeType::valueIsValid($petsAllowedCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $petsAllowedCode, implode(', ', \rdyescapiacontent\EnumType\PetsAllowedCodeType::getValidValues())), __LINE__);
        }
        $this->PetsAllowedCode = $petsAllowedCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
