<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamePrefType StructType
 * @subpackage Structs
 */
class NamePrefType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for NamePrefType
     * @uses NamePrefType::setUniqueID()
     * @uses NamePrefType::setPersonName()
     * @uses NamePrefType::setPreferLevel()
     * @param \rdyescapiacontent\StructType\UniqueID_Type $uniqueID
     * @param \rdyescapiacontent\StructType\PersonNameType $personName
     * @param string $preferLevel
     */
    public function __construct(\rdyescapiacontent\StructType\UniqueID_Type $uniqueID = null, \rdyescapiacontent\StructType\PersonNameType $personName = null, $preferLevel = 'Preferred')
    {
        $this
            ->setUniqueID($uniqueID)
            ->setPersonName($personName)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapiacontent\StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \rdyescapiacontent\StructType\UniqueID_Type $uniqueID
     * @return \rdyescapiacontent\StructType\NamePrefType
     */
    public function setUniqueID(\rdyescapiacontent\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \rdyescapiacontent\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapiacontent\StructType\PersonNameType $personName
     * @return \rdyescapiacontent\StructType\NamePrefType
     */
    public function setPersonName(\rdyescapiacontent\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapiacontent\StructType\NamePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\NamePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
