<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InquiryRequestType StructType
 * @subpackage Structs
 */
class InquiryRequestType extends AbstractStructBase
{
    /**
     * The UnitRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Contact
     */
    public $Contact;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\FormattedTextTextType
     */
    public $Message;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Source
     */
    public $Source;
    /**
     * The StayDateRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The InquiryType
     * @var string
     */
    public $InquiryType;
    /**
     * The InquiryDate
     * @var string
     */
    public $InquiryDate;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * Constructor method for InquiryRequestType
     * @uses InquiryRequestType::setUnitRef()
     * @uses InquiryRequestType::setContact()
     * @uses InquiryRequestType::setMessage()
     * @uses InquiryRequestType::setSource()
     * @uses InquiryRequestType::setStayDateRange()
     * @uses InquiryRequestType::setGuestCounts()
     * @uses InquiryRequestType::setInquiryType()
     * @uses InquiryRequestType::setInquiryDate()
     * @uses InquiryRequestType::setTransactionIdentifier()
     * @param \rdyescapiacontent\StructType\UnitRef $unitRef
     * @param \rdyescapiacontent\StructType\Contact $contact
     * @param \rdyescapiacontent\StructType\FormattedTextTextType $message
     * @param \rdyescapiacontent\StructType\Source $source
     * @param \rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @param string $inquiryType
     * @param string $inquiryDate
     * @param string $transactionIdentifier
     */
    public function __construct(\rdyescapiacontent\StructType\UnitRef $unitRef = null, \rdyescapiacontent\StructType\Contact $contact = null, \rdyescapiacontent\StructType\FormattedTextTextType $message = null, \rdyescapiacontent\StructType\Source $source = null, \rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange = null, \rdyescapiacontent\StructType\GuestCountType $guestCounts = null, $inquiryType = null, $inquiryDate = null, $transactionIdentifier = null)
    {
        $this
            ->setUnitRef($unitRef)
            ->setContact($contact)
            ->setMessage($message)
            ->setSource($source)
            ->setStayDateRange($stayDateRange)
            ->setGuestCounts($guestCounts)
            ->setInquiryType($inquiryType)
            ->setInquiryDate($inquiryDate)
            ->setTransactionIdentifier($transactionIdentifier);
    }
    /**
     * Get UnitRef value
     * @return \rdyescapiacontent\StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \rdyescapiacontent\StructType\UnitRef $unitRef
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setUnitRef(\rdyescapiacontent\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get Contact value
     * @return \rdyescapiacontent\StructType\Contact|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \rdyescapiacontent\StructType\Contact $contact
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setContact(\rdyescapiacontent\StructType\Contact $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Message value
     * @return \rdyescapiacontent\StructType\FormattedTextTextType|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \rdyescapiacontent\StructType\FormattedTextTextType $message
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setMessage(\rdyescapiacontent\StructType\FormattedTextTextType $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Source value
     * @return \rdyescapiacontent\StructType\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \rdyescapiacontent\StructType\Source $source
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setSource(\rdyescapiacontent\StructType\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \rdyescapiacontent\StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setStayDateRange(\rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapiacontent\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setGuestCounts(\rdyescapiacontent\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get InquiryType value
     * @return string|null
     */
    public function getInquiryType()
    {
        return $this->InquiryType;
    }
    /**
     * Set InquiryType value
     * @param string $inquiryType
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setInquiryType($inquiryType = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryType) && !is_string($inquiryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inquiryType)), __LINE__);
        }
        $this->InquiryType = $inquiryType;
        return $this;
    }
    /**
     * Get InquiryDate value
     * @return string|null
     */
    public function getInquiryDate()
    {
        return $this->InquiryDate;
    }
    /**
     * Set InquiryDate value
     * @param string $inquiryDate
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setInquiryDate($inquiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryDate) && !is_string($inquiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inquiryDate)), __LINE__);
        }
        $this->InquiryDate = $inquiryDate;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\InquiryRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
