<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePayment StructType
 * @subpackage Structs
 */
class GuaranteePayment extends AbstractStructBase
{
    /**
     * The AcceptedPayments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfPaymentFormType
     */
    public $AcceptedPayments;
    /**
     * The AmountPercent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AmountPercentType
     */
    public $AmountPercent;
    /**
     * The Deadline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Deadline
     */
    public $Deadline;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Address[]
     */
    public $Address;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The RetributionType
     * @var string
     */
    public $RetributionType;
    /**
     * The PaymentCode
     * @var string
     */
    public $PaymentCode;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The GuaranteeCode
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The GuaranteeType
     * @var string
     */
    public $GuaranteeType;
    /**
     * The HoldTime
     * @var string
     */
    public $HoldTime;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The NoCardHolderInfoReqInd
     * @var bool
     */
    public $NoCardHolderInfoReqInd;
    /**
     * The NameInd
     * @var bool
     */
    public $NameInd;
    /**
     * The AddressInd
     * @var bool
     */
    public $AddressInd;
    /**
     * The PhoneInd
     * @var bool
     */
    public $PhoneInd;
    /**
     * The InterbankNbrInd
     * @var bool
     */
    public $InterbankNbrInd;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The NonRefundableIndicator
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * Constructor method for GuaranteePayment
     * @uses GuaranteePayment::setAcceptedPayments()
     * @uses GuaranteePayment::setAmountPercent()
     * @uses GuaranteePayment::setDeadline()
     * @uses GuaranteePayment::setDescription()
     * @uses GuaranteePayment::setAddress()
     * @uses GuaranteePayment::setTPA_Extensions()
     * @uses GuaranteePayment::setRetributionType()
     * @uses GuaranteePayment::setPaymentCode()
     * @uses GuaranteePayment::setType()
     * @uses GuaranteePayment::setGuaranteeCode()
     * @uses GuaranteePayment::setGuaranteeType()
     * @uses GuaranteePayment::setHoldTime()
     * @uses GuaranteePayment::setMon()
     * @uses GuaranteePayment::setTue()
     * @uses GuaranteePayment::setWeds()
     * @uses GuaranteePayment::setThur()
     * @uses GuaranteePayment::setFri()
     * @uses GuaranteePayment::setSat()
     * @uses GuaranteePayment::setSun()
     * @uses GuaranteePayment::setStart()
     * @uses GuaranteePayment::setDuration()
     * @uses GuaranteePayment::setEnd()
     * @uses GuaranteePayment::setNoCardHolderInfoReqInd()
     * @uses GuaranteePayment::setNameInd()
     * @uses GuaranteePayment::setAddressInd()
     * @uses GuaranteePayment::setPhoneInd()
     * @uses GuaranteePayment::setInterbankNbrInd()
     * @uses GuaranteePayment::setRoomTypeCode()
     * @uses GuaranteePayment::setInfoSource()
     * @uses GuaranteePayment::setNonRefundableIndicator()
     * @param \rdyescapiacontent\ArrayType\ArrayOfPaymentFormType $acceptedPayments
     * @param \rdyescapiacontent\StructType\AmountPercentType $amountPercent
     * @param \rdyescapiacontent\StructType\Deadline $deadline
     * @param \rdyescapiacontent\StructType\ParagraphType[] $description
     * @param \rdyescapiacontent\StructType\Address[] $address
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $retributionType
     * @param string $paymentCode
     * @param string $type
     * @param string $guaranteeCode
     * @param string $guaranteeType
     * @param string $holdTime
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param bool $noCardHolderInfoReqInd
     * @param bool $nameInd
     * @param bool $addressInd
     * @param bool $phoneInd
     * @param bool $interbankNbrInd
     * @param string $roomTypeCode
     * @param string $infoSource
     * @param bool $nonRefundableIndicator
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfPaymentFormType $acceptedPayments = null, \rdyescapiacontent\StructType\AmountPercentType $amountPercent = null, \rdyescapiacontent\StructType\Deadline $deadline = null, array $description = array(), array $address = array(), \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, $retributionType = null, $paymentCode = null, $type = null, $guaranteeCode = null, $guaranteeType = null, $holdTime = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $start = null, $duration = null, $end = null, $noCardHolderInfoReqInd = null, $nameInd = null, $addressInd = null, $phoneInd = null, $interbankNbrInd = null, $roomTypeCode = null, $infoSource = null, $nonRefundableIndicator = null)
    {
        $this
            ->setAcceptedPayments($acceptedPayments)
            ->setAmountPercent($amountPercent)
            ->setDeadline($deadline)
            ->setDescription($description)
            ->setAddress($address)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRetributionType($retributionType)
            ->setPaymentCode($paymentCode)
            ->setType($type)
            ->setGuaranteeCode($guaranteeCode)
            ->setGuaranteeType($guaranteeType)
            ->setHoldTime($holdTime)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setNoCardHolderInfoReqInd($noCardHolderInfoReqInd)
            ->setNameInd($nameInd)
            ->setAddressInd($addressInd)
            ->setPhoneInd($phoneInd)
            ->setInterbankNbrInd($interbankNbrInd)
            ->setRoomTypeCode($roomTypeCode)
            ->setInfoSource($infoSource)
            ->setNonRefundableIndicator($nonRefundableIndicator);
    }
    /**
     * Get AcceptedPayments value
     * @return \rdyescapiacontent\ArrayType\ArrayOfPaymentFormType|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param \rdyescapiacontent\ArrayType\ArrayOfPaymentFormType $acceptedPayments
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setAcceptedPayments(\rdyescapiacontent\ArrayType\ArrayOfPaymentFormType $acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \rdyescapiacontent\StructType\AmountPercentType|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \rdyescapiacontent\StructType\AmountPercentType $amountPercent
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setAmountPercent(\rdyescapiacontent\StructType\AmountPercentType $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get Deadline value
     * @return \rdyescapiacontent\StructType\Deadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \rdyescapiacontent\StructType\Deadline $deadline
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setDeadline(\rdyescapiacontent\StructType\Deadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get Description value
     * @return \rdyescapiacontent\StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType[] $description
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $guaranteePaymentDescriptionItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentDescriptionItem instanceof \rdyescapiacontent\StructType\ParagraphType) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \rdyescapiacontent\StructType\ParagraphType, "%s" given', is_object($guaranteePaymentDescriptionItem) ? get_class($guaranteePaymentDescriptionItem) : gettype($guaranteePaymentDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType $item
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function addToDescription(\rdyescapiacontent\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \rdyescapiacontent\StructType\ParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapiacontent\StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Address[] $address
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $guaranteePaymentAddressItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentAddressItem instanceof \rdyescapiacontent\StructType\Address) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \rdyescapiacontent\StructType\Address, "%s" given', is_object($guaranteePaymentAddressItem) ? get_class($guaranteePaymentAddressItem) : gettype($guaranteePaymentAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Address $item
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function addToAddress(\rdyescapiacontent\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \rdyescapiacontent\StructType\Address, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return string|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param string $retributionType
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setRetributionType($retributionType = null)
    {
        // validation for constraint: string
        if (!is_null($retributionType) && !is_string($retributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retributionType)), __LINE__);
        }
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get GuaranteeCode value
     * @return string|null
     */
    public function getGuaranteeCode()
    {
        return $this->GuaranteeCode;
    }
    /**
     * Set GuaranteeCode value
     * @param string $guaranteeCode
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setGuaranteeCode($guaranteeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeCode) && !is_string($guaranteeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guaranteeCode)), __LINE__);
        }
        $this->GuaranteeCode = $guaranteeCode;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeType) && !is_string($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guaranteeType)), __LINE__);
        }
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get HoldTime value
     * @return string|null
     */
    public function getHoldTime()
    {
        return $this->HoldTime;
    }
    /**
     * Set HoldTime value
     * @param string $holdTime
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setHoldTime($holdTime = null)
    {
        // validation for constraint: string
        if (!is_null($holdTime) && !is_string($holdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holdTime)), __LINE__);
        }
        $this->HoldTime = $holdTime;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get NoCardHolderInfoReqInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoReqInd()
    {
        return $this->NoCardHolderInfoReqInd;
    }
    /**
     * Set NoCardHolderInfoReqInd value
     * @param bool $noCardHolderInfoReqInd
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setNoCardHolderInfoReqInd($noCardHolderInfoReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCardHolderInfoReqInd) && !is_bool($noCardHolderInfoReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noCardHolderInfoReqInd)), __LINE__);
        }
        $this->NoCardHolderInfoReqInd = $noCardHolderInfoReqInd;
        return $this;
    }
    /**
     * Get NameInd value
     * @return bool|null
     */
    public function getNameInd()
    {
        return $this->NameInd;
    }
    /**
     * Set NameInd value
     * @param bool $nameInd
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setNameInd($nameInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nameInd) && !is_bool($nameInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nameInd)), __LINE__);
        }
        $this->NameInd = $nameInd;
        return $this;
    }
    /**
     * Get AddressInd value
     * @return bool|null
     */
    public function getAddressInd()
    {
        return $this->AddressInd;
    }
    /**
     * Set AddressInd value
     * @param bool $addressInd
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setAddressInd($addressInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressInd) && !is_bool($addressInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($addressInd)), __LINE__);
        }
        $this->AddressInd = $addressInd;
        return $this;
    }
    /**
     * Get PhoneInd value
     * @return bool|null
     */
    public function getPhoneInd()
    {
        return $this->PhoneInd;
    }
    /**
     * Set PhoneInd value
     * @param bool $phoneInd
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setPhoneInd($phoneInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneInd) && !is_bool($phoneInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($phoneInd)), __LINE__);
        }
        $this->PhoneInd = $phoneInd;
        return $this;
    }
    /**
     * Get InterbankNbrInd value
     * @return bool|null
     */
    public function getInterbankNbrInd()
    {
        return $this->InterbankNbrInd;
    }
    /**
     * Set InterbankNbrInd value
     * @param bool $interbankNbrInd
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setInterbankNbrInd($interbankNbrInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($interbankNbrInd) && !is_bool($interbankNbrInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($interbankNbrInd)), __LINE__);
        }
        $this->InterbankNbrInd = $interbankNbrInd;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableIndicator) && !is_bool($nonRefundableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRefundableIndicator)), __LINE__);
        }
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\GuaranteePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
