<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedTextSubSectionType StructType
 * @subpackage Structs
 */
class FormattedTextSubSectionType extends AbstractStructBase
{
    /**
     * The Paragraph
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType[]
     */
    public $Paragraph;
    /**
     * The SubTitle
     * @var string
     */
    public $SubTitle;
    /**
     * The SubCode
     * @var string
     */
    public $SubCode;
    /**
     * The SubSectionNumber
     * @var int
     */
    public $SubSectionNumber;
    /**
     * Constructor method for FormattedTextSubSectionType
     * @uses FormattedTextSubSectionType::setParagraph()
     * @uses FormattedTextSubSectionType::setSubTitle()
     * @uses FormattedTextSubSectionType::setSubCode()
     * @uses FormattedTextSubSectionType::setSubSectionNumber()
     * @param \rdyescapiacontent\StructType\ParagraphType[] $paragraph
     * @param string $subTitle
     * @param string $subCode
     * @param int $subSectionNumber
     */
    public function __construct(array $paragraph = array(), $subTitle = null, $subCode = null, $subSectionNumber = null)
    {
        $this
            ->setParagraph($paragraph)
            ->setSubTitle($subTitle)
            ->setSubCode($subCode)
            ->setSubSectionNumber($subSectionNumber);
    }
    /**
     * Get Paragraph value
     * @return \rdyescapiacontent\StructType\ParagraphType[]|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * Set Paragraph value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType[] $paragraph
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setParagraph(array $paragraph = array())
    {
        foreach ($paragraph as $formattedTextSubSectionTypeParagraphItem) {
            // validation for constraint: itemType
            if (!$formattedTextSubSectionTypeParagraphItem instanceof \rdyescapiacontent\StructType\ParagraphType) {
                throw new \InvalidArgumentException(sprintf('The Paragraph property can only contain items of \rdyescapiacontent\StructType\ParagraphType, "%s" given', is_object($formattedTextSubSectionTypeParagraphItem) ? get_class($formattedTextSubSectionTypeParagraphItem) : gettype($formattedTextSubSectionTypeParagraphItem)), __LINE__);
            }
        }
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Add item to Paragraph value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType $item
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function addToParagraph(\rdyescapiacontent\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Paragraph property can only contain items of \rdyescapiacontent\StructType\ParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Paragraph[] = $item;
        return $this;
    }
    /**
     * Get SubTitle value
     * @return string|null
     */
    public function getSubTitle()
    {
        return $this->SubTitle;
    }
    /**
     * Set SubTitle value
     * @param string $subTitle
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setSubTitle($subTitle = null)
    {
        // validation for constraint: string
        if (!is_null($subTitle) && !is_string($subTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subTitle)), __LINE__);
        }
        $this->SubTitle = $subTitle;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setSubCode($subCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCode) && !is_string($subCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subCode)), __LINE__);
        }
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Get SubSectionNumber value
     * @return int|null
     */
    public function getSubSectionNumber()
    {
        return $this->SubSectionNumber;
    }
    /**
     * Set SubSectionNumber value
     * @param int $subSectionNumber
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setSubSectionNumber($subSectionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($subSectionNumber) && !is_numeric($subSectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subSectionNumber)), __LINE__);
        }
        $this->SubSectionNumber = $subSectionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
