<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployerType StructType
 * @subpackage Structs
 */
class EmployerType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The RelatedEmployer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType[]
     */
    public $RelatedEmployer;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The InternalRefNmbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\FreeTextType[]
     */
    public $InternalRefNmbr;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\LoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * The DefaultInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for EmployerType
     * @uses EmployerType::setCompanyName()
     * @uses EmployerType::setRelatedEmployer()
     * @uses EmployerType::setEmployeeInfo()
     * @uses EmployerType::setInternalRefNmbr()
     * @uses EmployerType::setTravelArranger()
     * @uses EmployerType::setLoyaltyProgram()
     * @uses EmployerType::setDefaultInd()
     * @uses EmployerType::setOfficeType()
     * @uses EmployerType::setEffectiveDate()
     * @uses EmployerType::setExpireDate()
     * @param \rdyescapiacontent\StructType\CompanyNameType $companyName
     * @param \rdyescapiacontent\StructType\CompanyNameType[] $relatedEmployer
     * @param \rdyescapiacontent\StructType\EmployeeInfoType[] $employeeInfo
     * @param \rdyescapiacontent\StructType\FreeTextType[] $internalRefNmbr
     * @param \rdyescapiacontent\StructType\TravelArrangerType[] $travelArranger
     * @param \rdyescapiacontent\StructType\LoyaltyProgramType[] $loyaltyProgram
     * @param bool $defaultInd
     * @param string $officeType
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\rdyescapiacontent\StructType\CompanyNameType $companyName = null, array $relatedEmployer = array(), array $employeeInfo = array(), array $internalRefNmbr = array(), array $travelArranger = array(), array $loyaltyProgram = array(), $defaultInd = false, $officeType = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setRelatedEmployer($relatedEmployer)
            ->setEmployeeInfo($employeeInfo)
            ->setInternalRefNmbr($internalRefNmbr)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setDefaultInd($defaultInd)
            ->setOfficeType($officeType)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CompanyName value
     * @return \rdyescapiacontent\StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \rdyescapiacontent\StructType\CompanyNameType $companyName
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setCompanyName(\rdyescapiacontent\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get RelatedEmployer value
     * @return \rdyescapiacontent\StructType\CompanyNameType[]|null
     */
    public function getRelatedEmployer()
    {
        return $this->RelatedEmployer;
    }
    /**
     * Set RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNameType[] $relatedEmployer
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setRelatedEmployer(array $relatedEmployer = array())
    {
        foreach ($relatedEmployer as $employerTypeRelatedEmployerItem) {
            // validation for constraint: itemType
            if (!$employerTypeRelatedEmployerItem instanceof \rdyescapiacontent\StructType\CompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of \rdyescapiacontent\StructType\CompanyNameType, "%s" given', is_object($employerTypeRelatedEmployerItem) ? get_class($employerTypeRelatedEmployerItem) : gettype($employerTypeRelatedEmployerItem)), __LINE__);
            }
        }
        $this->RelatedEmployer = $relatedEmployer;
        return $this;
    }
    /**
     * Add item to RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNameType $item
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function addToRelatedEmployer(\rdyescapiacontent\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of \rdyescapiacontent\StructType\CompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedEmployer[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \rdyescapiacontent\StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmployeeInfoType[] $employeeInfo
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $employerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$employerTypeEmployeeInfoItem instanceof \rdyescapiacontent\StructType\EmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \rdyescapiacontent\StructType\EmployeeInfoType, "%s" given', is_object($employerTypeEmployeeInfoItem) ? get_class($employerTypeEmployeeInfoItem) : gettype($employerTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmployeeInfoType $item
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function addToEmployeeInfo(\rdyescapiacontent\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \rdyescapiacontent\StructType\EmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get InternalRefNmbr value
     * @return \rdyescapiacontent\StructType\FreeTextType[]|null
     */
    public function getInternalRefNmbr()
    {
        return $this->InternalRefNmbr;
    }
    /**
     * Set InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\FreeTextType[] $internalRefNmbr
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setInternalRefNmbr(array $internalRefNmbr = array())
    {
        foreach ($internalRefNmbr as $employerTypeInternalRefNmbrItem) {
            // validation for constraint: itemType
            if (!$employerTypeInternalRefNmbrItem instanceof \rdyescapiacontent\StructType\FreeTextType) {
                throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of \rdyescapiacontent\StructType\FreeTextType, "%s" given', is_object($employerTypeInternalRefNmbrItem) ? get_class($employerTypeInternalRefNmbrItem) : gettype($employerTypeInternalRefNmbrItem)), __LINE__);
            }
        }
        $this->InternalRefNmbr = $internalRefNmbr;
        return $this;
    }
    /**
     * Add item to InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\FreeTextType $item
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function addToInternalRefNmbr(\rdyescapiacontent\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of \rdyescapiacontent\StructType\FreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InternalRefNmbr[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapiacontent\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $employerTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$employerTypeTravelArrangerItem instanceof \rdyescapiacontent\StructType\TravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \rdyescapiacontent\StructType\TravelArrangerType, "%s" given', is_object($employerTypeTravelArrangerItem) ? get_class($employerTypeTravelArrangerItem) : gettype($employerTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelArrangerType $item
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function addToTravelArranger(\rdyescapiacontent\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \rdyescapiacontent\StructType\TravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \rdyescapiacontent\StructType\LoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyProgramType[] $loyaltyProgram
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        foreach ($loyaltyProgram as $employerTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$employerTypeLoyaltyProgramItem instanceof \rdyescapiacontent\StructType\LoyaltyProgramType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \rdyescapiacontent\StructType\LoyaltyProgramType, "%s" given', is_object($employerTypeLoyaltyProgramItem) ? get_class($employerTypeLoyaltyProgramItem) : gettype($employerTypeLoyaltyProgramItem)), __LINE__);
            }
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyProgramType $item
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function addToLoyaltyProgram(\rdyescapiacontent\StructType\LoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\LoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \rdyescapiacontent\StructType\LoyaltyProgramType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \rdyescapiacontent\EnumType\OfficeLocationType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\OfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\OfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $officeType, implode(', ', \rdyescapiacontent\EnumType\OfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\EmployerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
