<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountType StructType
 * Meta informations extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class DiscountType extends TotalType
{
    /**
     * The DiscountReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType
     */
    public $DiscountReason;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The DiscountCode
     * @var string
     */
    public $DiscountCode;
    /**
     * Constructor method for DiscountType
     * @uses DiscountType::setDiscountReason()
     * @uses DiscountType::setTaxInclusive()
     * @uses DiscountType::setPercent()
     * @uses DiscountType::setDiscountCode()
     * @param \rdyescapiacontent\StructType\ParagraphType $discountReason
     * @param bool $taxInclusive
     * @param float $percent
     * @param string $discountCode
     */
    public function __construct(\rdyescapiacontent\StructType\ParagraphType $discountReason = null, $taxInclusive = null, $percent = null, $discountCode = null)
    {
        $this
            ->setDiscountReason($discountReason)
            ->setTaxInclusive($taxInclusive)
            ->setPercent($percent)
            ->setDiscountCode($discountCode);
    }
    /**
     * Get DiscountReason value
     * @return \rdyescapiacontent\StructType\ParagraphType|null
     */
    public function getDiscountReason()
    {
        return $this->DiscountReason;
    }
    /**
     * Set DiscountReason value
     * @param \rdyescapiacontent\StructType\ParagraphType $discountReason
     * @return \rdyescapiacontent\StructType\DiscountType
     */
    public function setDiscountReason(\rdyescapiacontent\StructType\ParagraphType $discountReason = null)
    {
        $this->DiscountReason = $discountReason;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \rdyescapiacontent\StructType\DiscountType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \rdyescapiacontent\StructType\DiscountType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \rdyescapiacontent\StructType\DiscountType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\DiscountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
