<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Areas StructType
 * @subpackage Structs
 */
class Areas extends AbstractStructBase
{
    /**
     * The Area
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SearchAreaType[]
     */
    public $Area;
    /**
     * The PlaceHolder
     * @var int
     */
    public $PlaceHolder;
    /**
     * Constructor method for Areas
     * @uses Areas::setArea()
     * @uses Areas::setPlaceHolder()
     * @param \rdyescapiacontent\StructType\SearchAreaType[] $area
     * @param int $placeHolder
     */
    public function __construct(array $area = array(), $placeHolder = null)
    {
        $this
            ->setArea($area)
            ->setPlaceHolder($placeHolder);
    }
    /**
     * Get Area value
     * @return \rdyescapiacontent\StructType\SearchAreaType[]|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SearchAreaType[] $area
     * @return \rdyescapiacontent\StructType\Areas
     */
    public function setArea(array $area = array())
    {
        foreach ($area as $areasAreaItem) {
            // validation for constraint: itemType
            if (!$areasAreaItem instanceof \rdyescapiacontent\StructType\SearchAreaType) {
                throw new \InvalidArgumentException(sprintf('The Area property can only contain items of \rdyescapiacontent\StructType\SearchAreaType, "%s" given', is_object($areasAreaItem) ? get_class($areasAreaItem) : gettype($areasAreaItem)), __LINE__);
            }
        }
        $this->Area = $area;
        return $this;
    }
    /**
     * Add item to Area value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SearchAreaType $item
     * @return \rdyescapiacontent\StructType\Areas
     */
    public function addToArea(\rdyescapiacontent\StructType\SearchAreaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\SearchAreaType) {
            throw new \InvalidArgumentException(sprintf('The Area property can only contain items of \rdyescapiacontent\StructType\SearchAreaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Area[] = $item;
        return $this;
    }
    /**
     * Get PlaceHolder value
     * @return int|null
     */
    public function getPlaceHolder()
    {
        return $this->PlaceHolder;
    }
    /**
     * Set PlaceHolder value
     * @param int $placeHolder
     * @return \rdyescapiacontent\StructType\Areas
     */
    public function setPlaceHolder($placeHolder = null)
    {
        // validation for constraint: int
        if (!is_null($placeHolder) && !is_numeric($placeHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($placeHolder)), __LINE__);
        }
        $this->PlaceHolder = $placeHolder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\Areas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
