<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalChargeType StructType
 * @subpackage Structs
 */
class AdditionalChargeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TotalType
     */
    public $Amount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ChargeTemplateID
     * @var int
     */
    public $ChargeTemplateID;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AdditionalChargeType
     * @uses AdditionalChargeType::setAmount()
     * @uses AdditionalChargeType::setDescription()
     * @uses AdditionalChargeType::setCode()
     * @uses AdditionalChargeType::setChargeTemplateID()
     * @uses AdditionalChargeType::setQuantity()
     * @param \rdyescapiacontent\StructType\TotalType $amount
     * @param \rdyescapiacontent\StructType\ParagraphType[] $description
     * @param string $code
     * @param int $chargeTemplateID
     * @param int $quantity
     */
    public function __construct(\rdyescapiacontent\StructType\TotalType $amount = null, array $description = array(), $code = null, $chargeTemplateID = null, $quantity = null)
    {
        $this
            ->setAmount($amount)
            ->setDescription($description)
            ->setCode($code)
            ->setChargeTemplateID($chargeTemplateID)
            ->setQuantity($quantity);
    }
    /**
     * Get Amount value
     * @return \rdyescapiacontent\StructType\TotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \rdyescapiacontent\StructType\TotalType $amount
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public function setAmount(\rdyescapiacontent\StructType\TotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Description value
     * @return \rdyescapiacontent\StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType[] $description
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $additionalChargeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$additionalChargeTypeDescriptionItem instanceof \rdyescapiacontent\StructType\ParagraphType) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \rdyescapiacontent\StructType\ParagraphType, "%s" given', is_object($additionalChargeTypeDescriptionItem) ? get_class($additionalChargeTypeDescriptionItem) : gettype($additionalChargeTypeDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType $item
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public function addToDescription(\rdyescapiacontent\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \rdyescapiacontent\StructType\ParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ChargeTemplateID value
     * @return int|null
     */
    public function getChargeTemplateID()
    {
        return $this->ChargeTemplateID;
    }
    /**
     * Set ChargeTemplateID value
     * @param int $chargeTemplateID
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public function setChargeTemplateID($chargeTemplateID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTemplateID) && !is_numeric($chargeTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeTemplateID)), __LINE__);
        }
        $this->ChargeTemplateID = $chargeTemplateID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\AdditionalChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
