<?php

namespace rdyescapiacontent\EnumType;

/**
 * This class stands for GuaranteeType EnumType
 * @subpackage Enumerations
 */
class GuaranteeType
{
    /**
     * Constant for value 'GuaranteeRequired'
     * @return string 'GuaranteeRequired'
     */
    const VALUE_GUARANTEE_REQUIRED = 'GuaranteeRequired';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'CC/DC/Voucher'
     * @return string 'CC/DC/Voucher'
     */
    const VALUE_CC_DC_VOUCHER = 'CC/DC/Voucher';
    /**
     * Constant for value 'Profile'
     * @return string 'Profile'
     */
    const VALUE_PROFILE = 'Profile';
    /**
     * Constant for value 'Deposit'
     * @return string 'Deposit'
     */
    const VALUE_DEPOSIT = 'Deposit';
    /**
     * Constant for value 'PrePay'
     * @return string 'PrePay'
     */
    const VALUE_PRE_PAY = 'PrePay';
    /**
     * The GuaranteesAccepted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfGuaranteeTypeGuaranteeAccepted
     */
    public $GuaranteesAccepted;
    /**
     * The Deadline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Deadline
     */
    public $Deadline;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The GuaranteeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType[]
     */
    public $GuaranteeDescription;
    /**
     * The RetributionType
     * @var string
     */
    public $RetributionType;
    /**
     * The GuaranteeCode
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The GuaranteeType
     * @var string
     */
    public $GuaranteeType;
    /**
     * The HoldTime
     * @var string
     */
    public $HoldTime;
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GUARANTEE_REQUIRED
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CC_DC_VOUCHER
     * @uses self::VALUE_PROFILE
     * @uses self::VALUE_DEPOSIT
     * @uses self::VALUE_PRE_PAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GUARANTEE_REQUIRED,
            self::VALUE_NONE,
            self::VALUE_CC_DC_VOUCHER,
            self::VALUE_PROFILE,
            self::VALUE_DEPOSIT,
            self::VALUE_PRE_PAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
