<?php

namespace rdyescapiacontent\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomCountType ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomCountType extends AbstractStructArrayBase
{
    /**
     * The RoomCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\RoomCountType[]
     */
    public $RoomCount;
    /**
     * Constructor method for ArrayOfRoomCountType
     * @uses ArrayOfRoomCountType::setRoomCount()
     * @param \rdyescapiacontent\StructType\RoomCountType[] $roomCount
     */
    public function __construct(array $roomCount = array())
    {
        $this
            ->setRoomCount($roomCount);
    }
    /**
     * Get RoomCount value
     * @return \rdyescapiacontent\StructType\RoomCountType[]|null
     */
    public function getRoomCount()
    {
        return $this->RoomCount;
    }
    /**
     * Set RoomCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\RoomCountType[] $roomCount
     * @return \rdyescapiacontent\ArrayType\ArrayOfRoomCountType
     */
    public function setRoomCount(array $roomCount = array())
    {
        foreach ($roomCount as $arrayOfRoomCountTypeRoomCountItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomCountTypeRoomCountItem instanceof \rdyescapiacontent\StructType\RoomCountType) {
                throw new \InvalidArgumentException(sprintf('The RoomCount property can only contain items of \rdyescapiacontent\StructType\RoomCountType, "%s" given', is_object($arrayOfRoomCountTypeRoomCountItem) ? get_class($arrayOfRoomCountTypeRoomCountItem) : gettype($arrayOfRoomCountTypeRoomCountItem)), __LINE__);
            }
        }
        $this->RoomCount = $roomCount;
        return $this;
    }
    /**
     * Add item to RoomCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\RoomCountType $item
     * @return \rdyescapiacontent\ArrayType\ArrayOfRoomCountType
     */
    public function addToRoomCount(\rdyescapiacontent\StructType\RoomCountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\RoomCountType) {
            throw new \InvalidArgumentException(sprintf('The RoomCount property can only contain items of \rdyescapiacontent\StructType\RoomCountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomCount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapiacontent\StructType\RoomCountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapiacontent\StructType\RoomCountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapiacontent\StructType\RoomCountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapiacontent\StructType\RoomCountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapiacontent\StructType\RoomCountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomCount
     */
    public function getAttributeName()
    {
        return 'RoomCount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\ArrayType\ArrayOfRoomCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
