<?php

namespace rdyescapiacontent\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMembershipTypeMembership ArrayType
 * @subpackage Arrays
 */
class ArrayOfMembershipTypeMembership extends AbstractStructArrayBase
{
    /**
     * The Membership
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Membership[]
     */
    public $Membership;
    /**
     * Constructor method for ArrayOfMembershipTypeMembership
     * @uses ArrayOfMembershipTypeMembership::setMembership()
     * @param \rdyescapiacontent\StructType\Membership[] $membership
     */
    public function __construct(array $membership = array())
    {
        $this
            ->setMembership($membership);
    }
    /**
     * Get Membership value
     * @return \rdyescapiacontent\StructType\Membership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Membership[] $membership
     * @return \rdyescapiacontent\ArrayType\ArrayOfMembershipTypeMembership
     */
    public function setMembership(array $membership = array())
    {
        foreach ($membership as $arrayOfMembershipTypeMembershipMembershipItem) {
            // validation for constraint: itemType
            if (!$arrayOfMembershipTypeMembershipMembershipItem instanceof \rdyescapiacontent\StructType\Membership) {
                throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \rdyescapiacontent\StructType\Membership, "%s" given', is_object($arrayOfMembershipTypeMembershipMembershipItem) ? get_class($arrayOfMembershipTypeMembershipMembershipItem) : gettype($arrayOfMembershipTypeMembershipMembershipItem)), __LINE__);
            }
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Membership $item
     * @return \rdyescapiacontent\ArrayType\ArrayOfMembershipTypeMembership
     */
    public function addToMembership(\rdyescapiacontent\StructType\Membership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\Membership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \rdyescapiacontent\StructType\Membership, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapiacontent\StructType\Membership|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapiacontent\StructType\Membership|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapiacontent\StructType\Membership|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapiacontent\StructType\Membership|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapiacontent\StructType\Membership|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Membership
     */
    public function getAttributeName()
    {
        return 'Membership';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\ArrayType\ArrayOfMembershipTypeMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
