<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyTypePrefType StructType
 * @subpackage Structs
 */
class PropertyTypePrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The PropertyType
     * @var string
     */
    public $PropertyType;
    /**
     * Constructor method for PropertyTypePrefType
     * @uses PropertyTypePrefType::set_()
     * @uses PropertyTypePrefType::setPreferLevel()
     * @uses PropertyTypePrefType::setPropertyType()
     * @param string $_
     * @param string $preferLevel
     * @param string $propertyType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $propertyType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setPropertyType($propertyType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \rdyescapiacontent\StructType\PropertyTypePrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapiacontent\StructType\PropertyTypePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @param string $propertyType
     * @return \rdyescapiacontent\StructType\PropertyTypePrefType
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyType) && !is_string($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyType, true), gettype($propertyType)), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
}
