<?php

namespace rdyescapiacontent\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PricingType EnumType
 * @subpackage Enumerations
 */
class PricingType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Per stay'
     * @return string 'Per stay'
     */
    const VALUE_PER_STAY = 'Per stay';
    /**
     * Constant for value 'Per person'
     * @return string 'Per person'
     */
    const VALUE_PER_PERSON = 'Per person';
    /**
     * Constant for value 'Per night'
     * @return string 'Per night'
     */
    const VALUE_PER_NIGHT = 'Per night';
    /**
     * Constant for value 'Per person per night'
     * @return string 'Per person per night'
     */
    const VALUE_PER_PERSON_PER_NIGHT = 'Per person per night';
    /**
     * Constant for value 'Per use'
     * @return string 'Per use'
     */
    const VALUE_PER_USE = 'Per use';
    /**
     * Return allowed values
     * @uses self::VALUE_PER_STAY
     * @uses self::VALUE_PER_PERSON
     * @uses self::VALUE_PER_NIGHT
     * @uses self::VALUE_PER_PERSON_PER_NIGHT
     * @uses self::VALUE_PER_USE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PER_STAY,
            self::VALUE_PER_PERSON,
            self::VALUE_PER_NIGHT,
            self::VALUE_PER_PERSON_PER_NIGHT,
            self::VALUE_PER_USE,
        );
    }
}
