<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitValueMatchType StructType
 * @subpackage Structs
 */
class UnitValueMatchType extends BasicUnitInfoType
{
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\RateRange
     */
    public $RateRange;
    /**
     * The LastMinuteDiscountRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\LastMinuteDiscountRangeType
     */
    public $LastMinuteDiscountRange;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The SameCountryInd
     * @var bool
     */
    public $SameCountryInd;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for UnitValueMatchType
     * @uses UnitValueMatchType::setRateRange()
     * @uses UnitValueMatchType::setLastMinuteDiscountRange()
     * @uses UnitValueMatchType::setMoreDataEchoToken()
     * @uses UnitValueMatchType::setSameCountryInd()
     * @uses UnitValueMatchType::setAvailabilityStatus()
     * @param \rdyescapiacontent\StructType\RateRange $rateRange
     * @param \rdyescapiacontent\StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange
     * @param string $moreDataEchoToken
     * @param bool $sameCountryInd
     * @param string $availabilityStatus
     */
    public function __construct(\rdyescapiacontent\StructType\RateRange $rateRange = null, \rdyescapiacontent\StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange = null, $moreDataEchoToken = null, $sameCountryInd = null, $availabilityStatus = null)
    {
        $this
            ->setRateRange($rateRange)
            ->setLastMinuteDiscountRange($lastMinuteDiscountRange)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setSameCountryInd($sameCountryInd)
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get RateRange value
     * @return \rdyescapiacontent\StructType\RateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \rdyescapiacontent\StructType\RateRange $rateRange
     * @return \rdyescapiacontent\StructType\UnitValueMatchType
     */
    public function setRateRange(\rdyescapiacontent\StructType\RateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get LastMinuteDiscountRange value
     * @return \rdyescapiacontent\StructType\LastMinuteDiscountRangeType|null
     */
    public function getLastMinuteDiscountRange()
    {
        return $this->LastMinuteDiscountRange;
    }
    /**
     * Set LastMinuteDiscountRange value
     * @param \rdyescapiacontent\StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange
     * @return \rdyescapiacontent\StructType\UnitValueMatchType
     */
    public function setLastMinuteDiscountRange(\rdyescapiacontent\StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange = null)
    {
        $this->LastMinuteDiscountRange = $lastMinuteDiscountRange;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \rdyescapiacontent\StructType\UnitValueMatchType
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moreDataEchoToken, true), gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get SameCountryInd value
     * @return bool|null
     */
    public function getSameCountryInd()
    {
        return $this->SameCountryInd;
    }
    /**
     * Set SameCountryInd value
     * @param bool $sameCountryInd
     * @return \rdyescapiacontent\StructType\UnitValueMatchType
     */
    public function setSameCountryInd($sameCountryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameCountryInd) && !is_bool($sameCountryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameCountryInd, true), gettype($sameCountryInd)), __LINE__);
        }
        $this->SameCountryInd = $sameCountryInd;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \rdyescapiacontent\EnumType\RateIndicatorType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \rdyescapiacontent\StructType\UnitValueMatchType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \rdyescapiacontent\EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
}
