<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_AmountType StructType
 * @subpackage Structs
 */
class EVRN_AmountType extends AbstractStructBase
{
    /**
     * The Base
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TotalType
     */
    public $Base;
    /**
     * The AdditionalGuestAmounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AdditionalGuestAmounts
     */
    public $AdditionalGuestAmounts;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfFeeType
     */
    public $Fees;
    /**
     * The CancelPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CancelPenaltiesType
     */
    public $CancelPolicies;
    /**
     * The PaymentPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $PaymentPolicies;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Discount[]
     */
    public $Discount;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TotalType
     */
    public $Total;
    /**
     * The RateDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType
     */
    public $RateDescription;
    /**
     * The AdditionalCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AdditionalCharges
     */
    public $AdditionalCharges;
    /**
     * The AdvanceBookingRestriction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AdvanceBookingRestriction
     */
    public $AdvanceBookingRestriction;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The UnitMultiplier
     * @var int
     */
    public $UnitMultiplier;
    /**
     * The MinGuestApplicable
     * @var int
     */
    public $MinGuestApplicable;
    /**
     * The MaxGuestApplicable
     * @var int
     */
    public $MaxGuestApplicable;
    /**
     * The MinLOS
     * @var int
     */
    public $MinLOS;
    /**
     * The MaxLOS
     * @var int
     */
    public $MaxLOS;
    /**
     * The StayOverDate
     * @var string
     */
    public $StayOverDate;
    /**
     * The AlternateCurrencyInd
     * @var bool
     */
    public $AlternateCurrencyInd;
    /**
     * Constructor method for EVRN_AmountType
     * @uses EVRN_AmountType::setBase()
     * @uses EVRN_AmountType::setAdditionalGuestAmounts()
     * @uses EVRN_AmountType::setFees()
     * @uses EVRN_AmountType::setCancelPolicies()
     * @uses EVRN_AmountType::setPaymentPolicies()
     * @uses EVRN_AmountType::setDiscount()
     * @uses EVRN_AmountType::setTotal()
     * @uses EVRN_AmountType::setRateDescription()
     * @uses EVRN_AmountType::setAdditionalCharges()
     * @uses EVRN_AmountType::setAdvanceBookingRestriction()
     * @uses EVRN_AmountType::setEffectiveDate()
     * @uses EVRN_AmountType::setExpireDate()
     * @uses EVRN_AmountType::setAgeQualifyingCode()
     * @uses EVRN_AmountType::setMinAge()
     * @uses EVRN_AmountType::setMaxAge()
     * @uses EVRN_AmountType::setAgeTimeUnit()
     * @uses EVRN_AmountType::setGuaranteedInd()
     * @uses EVRN_AmountType::setNumberOfUnits()
     * @uses EVRN_AmountType::setRateTimeUnit()
     * @uses EVRN_AmountType::setUnitMultiplier()
     * @uses EVRN_AmountType::setMinGuestApplicable()
     * @uses EVRN_AmountType::setMaxGuestApplicable()
     * @uses EVRN_AmountType::setMinLOS()
     * @uses EVRN_AmountType::setMaxLOS()
     * @uses EVRN_AmountType::setStayOverDate()
     * @uses EVRN_AmountType::setAlternateCurrencyInd()
     * @param \rdyescapiacontent\StructType\TotalType $base
     * @param \rdyescapiacontent\StructType\AdditionalGuestAmounts $additionalGuestAmounts
     * @param \rdyescapiacontent\ArrayType\ArrayOfFeeType $fees
     * @param \rdyescapiacontent\StructType\CancelPenaltiesType $cancelPolicies
     * @param \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies
     * @param \rdyescapiacontent\StructType\Discount[] $discount
     * @param \rdyescapiacontent\StructType\TotalType $total
     * @param \rdyescapiacontent\StructType\ParagraphType $rateDescription
     * @param \rdyescapiacontent\StructType\AdditionalCharges $additionalCharges
     * @param \rdyescapiacontent\StructType\AdvanceBookingRestriction $advanceBookingRestriction
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param bool $guaranteedInd
     * @param int $numberOfUnits
     * @param string $rateTimeUnit
     * @param int $unitMultiplier
     * @param int $minGuestApplicable
     * @param int $maxGuestApplicable
     * @param int $minLOS
     * @param int $maxLOS
     * @param string $stayOverDate
     * @param bool $alternateCurrencyInd
     */
    public function __construct(\rdyescapiacontent\StructType\TotalType $base = null, \rdyescapiacontent\StructType\AdditionalGuestAmounts $additionalGuestAmounts = null, \rdyescapiacontent\ArrayType\ArrayOfFeeType $fees = null, \rdyescapiacontent\StructType\CancelPenaltiesType $cancelPolicies = null, \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies = null, array $discount = array(), \rdyescapiacontent\StructType\TotalType $total = null, \rdyescapiacontent\StructType\ParagraphType $rateDescription = null, \rdyescapiacontent\StructType\AdditionalCharges $additionalCharges = null, \rdyescapiacontent\StructType\AdvanceBookingRestriction $advanceBookingRestriction = null, $effectiveDate = null, $expireDate = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $guaranteedInd = null, $numberOfUnits = null, $rateTimeUnit = null, $unitMultiplier = null, $minGuestApplicable = null, $maxGuestApplicable = null, $minLOS = null, $maxLOS = null, $stayOverDate = null, $alternateCurrencyInd = null)
    {
        $this
            ->setBase($base)
            ->setAdditionalGuestAmounts($additionalGuestAmounts)
            ->setFees($fees)
            ->setCancelPolicies($cancelPolicies)
            ->setPaymentPolicies($paymentPolicies)
            ->setDiscount($discount)
            ->setTotal($total)
            ->setRateDescription($rateDescription)
            ->setAdditionalCharges($additionalCharges)
            ->setAdvanceBookingRestriction($advanceBookingRestriction)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setGuaranteedInd($guaranteedInd)
            ->setNumberOfUnits($numberOfUnits)
            ->setRateTimeUnit($rateTimeUnit)
            ->setUnitMultiplier($unitMultiplier)
            ->setMinGuestApplicable($minGuestApplicable)
            ->setMaxGuestApplicable($maxGuestApplicable)
            ->setMinLOS($minLOS)
            ->setMaxLOS($maxLOS)
            ->setStayOverDate($stayOverDate)
            ->setAlternateCurrencyInd($alternateCurrencyInd);
    }
    /**
     * Get Base value
     * @return \rdyescapiacontent\StructType\TotalType|null
     */
    public function getBase()
    {
        return $this->Base;
    }
    /**
     * Set Base value
     * @param \rdyescapiacontent\StructType\TotalType $base
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setBase(\rdyescapiacontent\StructType\TotalType $base = null)
    {
        $this->Base = $base;
        return $this;
    }
    /**
     * Get AdditionalGuestAmounts value
     * @return \rdyescapiacontent\StructType\AdditionalGuestAmounts|null
     */
    public function getAdditionalGuestAmounts()
    {
        return $this->AdditionalGuestAmounts;
    }
    /**
     * Set AdditionalGuestAmounts value
     * @param \rdyescapiacontent\StructType\AdditionalGuestAmounts $additionalGuestAmounts
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setAdditionalGuestAmounts(\rdyescapiacontent\StructType\AdditionalGuestAmounts $additionalGuestAmounts = null)
    {
        $this->AdditionalGuestAmounts = $additionalGuestAmounts;
        return $this;
    }
    /**
     * Get Fees value
     * @return \rdyescapiacontent\ArrayType\ArrayOfFeeType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \rdyescapiacontent\ArrayType\ArrayOfFeeType $fees
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setFees(\rdyescapiacontent\ArrayType\ArrayOfFeeType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get CancelPolicies value
     * @return \rdyescapiacontent\StructType\CancelPenaltiesType|null
     */
    public function getCancelPolicies()
    {
        return $this->CancelPolicies;
    }
    /**
     * Set CancelPolicies value
     * @param \rdyescapiacontent\StructType\CancelPenaltiesType $cancelPolicies
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setCancelPolicies(\rdyescapiacontent\StructType\CancelPenaltiesType $cancelPolicies = null)
    {
        $this->CancelPolicies = $cancelPolicies;
        return $this;
    }
    /**
     * Get PaymentPolicies value
     * @return \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getPaymentPolicies()
    {
        return $this->PaymentPolicies;
    }
    /**
     * Set PaymentPolicies value
     * @param \rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setPaymentPolicies(\rdyescapiacontent\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies = null)
    {
        $this->PaymentPolicies = $paymentPolicies;
        return $this;
    }
    /**
     * Get Discount value
     * @return \rdyescapiacontent\StructType\Discount[]|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountForArrayConstraintsFromSetDiscount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_AmountTypeDiscountItem) {
            // validation for constraint: itemType
            if (!$eVRN_AmountTypeDiscountItem instanceof \rdyescapiacontent\StructType\Discount) {
                $invalidValues[] = is_object($eVRN_AmountTypeDiscountItem) ? get_class($eVRN_AmountTypeDiscountItem) : sprintf('%s(%s)', gettype($eVRN_AmountTypeDiscountItem), var_export($eVRN_AmountTypeDiscountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Discount property can only contain items of type \rdyescapiacontent\StructType\Discount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Discount value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Discount[] $discount
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setDiscount(array $discount = array())
    {
        // validation for constraint: array
        if ('' !== ($discountArrayErrorMessage = self::validateDiscountForArrayConstraintsFromSetDiscount($discount))) {
            throw new \InvalidArgumentException($discountArrayErrorMessage, __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Add item to Discount value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Discount $item
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function addToDiscount(\rdyescapiacontent\StructType\Discount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\Discount) {
            throw new \InvalidArgumentException(sprintf('The Discount property can only contain items of type \rdyescapiacontent\StructType\Discount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Discount[] = $item;
        return $this;
    }
    /**
     * Get Total value
     * @return \rdyescapiacontent\StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \rdyescapiacontent\StructType\TotalType $total
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setTotal(\rdyescapiacontent\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get RateDescription value
     * @return \rdyescapiacontent\StructType\ParagraphType|null
     */
    public function getRateDescription()
    {
        return $this->RateDescription;
    }
    /**
     * Set RateDescription value
     * @param \rdyescapiacontent\StructType\ParagraphType $rateDescription
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setRateDescription(\rdyescapiacontent\StructType\ParagraphType $rateDescription = null)
    {
        $this->RateDescription = $rateDescription;
        return $this;
    }
    /**
     * Get AdditionalCharges value
     * @return \rdyescapiacontent\StructType\AdditionalCharges|null
     */
    public function getAdditionalCharges()
    {
        return $this->AdditionalCharges;
    }
    /**
     * Set AdditionalCharges value
     * @param \rdyescapiacontent\StructType\AdditionalCharges $additionalCharges
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setAdditionalCharges(\rdyescapiacontent\StructType\AdditionalCharges $additionalCharges = null)
    {
        $this->AdditionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Get AdvanceBookingRestriction value
     * @return \rdyescapiacontent\StructType\AdvanceBookingRestriction|null
     */
    public function getAdvanceBookingRestriction()
    {
        return $this->AdvanceBookingRestriction;
    }
    /**
     * Set AdvanceBookingRestriction value
     * @param \rdyescapiacontent\StructType\AdvanceBookingRestriction $advanceBookingRestriction
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setAdvanceBookingRestriction(\rdyescapiacontent\StructType\AdvanceBookingRestriction $advanceBookingRestriction = null)
    {
        $this->AdvanceBookingRestriction = $advanceBookingRestriction;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \rdyescapiacontent\EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteedInd, true), gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\TimeUnitType', is_array($rateTimeUnit) ? implode(', ', $rateTimeUnit) : var_export($rateTimeUnit, true), implode(', ', \rdyescapiacontent\EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get UnitMultiplier value
     * @return int|null
     */
    public function getUnitMultiplier()
    {
        return $this->UnitMultiplier;
    }
    /**
     * Set UnitMultiplier value
     * @param int $unitMultiplier
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setUnitMultiplier($unitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($unitMultiplier) && !(is_int($unitMultiplier) || ctype_digit($unitMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitMultiplier, true), gettype($unitMultiplier)), __LINE__);
        }
        $this->UnitMultiplier = $unitMultiplier;
        return $this;
    }
    /**
     * Get MinGuestApplicable value
     * @return int|null
     */
    public function getMinGuestApplicable()
    {
        return $this->MinGuestApplicable;
    }
    /**
     * Set MinGuestApplicable value
     * @param int $minGuestApplicable
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setMinGuestApplicable($minGuestApplicable = null)
    {
        // validation for constraint: int
        if (!is_null($minGuestApplicable) && !(is_int($minGuestApplicable) || ctype_digit($minGuestApplicable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minGuestApplicable, true), gettype($minGuestApplicable)), __LINE__);
        }
        $this->MinGuestApplicable = $minGuestApplicable;
        return $this;
    }
    /**
     * Get MaxGuestApplicable value
     * @return int|null
     */
    public function getMaxGuestApplicable()
    {
        return $this->MaxGuestApplicable;
    }
    /**
     * Set MaxGuestApplicable value
     * @param int $maxGuestApplicable
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setMaxGuestApplicable($maxGuestApplicable = null)
    {
        // validation for constraint: int
        if (!is_null($maxGuestApplicable) && !(is_int($maxGuestApplicable) || ctype_digit($maxGuestApplicable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxGuestApplicable, true), gettype($maxGuestApplicable)), __LINE__);
        }
        $this->MaxGuestApplicable = $maxGuestApplicable;
        return $this;
    }
    /**
     * Get MinLOS value
     * @return int|null
     */
    public function getMinLOS()
    {
        return $this->MinLOS;
    }
    /**
     * Set MinLOS value
     * @param int $minLOS
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setMinLOS($minLOS = null)
    {
        // validation for constraint: int
        if (!is_null($minLOS) && !(is_int($minLOS) || ctype_digit($minLOS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minLOS, true), gettype($minLOS)), __LINE__);
        }
        $this->MinLOS = $minLOS;
        return $this;
    }
    /**
     * Get MaxLOS value
     * @return int|null
     */
    public function getMaxLOS()
    {
        return $this->MaxLOS;
    }
    /**
     * Set MaxLOS value
     * @param int $maxLOS
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setMaxLOS($maxLOS = null)
    {
        // validation for constraint: int
        if (!is_null($maxLOS) && !(is_int($maxLOS) || ctype_digit($maxLOS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxLOS, true), gettype($maxLOS)), __LINE__);
        }
        $this->MaxLOS = $maxLOS;
        return $this;
    }
    /**
     * Get StayOverDate value
     * @return string|null
     */
    public function getStayOverDate()
    {
        return $this->StayOverDate;
    }
    /**
     * Set StayOverDate value
     * @uses \rdyescapiacontent\EnumType\DayOfWeekType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayOverDate
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setStayOverDate($stayOverDate = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\DayOfWeekType::valueIsValid($stayOverDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\DayOfWeekType', is_array($stayOverDate) ? implode(', ', $stayOverDate) : var_export($stayOverDate, true), implode(', ', \rdyescapiacontent\EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->StayOverDate = $stayOverDate;
        return $this;
    }
    /**
     * Get AlternateCurrencyInd value
     * @return bool|null
     */
    public function getAlternateCurrencyInd()
    {
        return $this->AlternateCurrencyInd;
    }
    /**
     * Set AlternateCurrencyInd value
     * @param bool $alternateCurrencyInd
     * @return \rdyescapiacontent\StructType\EVRN_AmountType
     */
    public function setAlternateCurrencyInd($alternateCurrencyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($alternateCurrencyInd) && !is_bool($alternateCurrencyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alternateCurrencyInd, true), gettype($alternateCurrencyInd)), __LINE__);
        }
        $this->AlternateCurrencyInd = $alternateCurrencyInd;
        return $this;
    }
}
