<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deadline StructType
 * @subpackage Structs
 */
class Deadline extends AbstractStructBase
{
    /**
     * The AbsoluteDeadline
     * @var string
     */
    public $AbsoluteDeadline;
    /**
     * The OffsetTimeUnit
     * @var string
     */
    public $OffsetTimeUnit;
    /**
     * The OffsetUnitMultiplier
     * @var int
     */
    public $OffsetUnitMultiplier;
    /**
     * The OffsetDropTime
     * @var string
     */
    public $OffsetDropTime;
    /**
     * Constructor method for Deadline
     * @uses Deadline::setAbsoluteDeadline()
     * @uses Deadline::setOffsetTimeUnit()
     * @uses Deadline::setOffsetUnitMultiplier()
     * @uses Deadline::setOffsetDropTime()
     * @param string $absoluteDeadline
     * @param string $offsetTimeUnit
     * @param int $offsetUnitMultiplier
     * @param string $offsetDropTime
     */
    public function __construct($absoluteDeadline = null, $offsetTimeUnit = null, $offsetUnitMultiplier = null, $offsetDropTime = null)
    {
        $this
            ->setAbsoluteDeadline($absoluteDeadline)
            ->setOffsetTimeUnit($offsetTimeUnit)
            ->setOffsetUnitMultiplier($offsetUnitMultiplier)
            ->setOffsetDropTime($offsetDropTime);
    }
    /**
     * Get AbsoluteDeadline value
     * @return string|null
     */
    public function getAbsoluteDeadline()
    {
        return $this->AbsoluteDeadline;
    }
    /**
     * Set AbsoluteDeadline value
     * @param string $absoluteDeadline
     * @return \rdyescapiacontent\StructType\Deadline
     */
    public function setAbsoluteDeadline($absoluteDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDeadline) && !is_string($absoluteDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteDeadline, true), gettype($absoluteDeadline)), __LINE__);
        }
        $this->AbsoluteDeadline = $absoluteDeadline;
        return $this;
    }
    /**
     * Get OffsetTimeUnit value
     * @return string|null
     */
    public function getOffsetTimeUnit()
    {
        return $this->OffsetTimeUnit;
    }
    /**
     * Set OffsetTimeUnit value
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetTimeUnit
     * @return \rdyescapiacontent\StructType\Deadline
     */
    public function setOffsetTimeUnit($offsetTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TimeUnitType::valueIsValid($offsetTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\TimeUnitType', is_array($offsetTimeUnit) ? implode(', ', $offsetTimeUnit) : var_export($offsetTimeUnit, true), implode(', ', \rdyescapiacontent\EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->OffsetTimeUnit = $offsetTimeUnit;
        return $this;
    }
    /**
     * Get OffsetUnitMultiplier value
     * @return int|null
     */
    public function getOffsetUnitMultiplier()
    {
        return $this->OffsetUnitMultiplier;
    }
    /**
     * Set OffsetUnitMultiplier value
     * @param int $offsetUnitMultiplier
     * @return \rdyescapiacontent\StructType\Deadline
     */
    public function setOffsetUnitMultiplier($offsetUnitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($offsetUnitMultiplier) && !(is_int($offsetUnitMultiplier) || ctype_digit($offsetUnitMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetUnitMultiplier, true), gettype($offsetUnitMultiplier)), __LINE__);
        }
        $this->OffsetUnitMultiplier = $offsetUnitMultiplier;
        return $this;
    }
    /**
     * Get OffsetDropTime value
     * @return string|null
     */
    public function getOffsetDropTime()
    {
        return $this->OffsetDropTime;
    }
    /**
     * Set OffsetDropTime value
     * @param string $offsetDropTime
     * @return \rdyescapiacontent\StructType\Deadline
     */
    public function setOffsetDropTime($offsetDropTime = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDropTime) && !is_string($offsetDropTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDropTime, true), gettype($offsetDropTime)), __LINE__);
        }
        $this->OffsetDropTime = $offsetDropTime;
        return $this;
    }
}
