<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType StructType
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The TaxDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType[]
     */
    public $TaxDescription;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The ChargeFrequency
     * @var string
     */
    public $ChargeFrequency;
    /**
     * The ChargeUnitExempt
     * @var int
     */
    public $ChargeUnitExempt;
    /**
     * The ChargeFrequencyExempt
     * @var int
     */
    public $ChargeFrequencyExempt;
    /**
     * The MaxChargeUnitApplies
     * @var int
     */
    public $MaxChargeUnitApplies;
    /**
     * The MaxChargeFrequencyApplies
     * @var int
     */
    public $MaxChargeFrequencyApplies;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setTaxDescription()
     * @uses TaxType::setType()
     * @uses TaxType::setCode()
     * @uses TaxType::setPercent()
     * @uses TaxType::setAmount()
     * @uses TaxType::setCurrencyCode()
     * @uses TaxType::setDecimalPlaces()
     * @uses TaxType::setEffectiveDate()
     * @uses TaxType::setExpireDate()
     * @uses TaxType::setChargeUnit()
     * @uses TaxType::setChargeFrequency()
     * @uses TaxType::setChargeUnitExempt()
     * @uses TaxType::setChargeFrequencyExempt()
     * @uses TaxType::setMaxChargeUnitApplies()
     * @uses TaxType::setMaxChargeFrequencyApplies()
     * @param \rdyescapiacontent\StructType\ParagraphType[] $taxDescription
     * @param string $type
     * @param string $code
     * @param float $percent
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $chargeUnit
     * @param string $chargeFrequency
     * @param int $chargeUnitExempt
     * @param int $chargeFrequencyExempt
     * @param int $maxChargeUnitApplies
     * @param int $maxChargeFrequencyApplies
     */
    public function __construct(array $taxDescription = array(), $type = null, $code = null, $percent = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $effectiveDate = null, $expireDate = null, $chargeUnit = null, $chargeFrequency = null, $chargeUnitExempt = null, $chargeFrequencyExempt = null, $maxChargeUnitApplies = null, $maxChargeFrequencyApplies = null)
    {
        $this
            ->setTaxDescription($taxDescription)
            ->setType($type)
            ->setCode($code)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setChargeUnit($chargeUnit)
            ->setChargeFrequency($chargeFrequency)
            ->setChargeUnitExempt($chargeUnitExempt)
            ->setChargeFrequencyExempt($chargeFrequencyExempt)
            ->setMaxChargeUnitApplies($maxChargeUnitApplies)
            ->setMaxChargeFrequencyApplies($maxChargeFrequencyApplies);
    }
    /**
     * Get TaxDescription value
     * @return \rdyescapiacontent\StructType\ParagraphType[]|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDescriptionForArrayConstraintsFromSetTaxDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTypeTaxDescriptionItem) {
            // validation for constraint: itemType
            if (!$taxTypeTaxDescriptionItem instanceof \rdyescapiacontent\StructType\ParagraphType) {
                $invalidValues[] = is_object($taxTypeTaxDescriptionItem) ? get_class($taxTypeTaxDescriptionItem) : sprintf('%s(%s)', gettype($taxTypeTaxDescriptionItem), var_export($taxTypeTaxDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxDescription property can only contain items of type \rdyescapiacontent\StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType[] $taxDescription
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setTaxDescription(array $taxDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDescriptionArrayErrorMessage = self::validateTaxDescriptionForArrayConstraintsFromSetTaxDescription($taxDescription))) {
            throw new \InvalidArgumentException($taxDescriptionArrayErrorMessage, __LINE__);
        }
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Add item to TaxDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType $item
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function addToTaxDescription(\rdyescapiacontent\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The TaxDescription property can only contain items of type \rdyescapiacontent\StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxDescription[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \rdyescapiacontent\EnumType\AmountDeterminationType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\AmountDeterminationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\AmountDeterminationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\AmountDeterminationType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \rdyescapiacontent\EnumType\AmountDeterminationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeUnit, true), gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get ChargeFrequency value
     * @return string|null
     */
    public function getChargeFrequency()
    {
        return $this->ChargeFrequency;
    }
    /**
     * Set ChargeFrequency value
     * @param string $chargeFrequency
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setChargeFrequency($chargeFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($chargeFrequency) && !is_string($chargeFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeFrequency, true), gettype($chargeFrequency)), __LINE__);
        }
        $this->ChargeFrequency = $chargeFrequency;
        return $this;
    }
    /**
     * Get ChargeUnitExempt value
     * @return int|null
     */
    public function getChargeUnitExempt()
    {
        return $this->ChargeUnitExempt;
    }
    /**
     * Set ChargeUnitExempt value
     * @param int $chargeUnitExempt
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setChargeUnitExempt($chargeUnitExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeUnitExempt) && !(is_int($chargeUnitExempt) || ctype_digit($chargeUnitExempt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeUnitExempt, true), gettype($chargeUnitExempt)), __LINE__);
        }
        $this->ChargeUnitExempt = $chargeUnitExempt;
        return $this;
    }
    /**
     * Get ChargeFrequencyExempt value
     * @return int|null
     */
    public function getChargeFrequencyExempt()
    {
        return $this->ChargeFrequencyExempt;
    }
    /**
     * Set ChargeFrequencyExempt value
     * @param int $chargeFrequencyExempt
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setChargeFrequencyExempt($chargeFrequencyExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeFrequencyExempt) && !(is_int($chargeFrequencyExempt) || ctype_digit($chargeFrequencyExempt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeFrequencyExempt, true), gettype($chargeFrequencyExempt)), __LINE__);
        }
        $this->ChargeFrequencyExempt = $chargeFrequencyExempt;
        return $this;
    }
    /**
     * Get MaxChargeUnitApplies value
     * @return int|null
     */
    public function getMaxChargeUnitApplies()
    {
        return $this->MaxChargeUnitApplies;
    }
    /**
     * Set MaxChargeUnitApplies value
     * @param int $maxChargeUnitApplies
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setMaxChargeUnitApplies($maxChargeUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeUnitApplies) && !(is_int($maxChargeUnitApplies) || ctype_digit($maxChargeUnitApplies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChargeUnitApplies, true), gettype($maxChargeUnitApplies)), __LINE__);
        }
        $this->MaxChargeUnitApplies = $maxChargeUnitApplies;
        return $this;
    }
    /**
     * Get MaxChargeFrequencyApplies value
     * @return int|null
     */
    public function getMaxChargeFrequencyApplies()
    {
        return $this->MaxChargeFrequencyApplies;
    }
    /**
     * Set MaxChargeFrequencyApplies value
     * @param int $maxChargeFrequencyApplies
     * @return \rdyescapiacontent\StructType\TaxType
     */
    public function setMaxChargeFrequencyApplies($maxChargeFrequencyApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeFrequencyApplies) && !(is_int($maxChargeFrequencyApplies) || ctype_digit($maxChargeFrequencyApplies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChargeFrequencyApplies, true), gettype($maxChargeFrequencyApplies)), __LINE__);
        }
        $this->MaxChargeFrequencyApplies = $maxChargeFrequencyApplies;
        return $this;
    }
}
