<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedTextSubSectionType StructType
 * @subpackage Structs
 */
class FormattedTextSubSectionType extends AbstractStructBase
{
    /**
     * The Paragraph
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ParagraphType[]
     */
    public $Paragraph;
    /**
     * The SubTitle
     * @var string
     */
    public $SubTitle;
    /**
     * The SubCode
     * @var string
     */
    public $SubCode;
    /**
     * The SubSectionNumber
     * @var int
     */
    public $SubSectionNumber;
    /**
     * Constructor method for FormattedTextSubSectionType
     * @uses FormattedTextSubSectionType::setParagraph()
     * @uses FormattedTextSubSectionType::setSubTitle()
     * @uses FormattedTextSubSectionType::setSubCode()
     * @uses FormattedTextSubSectionType::setSubSectionNumber()
     * @param \rdyescapiacontent\StructType\ParagraphType[] $paragraph
     * @param string $subTitle
     * @param string $subCode
     * @param int $subSectionNumber
     */
    public function __construct(array $paragraph = array(), $subTitle = null, $subCode = null, $subSectionNumber = null)
    {
        $this
            ->setParagraph($paragraph)
            ->setSubTitle($subTitle)
            ->setSubCode($subCode)
            ->setSubSectionNumber($subSectionNumber);
    }
    /**
     * Get Paragraph value
     * @return \rdyescapiacontent\StructType\ParagraphType[]|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * This method is responsible for validating the values passed to the setParagraph method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParagraph method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParagraphForArrayConstraintsFromSetParagraph(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formattedTextSubSectionTypeParagraphItem) {
            // validation for constraint: itemType
            if (!$formattedTextSubSectionTypeParagraphItem instanceof \rdyescapiacontent\StructType\ParagraphType) {
                $invalidValues[] = is_object($formattedTextSubSectionTypeParagraphItem) ? get_class($formattedTextSubSectionTypeParagraphItem) : sprintf('%s(%s)', gettype($formattedTextSubSectionTypeParagraphItem), var_export($formattedTextSubSectionTypeParagraphItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Paragraph property can only contain items of type \rdyescapiacontent\StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Paragraph value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType[] $paragraph
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setParagraph(array $paragraph = array())
    {
        // validation for constraint: array
        if ('' !== ($paragraphArrayErrorMessage = self::validateParagraphForArrayConstraintsFromSetParagraph($paragraph))) {
            throw new \InvalidArgumentException($paragraphArrayErrorMessage, __LINE__);
        }
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Add item to Paragraph value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ParagraphType $item
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function addToParagraph(\rdyescapiacontent\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Paragraph property can only contain items of type \rdyescapiacontent\StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Paragraph[] = $item;
        return $this;
    }
    /**
     * Get SubTitle value
     * @return string|null
     */
    public function getSubTitle()
    {
        return $this->SubTitle;
    }
    /**
     * Set SubTitle value
     * @param string $subTitle
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setSubTitle($subTitle = null)
    {
        // validation for constraint: string
        if (!is_null($subTitle) && !is_string($subTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTitle, true), gettype($subTitle)), __LINE__);
        }
        $this->SubTitle = $subTitle;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setSubCode($subCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCode) && !is_string($subCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCode, true), gettype($subCode)), __LINE__);
        }
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Get SubSectionNumber value
     * @return int|null
     */
    public function getSubSectionNumber()
    {
        return $this->SubSectionNumber;
    }
    /**
     * Set SubSectionNumber value
     * @param int $subSectionNumber
     * @return \rdyescapiacontent\StructType\FormattedTextSubSectionType
     */
    public function setSubSectionNumber($subSectionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($subSectionNumber) && !(is_int($subSectionNumber) || ctype_digit($subSectionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subSectionNumber, true), gettype($subSectionNumber)), __LINE__);
        }
        $this->SubSectionNumber = $subSectionNumber;
        return $this;
    }
}
