<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinPref StructType
 * @subpackage Structs
 */
class CabinPref extends AbstractStructBase
{
    /**
     * The Cabin
     * @var string
     */
    public $Cabin;
    /**
     * Constructor method for CabinPref
     * @uses CabinPref::setCabin()
     * @param string $cabin
     */
    public function __construct($cabin = null)
    {
        $this
            ->setCabin($cabin);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \rdyescapiacontent\EnumType\CabinType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \rdyescapiacontent\StructType\CabinPref
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\CabinType::valueIsValid($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\CabinType', is_array($cabin) ? implode(', ', $cabin) : var_export($cabin, true), implode(', ', \rdyescapiacontent\EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
}
