<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnidadeERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UnidadeERP
 * @subpackage Structs
 */
class UnidadeERP extends AbstractStructBase
{
    /**
     * The Arredondamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Arredondamento;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Unidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Unidade;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for UnidadeERP
     * @uses UnidadeERP::setArredondamento()
     * @uses UnidadeERP::setDescricao()
     * @uses UnidadeERP::setProtegida()
     * @uses UnidadeERP::setUnidade()
     * @uses UnidadeERP::setVersaoUltAct()
     * @param int $arredondamento
     * @param string $descricao
     * @param bool $protegida
     * @param string $unidade
     * @param string $versaoUltAct
     */
    public function __construct($arredondamento = null, $descricao = null, $protegida = null, $unidade = null, $versaoUltAct = null)
    {
        $this
            ->setArredondamento($arredondamento)
            ->setDescricao($descricao)
            ->setProtegida($protegida)
            ->setUnidade($unidade)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Arredondamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArredondamento()
    {
        return isset($this->Arredondamento) ? $this->Arredondamento : null;
    }
    /**
     * Set Arredondamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $arredondamento
     * @return \StructType\UnidadeERP
     */
    public function setArredondamento($arredondamento = null)
    {
        // validation for constraint: int
        if (!is_null($arredondamento) && !is_numeric($arredondamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($arredondamento)), __LINE__);
        }
        if (is_null($arredondamento) || (is_array($arredondamento) && empty($arredondamento))) {
            unset($this->Arredondamento);
        } else {
            $this->Arredondamento = $arredondamento;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\UnidadeERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\UnidadeERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Unidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidade()
    {
        return isset($this->Unidade) ? $this->Unidade : null;
    }
    /**
     * Set Unidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidade
     * @return \StructType\UnidadeERP
     */
    public function setUnidade($unidade = null)
    {
        // validation for constraint: string
        if (!is_null($unidade) && !is_string($unidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidade)), __LINE__);
        }
        if (is_null($unidade) || (is_array($unidade) && empty($unidade))) {
            unset($this->Unidade);
        } else {
            $this->Unidade = $unidade;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\UnidadeERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnidadeERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
