<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResumoRetencaoLiqERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResumoRetencaoLiqERP
 * @subpackage Structs
 */
class ResumoRetencaoLiqERP extends AbstractStructBase
{
    /**
     * The EntidadeRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntidadeRetencao;
    /**
     * The IdDetalheLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdDetalheLiq;
    /**
     * The IdLinhaLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhaLiq;
    /**
     * The Incidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Incidencia;
    /**
     * The ObraId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObraId;
    /**
     * The Percentagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Percentagem;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The TipoAuto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoAuto;
    /**
     * The TipoCalculo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TipoCalculo;
    /**
     * The TipoEntidadeRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidadeRetencao;
    /**
     * The TipoRendimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoRendimento;
    /**
     * The TipoRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoRetencao;
    /**
     * The Valor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * Constructor method for ResumoRetencaoLiqERP
     * @uses ResumoRetencaoLiqERP::setEntidadeRetencao()
     * @uses ResumoRetencaoLiqERP::setIdDetalheLiq()
     * @uses ResumoRetencaoLiqERP::setIdLinhaLiq()
     * @uses ResumoRetencaoLiqERP::setIncidencia()
     * @uses ResumoRetencaoLiqERP::setObraId()
     * @uses ResumoRetencaoLiqERP::setPercentagem()
     * @uses ResumoRetencaoLiqERP::setProtegida()
     * @uses ResumoRetencaoLiqERP::setTipoAuto()
     * @uses ResumoRetencaoLiqERP::setTipoCalculo()
     * @uses ResumoRetencaoLiqERP::setTipoEntidadeRetencao()
     * @uses ResumoRetencaoLiqERP::setTipoRendimento()
     * @uses ResumoRetencaoLiqERP::setTipoRetencao()
     * @uses ResumoRetencaoLiqERP::setValor()
     * @param string $entidadeRetencao
     * @param string $idDetalheLiq
     * @param string $idLinhaLiq
     * @param float $incidencia
     * @param string $obraId
     * @param float $percentagem
     * @param bool $protegida
     * @param string $tipoAuto
     * @param bool $tipoCalculo
     * @param string $tipoEntidadeRetencao
     * @param string $tipoRendimento
     * @param string $tipoRetencao
     * @param float $valor
     */
    public function __construct($entidadeRetencao = null, $idDetalheLiq = null, $idLinhaLiq = null, $incidencia = null, $obraId = null, $percentagem = null, $protegida = null, $tipoAuto = null, $tipoCalculo = null, $tipoEntidadeRetencao = null, $tipoRendimento = null, $tipoRetencao = null, $valor = null)
    {
        $this
            ->setEntidadeRetencao($entidadeRetencao)
            ->setIdDetalheLiq($idDetalheLiq)
            ->setIdLinhaLiq($idLinhaLiq)
            ->setIncidencia($incidencia)
            ->setObraId($obraId)
            ->setPercentagem($percentagem)
            ->setProtegida($protegida)
            ->setTipoAuto($tipoAuto)
            ->setTipoCalculo($tipoCalculo)
            ->setTipoEntidadeRetencao($tipoEntidadeRetencao)
            ->setTipoRendimento($tipoRendimento)
            ->setTipoRetencao($tipoRetencao)
            ->setValor($valor);
    }
    /**
     * Get EntidadeRetencao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidadeRetencao()
    {
        return isset($this->EntidadeRetencao) ? $this->EntidadeRetencao : null;
    }
    /**
     * Set EntidadeRetencao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidadeRetencao
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setEntidadeRetencao($entidadeRetencao = null)
    {
        // validation for constraint: string
        if (!is_null($entidadeRetencao) && !is_string($entidadeRetencao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidadeRetencao)), __LINE__);
        }
        if (is_null($entidadeRetencao) || (is_array($entidadeRetencao) && empty($entidadeRetencao))) {
            unset($this->EntidadeRetencao);
        } else {
            $this->EntidadeRetencao = $entidadeRetencao;
        }
        return $this;
    }
    /**
     * Get IdDetalheLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdDetalheLiq()
    {
        return isset($this->IdDetalheLiq) ? $this->IdDetalheLiq : null;
    }
    /**
     * Set IdDetalheLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idDetalheLiq
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setIdDetalheLiq($idDetalheLiq = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idDetalheLiq) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idDetalheLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idDetalheLiq, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idDetalheLiq) && !is_string($idDetalheLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idDetalheLiq)), __LINE__);
        }
        if (is_null($idDetalheLiq) || (is_array($idDetalheLiq) && empty($idDetalheLiq))) {
            unset($this->IdDetalheLiq);
        } else {
            $this->IdDetalheLiq = $idDetalheLiq;
        }
        return $this;
    }
    /**
     * Get IdLinhaLiq value
     * @return string|null
     */
    public function getIdLinhaLiq()
    {
        return $this->IdLinhaLiq;
    }
    /**
     * Set IdLinhaLiq value
     * @param string $idLinhaLiq
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setIdLinhaLiq($idLinhaLiq = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhaLiq) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhaLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhaLiq, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhaLiq) && !is_string($idLinhaLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhaLiq)), __LINE__);
        }
        $this->IdLinhaLiq = $idLinhaLiq;
        return $this;
    }
    /**
     * Get Incidencia value
     * @return float|null
     */
    public function getIncidencia()
    {
        return $this->Incidencia;
    }
    /**
     * Set Incidencia value
     * @param float $incidencia
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setIncidencia($incidencia = null)
    {
        $this->Incidencia = $incidencia;
        return $this;
    }
    /**
     * Get ObraId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObraId()
    {
        return isset($this->ObraId) ? $this->ObraId : null;
    }
    /**
     * Set ObraId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $obraId
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setObraId($obraId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($obraId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $obraId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($obraId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($obraId) && !is_string($obraId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obraId)), __LINE__);
        }
        if (is_null($obraId) || (is_array($obraId) && empty($obraId))) {
            unset($this->ObraId);
        } else {
            $this->ObraId = $obraId;
        }
        return $this;
    }
    /**
     * Get Percentagem value
     * @return float|null
     */
    public function getPercentagem()
    {
        return $this->Percentagem;
    }
    /**
     * Set Percentagem value
     * @param float $percentagem
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setPercentagem($percentagem = null)
    {
        $this->Percentagem = $percentagem;
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get TipoAuto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoAuto()
    {
        return isset($this->TipoAuto) ? $this->TipoAuto : null;
    }
    /**
     * Set TipoAuto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoAuto
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setTipoAuto($tipoAuto = null)
    {
        // validation for constraint: string
        if (!is_null($tipoAuto) && !is_string($tipoAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoAuto)), __LINE__);
        }
        if (is_null($tipoAuto) || (is_array($tipoAuto) && empty($tipoAuto))) {
            unset($this->TipoAuto);
        } else {
            $this->TipoAuto = $tipoAuto;
        }
        return $this;
    }
    /**
     * Get TipoCalculo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTipoCalculo()
    {
        return isset($this->TipoCalculo) ? $this->TipoCalculo : null;
    }
    /**
     * Set TipoCalculo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $tipoCalculo
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setTipoCalculo($tipoCalculo = null)
    {
        // validation for constraint: boolean
        if (!is_null($tipoCalculo) && !is_bool($tipoCalculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tipoCalculo)), __LINE__);
        }
        if (is_null($tipoCalculo) || (is_array($tipoCalculo) && empty($tipoCalculo))) {
            unset($this->TipoCalculo);
        } else {
            $this->TipoCalculo = $tipoCalculo;
        }
        return $this;
    }
    /**
     * Get TipoEntidadeRetencao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidadeRetencao()
    {
        return isset($this->TipoEntidadeRetencao) ? $this->TipoEntidadeRetencao : null;
    }
    /**
     * Set TipoEntidadeRetencao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidadeRetencao
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setTipoEntidadeRetencao($tipoEntidadeRetencao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidadeRetencao) && !is_string($tipoEntidadeRetencao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidadeRetencao)), __LINE__);
        }
        if (is_null($tipoEntidadeRetencao) || (is_array($tipoEntidadeRetencao) && empty($tipoEntidadeRetencao))) {
            unset($this->TipoEntidadeRetencao);
        } else {
            $this->TipoEntidadeRetencao = $tipoEntidadeRetencao;
        }
        return $this;
    }
    /**
     * Get TipoRendimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoRendimento()
    {
        return isset($this->TipoRendimento) ? $this->TipoRendimento : null;
    }
    /**
     * Set TipoRendimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoRendimento
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setTipoRendimento($tipoRendimento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRendimento) && !is_string($tipoRendimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoRendimento)), __LINE__);
        }
        if (is_null($tipoRendimento) || (is_array($tipoRendimento) && empty($tipoRendimento))) {
            unset($this->TipoRendimento);
        } else {
            $this->TipoRendimento = $tipoRendimento;
        }
        return $this;
    }
    /**
     * Get TipoRetencao value
     * @return string|null
     */
    public function getTipoRetencao()
    {
        return $this->TipoRetencao;
    }
    /**
     * Set TipoRetencao value
     * @param string $tipoRetencao
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setTipoRetencao($tipoRetencao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRetencao) && !is_string($tipoRetencao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoRetencao)), __LINE__);
        }
        $this->TipoRetencao = $tipoRetencao;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public function setValor($valor = null)
    {
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResumoRetencaoLiqERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
