<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasLiqERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasLiqERP
 * @subpackage Structs
 */
class LinhasLiqERP extends AbstractStructBase
{
    /**
     * The CambioDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioDocOrig;
    /**
     * The CambioLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioLiq;
    /**
     * The CambioMAltDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CambioMAltDocOrig;
    /**
     * The CambioMAltLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMAltLiq;
    /**
     * The CambioMBaseDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CambioMBaseDocOrig;
    /**
     * The CambioMBaseLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMBaseLiq;
    /**
     * The ContaBNCOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaBNCOrig;
    /**
     * The ContaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCBL;
    /**
     * The ContaDomiciliacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaDomiciliacao;
    /**
     * The CorreccaoMonetaria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CorreccaoMonetaria;
    /**
     * The DataCobranca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataCobranca;
    /**
     * The DataDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDoc;
    /**
     * The DifArredondamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DifArredondamento;
    /**
     * The DifArredondamentoMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamentoMAlt;
    /**
     * The DifCambio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DifCambio;
    /**
     * The DifCambioMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DifCambioMAlt;
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The Filial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filial;
    /**
     * The FilialOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilialOrig;
    /**
     * The Financiada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Financiada;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdCabLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCabLiq;
    /**
     * The IdHistorico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdHistorico;
    /**
     * The IdMovCBLOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdMovCBLOrig;
    /**
     * The Mandato
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mandato;
    /**
     * The ModuloOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModuloOrig;
    /**
     * The MoedaDaUEMDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MoedaDaUEMDocOrig;
    /**
     * The MoedaDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MoedaDocOrig;
    /**
     * The NumDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumDoc;
    /**
     * The NumDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumDocOrig;
    /**
     * The NumDocOrigInt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumDocOrigInt;
    /**
     * The NumPrestacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumPrestacao;
    /**
     * The NumTransferencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumTransferencia;
    /**
     * The ObraId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObraId;
    /**
     * The ObservacoesSEPA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObservacoesSEPA;
    /**
     * The PendenteGerado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PendenteGerado;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Serie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serie;
    /**
     * The SerieOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieOrig;
    /**
     * The TipoConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoConta;
    /**
     * The TipoDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDoc;
    /**
     * The TipoDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDocOrig;
    /**
     * The TipoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidade;
    /**
     * The TipoOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoOrig;
    /**
     * The TransfereEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TransfereEntidade;
    /**
     * The ValorDescMoedaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorDescMoedaOrig;
    /**
     * The ValorDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorDesconto;
    /**
     * The ValorOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorOrig;
    /**
     * The ValorPend
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPend;
    /**
     * The ValorRec
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRec;
    /**
     * The ValorRecMoedaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRecMoedaOrig;
    /**
     * The ValorRetGarRecMoedaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetGarRecMoedaOrig;
    /**
     * The ValorRetRecMoedaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetRecMoedaOrig;
    /**
     * The ValorRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencao;
    /**
     * The ValorRetencaoGarantia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoGarantia;
    /**
     * The ValorRetencaoGarantiaPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoGarantiaPendente;
    /**
     * The ValorRetencaoPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoPendente;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * The WBSItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBSItem;
    /**
     * Constructor method for LinhasLiqERP
     * @uses LinhasLiqERP::setCambioDocOrig()
     * @uses LinhasLiqERP::setCambioLiq()
     * @uses LinhasLiqERP::setCambioMAltDocOrig()
     * @uses LinhasLiqERP::setCambioMAltLiq()
     * @uses LinhasLiqERP::setCambioMBaseDocOrig()
     * @uses LinhasLiqERP::setCambioMBaseLiq()
     * @uses LinhasLiqERP::setContaBNCOrig()
     * @uses LinhasLiqERP::setContaCBL()
     * @uses LinhasLiqERP::setContaDomiciliacao()
     * @uses LinhasLiqERP::setCorreccaoMonetaria()
     * @uses LinhasLiqERP::setDataCobranca()
     * @uses LinhasLiqERP::setDataDoc()
     * @uses LinhasLiqERP::setDifArredondamento()
     * @uses LinhasLiqERP::setDifArredondamentoMAlt()
     * @uses LinhasLiqERP::setDifCambio()
     * @uses LinhasLiqERP::setDifCambioMAlt()
     * @uses LinhasLiqERP::setEntidade()
     * @uses LinhasLiqERP::setEstado()
     * @uses LinhasLiqERP::setFilial()
     * @uses LinhasLiqERP::setFilialOrig()
     * @uses LinhasLiqERP::setFinanciada()
     * @uses LinhasLiqERP::setId()
     * @uses LinhasLiqERP::setIdCabLiq()
     * @uses LinhasLiqERP::setIdHistorico()
     * @uses LinhasLiqERP::setIdMovCBLOrig()
     * @uses LinhasLiqERP::setMandato()
     * @uses LinhasLiqERP::setModuloOrig()
     * @uses LinhasLiqERP::setMoedaDaUEMDocOrig()
     * @uses LinhasLiqERP::setMoedaDocOrig()
     * @uses LinhasLiqERP::setNumDoc()
     * @uses LinhasLiqERP::setNumDocOrig()
     * @uses LinhasLiqERP::setNumDocOrigInt()
     * @uses LinhasLiqERP::setNumPrestacao()
     * @uses LinhasLiqERP::setNumTransferencia()
     * @uses LinhasLiqERP::setObraId()
     * @uses LinhasLiqERP::setObservacoesSEPA()
     * @uses LinhasLiqERP::setPendenteGerado()
     * @uses LinhasLiqERP::setProtegida()
     * @uses LinhasLiqERP::setSerie()
     * @uses LinhasLiqERP::setSerieOrig()
     * @uses LinhasLiqERP::setTipoConta()
     * @uses LinhasLiqERP::setTipoDoc()
     * @uses LinhasLiqERP::setTipoDocOrig()
     * @uses LinhasLiqERP::setTipoEntidade()
     * @uses LinhasLiqERP::setTipoOrig()
     * @uses LinhasLiqERP::setTransfereEntidade()
     * @uses LinhasLiqERP::setValorDescMoedaOrig()
     * @uses LinhasLiqERP::setValorDesconto()
     * @uses LinhasLiqERP::setValorOrig()
     * @uses LinhasLiqERP::setValorPend()
     * @uses LinhasLiqERP::setValorRec()
     * @uses LinhasLiqERP::setValorRecMoedaOrig()
     * @uses LinhasLiqERP::setValorRetGarRecMoedaOrig()
     * @uses LinhasLiqERP::setValorRetRecMoedaOrig()
     * @uses LinhasLiqERP::setValorRetencao()
     * @uses LinhasLiqERP::setValorRetencaoGarantia()
     * @uses LinhasLiqERP::setValorRetencaoGarantiaPendente()
     * @uses LinhasLiqERP::setValorRetencaoPendente()
     * @uses LinhasLiqERP::setVersaoUltAct()
     * @uses LinhasLiqERP::setWBSItem()
     * @param float $cambioDocOrig
     * @param float $cambioLiq
     * @param float $cambioMAltDocOrig
     * @param float $cambioMAltLiq
     * @param float $cambioMBaseDocOrig
     * @param float $cambioMBaseLiq
     * @param string $contaBNCOrig
     * @param string $contaCBL
     * @param string $contaDomiciliacao
     * @param float $correccaoMonetaria
     * @param string $dataCobranca
     * @param string $dataDoc
     * @param float $difArredondamento
     * @param float $difArredondamentoMAlt
     * @param float $difCambio
     * @param float $difCambioMAlt
     * @param string $entidade
     * @param string $estado
     * @param string $filial
     * @param string $filialOrig
     * @param bool $financiada
     * @param string $id
     * @param string $idCabLiq
     * @param string $idHistorico
     * @param string $idMovCBLOrig
     * @param string $mandato
     * @param string $moduloOrig
     * @param bool $moedaDaUEMDocOrig
     * @param string $moedaDocOrig
     * @param int $numDoc
     * @param string $numDocOrig
     * @param int $numDocOrigInt
     * @param int $numPrestacao
     * @param int $numTransferencia
     * @param string $obraId
     * @param string $observacoesSEPA
     * @param bool $pendenteGerado
     * @param bool $protegida
     * @param string $serie
     * @param string $serieOrig
     * @param string $tipoConta
     * @param string $tipoDoc
     * @param string $tipoDocOrig
     * @param string $tipoEntidade
     * @param string $tipoOrig
     * @param bool $transfereEntidade
     * @param float $valorDescMoedaOrig
     * @param float $valorDesconto
     * @param float $valorOrig
     * @param float $valorPend
     * @param float $valorRec
     * @param float $valorRecMoedaOrig
     * @param float $valorRetGarRecMoedaOrig
     * @param float $valorRetRecMoedaOrig
     * @param float $valorRetencao
     * @param float $valorRetencaoGarantia
     * @param float $valorRetencaoGarantiaPendente
     * @param float $valorRetencaoPendente
     * @param string $versaoUltAct
     * @param string $wBSItem
     */
    public function __construct($cambioDocOrig = null, $cambioLiq = null, $cambioMAltDocOrig = null, $cambioMAltLiq = null, $cambioMBaseDocOrig = null, $cambioMBaseLiq = null, $contaBNCOrig = null, $contaCBL = null, $contaDomiciliacao = null, $correccaoMonetaria = null, $dataCobranca = null, $dataDoc = null, $difArredondamento = null, $difArredondamentoMAlt = null, $difCambio = null, $difCambioMAlt = null, $entidade = null, $estado = null, $filial = null, $filialOrig = null, $financiada = null, $id = null, $idCabLiq = null, $idHistorico = null, $idMovCBLOrig = null, $mandato = null, $moduloOrig = null, $moedaDaUEMDocOrig = null, $moedaDocOrig = null, $numDoc = null, $numDocOrig = null, $numDocOrigInt = null, $numPrestacao = null, $numTransferencia = null, $obraId = null, $observacoesSEPA = null, $pendenteGerado = null, $protegida = null, $serie = null, $serieOrig = null, $tipoConta = null, $tipoDoc = null, $tipoDocOrig = null, $tipoEntidade = null, $tipoOrig = null, $transfereEntidade = null, $valorDescMoedaOrig = null, $valorDesconto = null, $valorOrig = null, $valorPend = null, $valorRec = null, $valorRecMoedaOrig = null, $valorRetGarRecMoedaOrig = null, $valorRetRecMoedaOrig = null, $valorRetencao = null, $valorRetencaoGarantia = null, $valorRetencaoGarantiaPendente = null, $valorRetencaoPendente = null, $versaoUltAct = null, $wBSItem = null)
    {
        $this
            ->setCambioDocOrig($cambioDocOrig)
            ->setCambioLiq($cambioLiq)
            ->setCambioMAltDocOrig($cambioMAltDocOrig)
            ->setCambioMAltLiq($cambioMAltLiq)
            ->setCambioMBaseDocOrig($cambioMBaseDocOrig)
            ->setCambioMBaseLiq($cambioMBaseLiq)
            ->setContaBNCOrig($contaBNCOrig)
            ->setContaCBL($contaCBL)
            ->setContaDomiciliacao($contaDomiciliacao)
            ->setCorreccaoMonetaria($correccaoMonetaria)
            ->setDataCobranca($dataCobranca)
            ->setDataDoc($dataDoc)
            ->setDifArredondamento($difArredondamento)
            ->setDifArredondamentoMAlt($difArredondamentoMAlt)
            ->setDifCambio($difCambio)
            ->setDifCambioMAlt($difCambioMAlt)
            ->setEntidade($entidade)
            ->setEstado($estado)
            ->setFilial($filial)
            ->setFilialOrig($filialOrig)
            ->setFinanciada($financiada)
            ->setId($id)
            ->setIdCabLiq($idCabLiq)
            ->setIdHistorico($idHistorico)
            ->setIdMovCBLOrig($idMovCBLOrig)
            ->setMandato($mandato)
            ->setModuloOrig($moduloOrig)
            ->setMoedaDaUEMDocOrig($moedaDaUEMDocOrig)
            ->setMoedaDocOrig($moedaDocOrig)
            ->setNumDoc($numDoc)
            ->setNumDocOrig($numDocOrig)
            ->setNumDocOrigInt($numDocOrigInt)
            ->setNumPrestacao($numPrestacao)
            ->setNumTransferencia($numTransferencia)
            ->setObraId($obraId)
            ->setObservacoesSEPA($observacoesSEPA)
            ->setPendenteGerado($pendenteGerado)
            ->setProtegida($protegida)
            ->setSerie($serie)
            ->setSerieOrig($serieOrig)
            ->setTipoConta($tipoConta)
            ->setTipoDoc($tipoDoc)
            ->setTipoDocOrig($tipoDocOrig)
            ->setTipoEntidade($tipoEntidade)
            ->setTipoOrig($tipoOrig)
            ->setTransfereEntidade($transfereEntidade)
            ->setValorDescMoedaOrig($valorDescMoedaOrig)
            ->setValorDesconto($valorDesconto)
            ->setValorOrig($valorOrig)
            ->setValorPend($valorPend)
            ->setValorRec($valorRec)
            ->setValorRecMoedaOrig($valorRecMoedaOrig)
            ->setValorRetGarRecMoedaOrig($valorRetGarRecMoedaOrig)
            ->setValorRetRecMoedaOrig($valorRetRecMoedaOrig)
            ->setValorRetencao($valorRetencao)
            ->setValorRetencaoGarantia($valorRetencaoGarantia)
            ->setValorRetencaoGarantiaPendente($valorRetencaoGarantiaPendente)
            ->setValorRetencaoPendente($valorRetencaoPendente)
            ->setVersaoUltAct($versaoUltAct)
            ->setWBSItem($wBSItem);
    }
    /**
     * Get CambioDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioDocOrig()
    {
        return isset($this->CambioDocOrig) ? $this->CambioDocOrig : null;
    }
    /**
     * Set CambioDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setCambioDocOrig($cambioDocOrig = null)
    {
        if (is_null($cambioDocOrig) || (is_array($cambioDocOrig) && empty($cambioDocOrig))) {
            unset($this->CambioDocOrig);
        } else {
            $this->CambioDocOrig = $cambioDocOrig;
        }
        return $this;
    }
    /**
     * Get CambioLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioLiq()
    {
        return isset($this->CambioLiq) ? $this->CambioLiq : null;
    }
    /**
     * Set CambioLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioLiq
     * @return \StructType\LinhasLiqERP
     */
    public function setCambioLiq($cambioLiq = null)
    {
        if (is_null($cambioLiq) || (is_array($cambioLiq) && empty($cambioLiq))) {
            unset($this->CambioLiq);
        } else {
            $this->CambioLiq = $cambioLiq;
        }
        return $this;
    }
    /**
     * Get CambioMAltDocOrig value
     * @return float|null
     */
    public function getCambioMAltDocOrig()
    {
        return $this->CambioMAltDocOrig;
    }
    /**
     * Set CambioMAltDocOrig value
     * @param float $cambioMAltDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setCambioMAltDocOrig($cambioMAltDocOrig = null)
    {
        $this->CambioMAltDocOrig = $cambioMAltDocOrig;
        return $this;
    }
    /**
     * Get CambioMAltLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMAltLiq()
    {
        return isset($this->CambioMAltLiq) ? $this->CambioMAltLiq : null;
    }
    /**
     * Set CambioMAltLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMAltLiq
     * @return \StructType\LinhasLiqERP
     */
    public function setCambioMAltLiq($cambioMAltLiq = null)
    {
        if (is_null($cambioMAltLiq) || (is_array($cambioMAltLiq) && empty($cambioMAltLiq))) {
            unset($this->CambioMAltLiq);
        } else {
            $this->CambioMAltLiq = $cambioMAltLiq;
        }
        return $this;
    }
    /**
     * Get CambioMBaseDocOrig value
     * @return float|null
     */
    public function getCambioMBaseDocOrig()
    {
        return $this->CambioMBaseDocOrig;
    }
    /**
     * Set CambioMBaseDocOrig value
     * @param float $cambioMBaseDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setCambioMBaseDocOrig($cambioMBaseDocOrig = null)
    {
        $this->CambioMBaseDocOrig = $cambioMBaseDocOrig;
        return $this;
    }
    /**
     * Get CambioMBaseLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMBaseLiq()
    {
        return isset($this->CambioMBaseLiq) ? $this->CambioMBaseLiq : null;
    }
    /**
     * Set CambioMBaseLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMBaseLiq
     * @return \StructType\LinhasLiqERP
     */
    public function setCambioMBaseLiq($cambioMBaseLiq = null)
    {
        if (is_null($cambioMBaseLiq) || (is_array($cambioMBaseLiq) && empty($cambioMBaseLiq))) {
            unset($this->CambioMBaseLiq);
        } else {
            $this->CambioMBaseLiq = $cambioMBaseLiq;
        }
        return $this;
    }
    /**
     * Get ContaBNCOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaBNCOrig()
    {
        return isset($this->ContaBNCOrig) ? $this->ContaBNCOrig : null;
    }
    /**
     * Set ContaBNCOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaBNCOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setContaBNCOrig($contaBNCOrig = null)
    {
        // validation for constraint: string
        if (!is_null($contaBNCOrig) && !is_string($contaBNCOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaBNCOrig)), __LINE__);
        }
        if (is_null($contaBNCOrig) || (is_array($contaBNCOrig) && empty($contaBNCOrig))) {
            unset($this->ContaBNCOrig);
        } else {
            $this->ContaBNCOrig = $contaBNCOrig;
        }
        return $this;
    }
    /**
     * Get ContaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCBL()
    {
        return isset($this->ContaCBL) ? $this->ContaCBL : null;
    }
    /**
     * Set ContaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCBL
     * @return \StructType\LinhasLiqERP
     */
    public function setContaCBL($contaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($contaCBL) && !is_string($contaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaCBL)), __LINE__);
        }
        if (is_null($contaCBL) || (is_array($contaCBL) && empty($contaCBL))) {
            unset($this->ContaCBL);
        } else {
            $this->ContaCBL = $contaCBL;
        }
        return $this;
    }
    /**
     * Get ContaDomiciliacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaDomiciliacao()
    {
        return isset($this->ContaDomiciliacao) ? $this->ContaDomiciliacao : null;
    }
    /**
     * Set ContaDomiciliacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaDomiciliacao
     * @return \StructType\LinhasLiqERP
     */
    public function setContaDomiciliacao($contaDomiciliacao = null)
    {
        // validation for constraint: string
        if (!is_null($contaDomiciliacao) && !is_string($contaDomiciliacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaDomiciliacao)), __LINE__);
        }
        if (is_null($contaDomiciliacao) || (is_array($contaDomiciliacao) && empty($contaDomiciliacao))) {
            unset($this->ContaDomiciliacao);
        } else {
            $this->ContaDomiciliacao = $contaDomiciliacao;
        }
        return $this;
    }
    /**
     * Get CorreccaoMonetaria value
     * @return float|null
     */
    public function getCorreccaoMonetaria()
    {
        return $this->CorreccaoMonetaria;
    }
    /**
     * Set CorreccaoMonetaria value
     * @param float $correccaoMonetaria
     * @return \StructType\LinhasLiqERP
     */
    public function setCorreccaoMonetaria($correccaoMonetaria = null)
    {
        $this->CorreccaoMonetaria = $correccaoMonetaria;
        return $this;
    }
    /**
     * Get DataCobranca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataCobranca()
    {
        return isset($this->DataCobranca) ? $this->DataCobranca : null;
    }
    /**
     * Set DataCobranca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataCobranca
     * @return \StructType\LinhasLiqERP
     */
    public function setDataCobranca($dataCobranca = null)
    {
        // validation for constraint: string
        if (!is_null($dataCobranca) && !is_string($dataCobranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataCobranca)), __LINE__);
        }
        if (is_null($dataCobranca) || (is_array($dataCobranca) && empty($dataCobranca))) {
            unset($this->DataCobranca);
        } else {
            $this->DataCobranca = $dataCobranca;
        }
        return $this;
    }
    /**
     * Get DataDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDoc()
    {
        return isset($this->DataDoc) ? $this->DataDoc : null;
    }
    /**
     * Set DataDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDoc
     * @return \StructType\LinhasLiqERP
     */
    public function setDataDoc($dataDoc = null)
    {
        // validation for constraint: string
        if (!is_null($dataDoc) && !is_string($dataDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDoc)), __LINE__);
        }
        if (is_null($dataDoc) || (is_array($dataDoc) && empty($dataDoc))) {
            unset($this->DataDoc);
        } else {
            $this->DataDoc = $dataDoc;
        }
        return $this;
    }
    /**
     * Get DifArredondamento value
     * @return float|null
     */
    public function getDifArredondamento()
    {
        return $this->DifArredondamento;
    }
    /**
     * Set DifArredondamento value
     * @param float $difArredondamento
     * @return \StructType\LinhasLiqERP
     */
    public function setDifArredondamento($difArredondamento = null)
    {
        $this->DifArredondamento = $difArredondamento;
        return $this;
    }
    /**
     * Get DifArredondamentoMAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamentoMAlt()
    {
        return isset($this->DifArredondamentoMAlt) ? $this->DifArredondamentoMAlt : null;
    }
    /**
     * Set DifArredondamentoMAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamentoMAlt
     * @return \StructType\LinhasLiqERP
     */
    public function setDifArredondamentoMAlt($difArredondamentoMAlt = null)
    {
        if (is_null($difArredondamentoMAlt) || (is_array($difArredondamentoMAlt) && empty($difArredondamentoMAlt))) {
            unset($this->DifArredondamentoMAlt);
        } else {
            $this->DifArredondamentoMAlt = $difArredondamentoMAlt;
        }
        return $this;
    }
    /**
     * Get DifCambio value
     * @return float|null
     */
    public function getDifCambio()
    {
        return $this->DifCambio;
    }
    /**
     * Set DifCambio value
     * @param float $difCambio
     * @return \StructType\LinhasLiqERP
     */
    public function setDifCambio($difCambio = null)
    {
        $this->DifCambio = $difCambio;
        return $this;
    }
    /**
     * Get DifCambioMAlt value
     * @return float|null
     */
    public function getDifCambioMAlt()
    {
        return $this->DifCambioMAlt;
    }
    /**
     * Set DifCambioMAlt value
     * @param float $difCambioMAlt
     * @return \StructType\LinhasLiqERP
     */
    public function setDifCambioMAlt($difCambioMAlt = null)
    {
        $this->DifCambioMAlt = $difCambioMAlt;
        return $this;
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\LinhasLiqERP
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \StructType\LinhasLiqERP
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get Filial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilial()
    {
        return isset($this->Filial) ? $this->Filial : null;
    }
    /**
     * Set Filial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filial
     * @return \StructType\LinhasLiqERP
     */
    public function setFilial($filial = null)
    {
        // validation for constraint: string
        if (!is_null($filial) && !is_string($filial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filial)), __LINE__);
        }
        if (is_null($filial) || (is_array($filial) && empty($filial))) {
            unset($this->Filial);
        } else {
            $this->Filial = $filial;
        }
        return $this;
    }
    /**
     * Get FilialOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilialOrig()
    {
        return isset($this->FilialOrig) ? $this->FilialOrig : null;
    }
    /**
     * Set FilialOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filialOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setFilialOrig($filialOrig = null)
    {
        // validation for constraint: string
        if (!is_null($filialOrig) && !is_string($filialOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filialOrig)), __LINE__);
        }
        if (is_null($filialOrig) || (is_array($filialOrig) && empty($filialOrig))) {
            unset($this->FilialOrig);
        } else {
            $this->FilialOrig = $filialOrig;
        }
        return $this;
    }
    /**
     * Get Financiada value
     * @return bool|null
     */
    public function getFinanciada()
    {
        return $this->Financiada;
    }
    /**
     * Set Financiada value
     * @param bool $financiada
     * @return \StructType\LinhasLiqERP
     */
    public function setFinanciada($financiada = null)
    {
        // validation for constraint: boolean
        if (!is_null($financiada) && !is_bool($financiada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($financiada)), __LINE__);
        }
        $this->Financiada = $financiada;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\LinhasLiqERP
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdCabLiq value
     * @return string|null
     */
    public function getIdCabLiq()
    {
        return $this->IdCabLiq;
    }
    /**
     * Set IdCabLiq value
     * @param string $idCabLiq
     * @return \StructType\LinhasLiqERP
     */
    public function setIdCabLiq($idCabLiq = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCabLiq) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCabLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCabLiq, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCabLiq) && !is_string($idCabLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCabLiq)), __LINE__);
        }
        $this->IdCabLiq = $idCabLiq;
        return $this;
    }
    /**
     * Get IdHistorico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdHistorico()
    {
        return isset($this->IdHistorico) ? $this->IdHistorico : null;
    }
    /**
     * Set IdHistorico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idHistorico
     * @return \StructType\LinhasLiqERP
     */
    public function setIdHistorico($idHistorico = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idHistorico) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idHistorico, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idHistorico) && !is_string($idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idHistorico)), __LINE__);
        }
        if (is_null($idHistorico) || (is_array($idHistorico) && empty($idHistorico))) {
            unset($this->IdHistorico);
        } else {
            $this->IdHistorico = $idHistorico;
        }
        return $this;
    }
    /**
     * Get IdMovCBLOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdMovCBLOrig()
    {
        return isset($this->IdMovCBLOrig) ? $this->IdMovCBLOrig : null;
    }
    /**
     * Set IdMovCBLOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idMovCBLOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setIdMovCBLOrig($idMovCBLOrig = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idMovCBLOrig) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idMovCBLOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idMovCBLOrig, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idMovCBLOrig) && !is_string($idMovCBLOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idMovCBLOrig)), __LINE__);
        }
        if (is_null($idMovCBLOrig) || (is_array($idMovCBLOrig) && empty($idMovCBLOrig))) {
            unset($this->IdMovCBLOrig);
        } else {
            $this->IdMovCBLOrig = $idMovCBLOrig;
        }
        return $this;
    }
    /**
     * Get Mandato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandato()
    {
        return isset($this->Mandato) ? $this->Mandato : null;
    }
    /**
     * Set Mandato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandato
     * @return \StructType\LinhasLiqERP
     */
    public function setMandato($mandato = null)
    {
        // validation for constraint: string
        if (!is_null($mandato) && !is_string($mandato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mandato)), __LINE__);
        }
        if (is_null($mandato) || (is_array($mandato) && empty($mandato))) {
            unset($this->Mandato);
        } else {
            $this->Mandato = $mandato;
        }
        return $this;
    }
    /**
     * Get ModuloOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModuloOrig()
    {
        return isset($this->ModuloOrig) ? $this->ModuloOrig : null;
    }
    /**
     * Set ModuloOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moduloOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setModuloOrig($moduloOrig = null)
    {
        // validation for constraint: string
        if (!is_null($moduloOrig) && !is_string($moduloOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moduloOrig)), __LINE__);
        }
        if (is_null($moduloOrig) || (is_array($moduloOrig) && empty($moduloOrig))) {
            unset($this->ModuloOrig);
        } else {
            $this->ModuloOrig = $moduloOrig;
        }
        return $this;
    }
    /**
     * Get MoedaDaUEMDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMoedaDaUEMDocOrig()
    {
        return isset($this->MoedaDaUEMDocOrig) ? $this->MoedaDaUEMDocOrig : null;
    }
    /**
     * Set MoedaDaUEMDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $moedaDaUEMDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setMoedaDaUEMDocOrig($moedaDaUEMDocOrig = null)
    {
        // validation for constraint: boolean
        if (!is_null($moedaDaUEMDocOrig) && !is_bool($moedaDaUEMDocOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moedaDaUEMDocOrig)), __LINE__);
        }
        if (is_null($moedaDaUEMDocOrig) || (is_array($moedaDaUEMDocOrig) && empty($moedaDaUEMDocOrig))) {
            unset($this->MoedaDaUEMDocOrig);
        } else {
            $this->MoedaDaUEMDocOrig = $moedaDaUEMDocOrig;
        }
        return $this;
    }
    /**
     * Get MoedaDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoedaDocOrig()
    {
        return isset($this->MoedaDocOrig) ? $this->MoedaDocOrig : null;
    }
    /**
     * Set MoedaDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moedaDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setMoedaDocOrig($moedaDocOrig = null)
    {
        // validation for constraint: string
        if (!is_null($moedaDocOrig) && !is_string($moedaDocOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moedaDocOrig)), __LINE__);
        }
        if (is_null($moedaDocOrig) || (is_array($moedaDocOrig) && empty($moedaDocOrig))) {
            unset($this->MoedaDocOrig);
        } else {
            $this->MoedaDocOrig = $moedaDocOrig;
        }
        return $this;
    }
    /**
     * Get NumDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumDoc()
    {
        return isset($this->NumDoc) ? $this->NumDoc : null;
    }
    /**
     * Set NumDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numDoc
     * @return \StructType\LinhasLiqERP
     */
    public function setNumDoc($numDoc = null)
    {
        // validation for constraint: int
        if (!is_null($numDoc) && !is_numeric($numDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDoc)), __LINE__);
        }
        if (is_null($numDoc) || (is_array($numDoc) && empty($numDoc))) {
            unset($this->NumDoc);
        } else {
            $this->NumDoc = $numDoc;
        }
        return $this;
    }
    /**
     * Get NumDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumDocOrig()
    {
        return isset($this->NumDocOrig) ? $this->NumDocOrig : null;
    }
    /**
     * Set NumDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setNumDocOrig($numDocOrig = null)
    {
        // validation for constraint: string
        if (!is_null($numDocOrig) && !is_string($numDocOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numDocOrig)), __LINE__);
        }
        if (is_null($numDocOrig) || (is_array($numDocOrig) && empty($numDocOrig))) {
            unset($this->NumDocOrig);
        } else {
            $this->NumDocOrig = $numDocOrig;
        }
        return $this;
    }
    /**
     * Get NumDocOrigInt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumDocOrigInt()
    {
        return isset($this->NumDocOrigInt) ? $this->NumDocOrigInt : null;
    }
    /**
     * Set NumDocOrigInt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numDocOrigInt
     * @return \StructType\LinhasLiqERP
     */
    public function setNumDocOrigInt($numDocOrigInt = null)
    {
        // validation for constraint: int
        if (!is_null($numDocOrigInt) && !is_numeric($numDocOrigInt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDocOrigInt)), __LINE__);
        }
        if (is_null($numDocOrigInt) || (is_array($numDocOrigInt) && empty($numDocOrigInt))) {
            unset($this->NumDocOrigInt);
        } else {
            $this->NumDocOrigInt = $numDocOrigInt;
        }
        return $this;
    }
    /**
     * Get NumPrestacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumPrestacao()
    {
        return isset($this->NumPrestacao) ? $this->NumPrestacao : null;
    }
    /**
     * Set NumPrestacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numPrestacao
     * @return \StructType\LinhasLiqERP
     */
    public function setNumPrestacao($numPrestacao = null)
    {
        // validation for constraint: int
        if (!is_null($numPrestacao) && !is_numeric($numPrestacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numPrestacao)), __LINE__);
        }
        if (is_null($numPrestacao) || (is_array($numPrestacao) && empty($numPrestacao))) {
            unset($this->NumPrestacao);
        } else {
            $this->NumPrestacao = $numPrestacao;
        }
        return $this;
    }
    /**
     * Get NumTransferencia value
     * @return int|null
     */
    public function getNumTransferencia()
    {
        return $this->NumTransferencia;
    }
    /**
     * Set NumTransferencia value
     * @param int $numTransferencia
     * @return \StructType\LinhasLiqERP
     */
    public function setNumTransferencia($numTransferencia = null)
    {
        // validation for constraint: int
        if (!is_null($numTransferencia) && !is_numeric($numTransferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numTransferencia)), __LINE__);
        }
        $this->NumTransferencia = $numTransferencia;
        return $this;
    }
    /**
     * Get ObraId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObraId()
    {
        return isset($this->ObraId) ? $this->ObraId : null;
    }
    /**
     * Set ObraId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $obraId
     * @return \StructType\LinhasLiqERP
     */
    public function setObraId($obraId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($obraId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $obraId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($obraId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($obraId) && !is_string($obraId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obraId)), __LINE__);
        }
        if (is_null($obraId) || (is_array($obraId) && empty($obraId))) {
            unset($this->ObraId);
        } else {
            $this->ObraId = $obraId;
        }
        return $this;
    }
    /**
     * Get ObservacoesSEPA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacoesSEPA()
    {
        return isset($this->ObservacoesSEPA) ? $this->ObservacoesSEPA : null;
    }
    /**
     * Set ObservacoesSEPA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacoesSEPA
     * @return \StructType\LinhasLiqERP
     */
    public function setObservacoesSEPA($observacoesSEPA = null)
    {
        // validation for constraint: string
        if (!is_null($observacoesSEPA) && !is_string($observacoesSEPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($observacoesSEPA)), __LINE__);
        }
        if (is_null($observacoesSEPA) || (is_array($observacoesSEPA) && empty($observacoesSEPA))) {
            unset($this->ObservacoesSEPA);
        } else {
            $this->ObservacoesSEPA = $observacoesSEPA;
        }
        return $this;
    }
    /**
     * Get PendenteGerado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPendenteGerado()
    {
        return isset($this->PendenteGerado) ? $this->PendenteGerado : null;
    }
    /**
     * Set PendenteGerado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pendenteGerado
     * @return \StructType\LinhasLiqERP
     */
    public function setPendenteGerado($pendenteGerado = null)
    {
        // validation for constraint: boolean
        if (!is_null($pendenteGerado) && !is_bool($pendenteGerado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pendenteGerado)), __LINE__);
        }
        if (is_null($pendenteGerado) || (is_array($pendenteGerado) && empty($pendenteGerado))) {
            unset($this->PendenteGerado);
        } else {
            $this->PendenteGerado = $pendenteGerado;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasLiqERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Serie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerie()
    {
        return isset($this->Serie) ? $this->Serie : null;
    }
    /**
     * Set Serie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serie
     * @return \StructType\LinhasLiqERP
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serie)), __LINE__);
        }
        if (is_null($serie) || (is_array($serie) && empty($serie))) {
            unset($this->Serie);
        } else {
            $this->Serie = $serie;
        }
        return $this;
    }
    /**
     * Get SerieOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieOrig()
    {
        return isset($this->SerieOrig) ? $this->SerieOrig : null;
    }
    /**
     * Set SerieOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setSerieOrig($serieOrig = null)
    {
        // validation for constraint: string
        if (!is_null($serieOrig) && !is_string($serieOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieOrig)), __LINE__);
        }
        if (is_null($serieOrig) || (is_array($serieOrig) && empty($serieOrig))) {
            unset($this->SerieOrig);
        } else {
            $this->SerieOrig = $serieOrig;
        }
        return $this;
    }
    /**
     * Get TipoConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoConta()
    {
        return isset($this->TipoConta) ? $this->TipoConta : null;
    }
    /**
     * Set TipoConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoConta
     * @return \StructType\LinhasLiqERP
     */
    public function setTipoConta($tipoConta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoConta) && !is_string($tipoConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoConta)), __LINE__);
        }
        if (is_null($tipoConta) || (is_array($tipoConta) && empty($tipoConta))) {
            unset($this->TipoConta);
        } else {
            $this->TipoConta = $tipoConta;
        }
        return $this;
    }
    /**
     * Get TipoDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDoc()
    {
        return isset($this->TipoDoc) ? $this->TipoDoc : null;
    }
    /**
     * Set TipoDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDoc
     * @return \StructType\LinhasLiqERP
     */
    public function setTipoDoc($tipoDoc = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDoc) && !is_string($tipoDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDoc)), __LINE__);
        }
        if (is_null($tipoDoc) || (is_array($tipoDoc) && empty($tipoDoc))) {
            unset($this->TipoDoc);
        } else {
            $this->TipoDoc = $tipoDoc;
        }
        return $this;
    }
    /**
     * Get TipoDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDocOrig()
    {
        return isset($this->TipoDocOrig) ? $this->TipoDocOrig : null;
    }
    /**
     * Set TipoDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDocOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setTipoDocOrig($tipoDocOrig = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocOrig) && !is_string($tipoDocOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDocOrig)), __LINE__);
        }
        if (is_null($tipoDocOrig) || (is_array($tipoDocOrig) && empty($tipoDocOrig))) {
            unset($this->TipoDocOrig);
        } else {
            $this->TipoDocOrig = $tipoDocOrig;
        }
        return $this;
    }
    /**
     * Get TipoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidade()
    {
        return isset($this->TipoEntidade) ? $this->TipoEntidade : null;
    }
    /**
     * Set TipoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidade
     * @return \StructType\LinhasLiqERP
     */
    public function setTipoEntidade($tipoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidade) && !is_string($tipoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidade)), __LINE__);
        }
        if (is_null($tipoEntidade) || (is_array($tipoEntidade) && empty($tipoEntidade))) {
            unset($this->TipoEntidade);
        } else {
            $this->TipoEntidade = $tipoEntidade;
        }
        return $this;
    }
    /**
     * Get TipoOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoOrig()
    {
        return isset($this->TipoOrig) ? $this->TipoOrig : null;
    }
    /**
     * Set TipoOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setTipoOrig($tipoOrig = null)
    {
        // validation for constraint: string
        if (!is_null($tipoOrig) && !is_string($tipoOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoOrig)), __LINE__);
        }
        if (is_null($tipoOrig) || (is_array($tipoOrig) && empty($tipoOrig))) {
            unset($this->TipoOrig);
        } else {
            $this->TipoOrig = $tipoOrig;
        }
        return $this;
    }
    /**
     * Get TransfereEntidade value
     * @return bool|null
     */
    public function getTransfereEntidade()
    {
        return $this->TransfereEntidade;
    }
    /**
     * Set TransfereEntidade value
     * @param bool $transfereEntidade
     * @return \StructType\LinhasLiqERP
     */
    public function setTransfereEntidade($transfereEntidade = null)
    {
        // validation for constraint: boolean
        if (!is_null($transfereEntidade) && !is_bool($transfereEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($transfereEntidade)), __LINE__);
        }
        $this->TransfereEntidade = $transfereEntidade;
        return $this;
    }
    /**
     * Get ValorDescMoedaOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorDescMoedaOrig()
    {
        return isset($this->ValorDescMoedaOrig) ? $this->ValorDescMoedaOrig : null;
    }
    /**
     * Set ValorDescMoedaOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorDescMoedaOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setValorDescMoedaOrig($valorDescMoedaOrig = null)
    {
        if (is_null($valorDescMoedaOrig) || (is_array($valorDescMoedaOrig) && empty($valorDescMoedaOrig))) {
            unset($this->ValorDescMoedaOrig);
        } else {
            $this->ValorDescMoedaOrig = $valorDescMoedaOrig;
        }
        return $this;
    }
    /**
     * Get ValorDesconto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorDesconto()
    {
        return isset($this->ValorDesconto) ? $this->ValorDesconto : null;
    }
    /**
     * Set ValorDesconto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorDesconto
     * @return \StructType\LinhasLiqERP
     */
    public function setValorDesconto($valorDesconto = null)
    {
        if (is_null($valorDesconto) || (is_array($valorDesconto) && empty($valorDesconto))) {
            unset($this->ValorDesconto);
        } else {
            $this->ValorDesconto = $valorDesconto;
        }
        return $this;
    }
    /**
     * Get ValorOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorOrig()
    {
        return isset($this->ValorOrig) ? $this->ValorOrig : null;
    }
    /**
     * Set ValorOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setValorOrig($valorOrig = null)
    {
        if (is_null($valorOrig) || (is_array($valorOrig) && empty($valorOrig))) {
            unset($this->ValorOrig);
        } else {
            $this->ValorOrig = $valorOrig;
        }
        return $this;
    }
    /**
     * Get ValorPend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPend()
    {
        return isset($this->ValorPend) ? $this->ValorPend : null;
    }
    /**
     * Set ValorPend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPend
     * @return \StructType\LinhasLiqERP
     */
    public function setValorPend($valorPend = null)
    {
        if (is_null($valorPend) || (is_array($valorPend) && empty($valorPend))) {
            unset($this->ValorPend);
        } else {
            $this->ValorPend = $valorPend;
        }
        return $this;
    }
    /**
     * Get ValorRec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRec()
    {
        return isset($this->ValorRec) ? $this->ValorRec : null;
    }
    /**
     * Set ValorRec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRec
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRec($valorRec = null)
    {
        if (is_null($valorRec) || (is_array($valorRec) && empty($valorRec))) {
            unset($this->ValorRec);
        } else {
            $this->ValorRec = $valorRec;
        }
        return $this;
    }
    /**
     * Get ValorRecMoedaOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRecMoedaOrig()
    {
        return isset($this->ValorRecMoedaOrig) ? $this->ValorRecMoedaOrig : null;
    }
    /**
     * Set ValorRecMoedaOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRecMoedaOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRecMoedaOrig($valorRecMoedaOrig = null)
    {
        if (is_null($valorRecMoedaOrig) || (is_array($valorRecMoedaOrig) && empty($valorRecMoedaOrig))) {
            unset($this->ValorRecMoedaOrig);
        } else {
            $this->ValorRecMoedaOrig = $valorRecMoedaOrig;
        }
        return $this;
    }
    /**
     * Get ValorRetGarRecMoedaOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetGarRecMoedaOrig()
    {
        return isset($this->ValorRetGarRecMoedaOrig) ? $this->ValorRetGarRecMoedaOrig : null;
    }
    /**
     * Set ValorRetGarRecMoedaOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetGarRecMoedaOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRetGarRecMoedaOrig($valorRetGarRecMoedaOrig = null)
    {
        if (is_null($valorRetGarRecMoedaOrig) || (is_array($valorRetGarRecMoedaOrig) && empty($valorRetGarRecMoedaOrig))) {
            unset($this->ValorRetGarRecMoedaOrig);
        } else {
            $this->ValorRetGarRecMoedaOrig = $valorRetGarRecMoedaOrig;
        }
        return $this;
    }
    /**
     * Get ValorRetRecMoedaOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetRecMoedaOrig()
    {
        return isset($this->ValorRetRecMoedaOrig) ? $this->ValorRetRecMoedaOrig : null;
    }
    /**
     * Set ValorRetRecMoedaOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetRecMoedaOrig
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRetRecMoedaOrig($valorRetRecMoedaOrig = null)
    {
        if (is_null($valorRetRecMoedaOrig) || (is_array($valorRetRecMoedaOrig) && empty($valorRetRecMoedaOrig))) {
            unset($this->ValorRetRecMoedaOrig);
        } else {
            $this->ValorRetRecMoedaOrig = $valorRetRecMoedaOrig;
        }
        return $this;
    }
    /**
     * Get ValorRetencao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencao()
    {
        return isset($this->ValorRetencao) ? $this->ValorRetencao : null;
    }
    /**
     * Set ValorRetencao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencao
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRetencao($valorRetencao = null)
    {
        if (is_null($valorRetencao) || (is_array($valorRetencao) && empty($valorRetencao))) {
            unset($this->ValorRetencao);
        } else {
            $this->ValorRetencao = $valorRetencao;
        }
        return $this;
    }
    /**
     * Get ValorRetencaoGarantia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoGarantia()
    {
        return isset($this->ValorRetencaoGarantia) ? $this->ValorRetencaoGarantia : null;
    }
    /**
     * Set ValorRetencaoGarantia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoGarantia
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRetencaoGarantia($valorRetencaoGarantia = null)
    {
        if (is_null($valorRetencaoGarantia) || (is_array($valorRetencaoGarantia) && empty($valorRetencaoGarantia))) {
            unset($this->ValorRetencaoGarantia);
        } else {
            $this->ValorRetencaoGarantia = $valorRetencaoGarantia;
        }
        return $this;
    }
    /**
     * Get ValorRetencaoGarantiaPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoGarantiaPendente()
    {
        return isset($this->ValorRetencaoGarantiaPendente) ? $this->ValorRetencaoGarantiaPendente : null;
    }
    /**
     * Set ValorRetencaoGarantiaPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoGarantiaPendente
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRetencaoGarantiaPendente($valorRetencaoGarantiaPendente = null)
    {
        if (is_null($valorRetencaoGarantiaPendente) || (is_array($valorRetencaoGarantiaPendente) && empty($valorRetencaoGarantiaPendente))) {
            unset($this->ValorRetencaoGarantiaPendente);
        } else {
            $this->ValorRetencaoGarantiaPendente = $valorRetencaoGarantiaPendente;
        }
        return $this;
    }
    /**
     * Get ValorRetencaoPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoPendente()
    {
        return isset($this->ValorRetencaoPendente) ? $this->ValorRetencaoPendente : null;
    }
    /**
     * Set ValorRetencaoPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoPendente
     * @return \StructType\LinhasLiqERP
     */
    public function setValorRetencaoPendente($valorRetencaoPendente = null)
    {
        if (is_null($valorRetencaoPendente) || (is_array($valorRetencaoPendente) && empty($valorRetencaoPendente))) {
            unset($this->ValorRetencaoPendente);
        } else {
            $this->ValorRetencaoPendente = $valorRetencaoPendente;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasLiqERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Get WBSItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBSItem()
    {
        return isset($this->WBSItem) ? $this->WBSItem : null;
    }
    /**
     * Set WBSItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBSItem
     * @return \StructType\LinhasLiqERP
     */
    public function setWBSItem($wBSItem = null)
    {
        // validation for constraint: string
        if (!is_null($wBSItem) && !is_string($wBSItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wBSItem)), __LINE__);
        }
        if (is_null($wBSItem) || (is_array($wBSItem) && empty($wBSItem))) {
            unset($this->WBSItem);
        } else {
            $this->WBSItem = $wBSItem;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasLiqERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
