<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasInternosStatusERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasInternosStatusERP
 * @subpackage Structs
 */
class LinhasInternosStatusERP extends AbstractStructBase
{
    /**
     * The IdLinha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinha;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QuantCopiada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantCopiada;
    /**
     * The Quantidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantidade;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for LinhasInternosStatusERP
     * @uses LinhasInternosStatusERP::setIdLinha()
     * @uses LinhasInternosStatusERP::setProtegida()
     * @uses LinhasInternosStatusERP::setQuantCopiada()
     * @uses LinhasInternosStatusERP::setQuantidade()
     * @uses LinhasInternosStatusERP::setVersaoUltAct()
     * @param string $idLinha
     * @param bool $protegida
     * @param float $quantCopiada
     * @param float $quantidade
     * @param string $versaoUltAct
     */
    public function __construct($idLinha = null, $protegida = null, $quantCopiada = null, $quantidade = null, $versaoUltAct = null)
    {
        $this
            ->setIdLinha($idLinha)
            ->setProtegida($protegida)
            ->setQuantCopiada($quantCopiada)
            ->setQuantidade($quantidade)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get IdLinha value
     * @return string|null
     */
    public function getIdLinha()
    {
        return $this->IdLinha;
    }
    /**
     * Set IdLinha value
     * @param string $idLinha
     * @return \StructType\LinhasInternosStatusERP
     */
    public function setIdLinha($idLinha = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinha) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinha, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinha) && !is_string($idLinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinha)), __LINE__);
        }
        $this->IdLinha = $idLinha;
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasInternosStatusERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QuantCopiada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantCopiada()
    {
        return isset($this->QuantCopiada) ? $this->QuantCopiada : null;
    }
    /**
     * Set QuantCopiada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantCopiada
     * @return \StructType\LinhasInternosStatusERP
     */
    public function setQuantCopiada($quantCopiada = null)
    {
        if (is_null($quantCopiada) || (is_array($quantCopiada) && empty($quantCopiada))) {
            unset($this->QuantCopiada);
        } else {
            $this->QuantCopiada = $quantCopiada;
        }
        return $this;
    }
    /**
     * Get Quantidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantidade()
    {
        return isset($this->Quantidade) ? $this->Quantidade : null;
    }
    /**
     * Set Quantidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantidade
     * @return \StructType\LinhasInternosStatusERP
     */
    public function setQuantidade($quantidade = null)
    {
        if (is_null($quantidade) || (is_array($quantidade) && empty($quantidade))) {
            unset($this->Quantidade);
        } else {
            $this->Quantidade = $quantidade;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasInternosStatusERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasInternosStatusERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
