<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasContactoEntidadesERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasContactoEntidadesERP
 * @subpackage Structs
 */
class LinhasContactoEntidadesERP extends AbstractStructBase
{
    /**
     * The Cargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cargo;
    /**
     * The CriadoPor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CriadoPor;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The IDContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDContacto;
    /**
     * The Notas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notas;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Telefone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefone;
    /**
     * The Telemovel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telemovel;
    /**
     * The TipoContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoContacto;
    /**
     * The TipoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidade;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for LinhasContactoEntidadesERP
     * @uses LinhasContactoEntidadesERP::setCargo()
     * @uses LinhasContactoEntidadesERP::setCriadoPor()
     * @uses LinhasContactoEntidadesERP::setEmail()
     * @uses LinhasContactoEntidadesERP::setEntidade()
     * @uses LinhasContactoEntidadesERP::setFax()
     * @uses LinhasContactoEntidadesERP::setIDContacto()
     * @uses LinhasContactoEntidadesERP::setNotas()
     * @uses LinhasContactoEntidadesERP::setProtegida()
     * @uses LinhasContactoEntidadesERP::setTelefone()
     * @uses LinhasContactoEntidadesERP::setTelemovel()
     * @uses LinhasContactoEntidadesERP::setTipoContacto()
     * @uses LinhasContactoEntidadesERP::setTipoEntidade()
     * @uses LinhasContactoEntidadesERP::setVersaoUltAct()
     * @param string $cargo
     * @param string $criadoPor
     * @param string $email
     * @param string $entidade
     * @param string $fax
     * @param string $iDContacto
     * @param string $notas
     * @param bool $protegida
     * @param string $telefone
     * @param string $telemovel
     * @param string $tipoContacto
     * @param string $tipoEntidade
     * @param string $versaoUltAct
     */
    public function __construct($cargo = null, $criadoPor = null, $email = null, $entidade = null, $fax = null, $iDContacto = null, $notas = null, $protegida = null, $telefone = null, $telemovel = null, $tipoContacto = null, $tipoEntidade = null, $versaoUltAct = null)
    {
        $this
            ->setCargo($cargo)
            ->setCriadoPor($criadoPor)
            ->setEmail($email)
            ->setEntidade($entidade)
            ->setFax($fax)
            ->setIDContacto($iDContacto)
            ->setNotas($notas)
            ->setProtegida($protegida)
            ->setTelefone($telefone)
            ->setTelemovel($telemovel)
            ->setTipoContacto($tipoContacto)
            ->setTipoEntidade($tipoEntidade)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Cargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCargo()
    {
        return isset($this->Cargo) ? $this->Cargo : null;
    }
    /**
     * Set Cargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cargo
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setCargo($cargo = null)
    {
        // validation for constraint: string
        if (!is_null($cargo) && !is_string($cargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cargo)), __LINE__);
        }
        if (is_null($cargo) || (is_array($cargo) && empty($cargo))) {
            unset($this->Cargo);
        } else {
            $this->Cargo = $cargo;
        }
        return $this;
    }
    /**
     * Get CriadoPor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriadoPor()
    {
        return isset($this->CriadoPor) ? $this->CriadoPor : null;
    }
    /**
     * Set CriadoPor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $criadoPor
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setCriadoPor($criadoPor = null)
    {
        // validation for constraint: string
        if (!is_null($criadoPor) && !is_string($criadoPor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($criadoPor)), __LINE__);
        }
        if (is_null($criadoPor) || (is_array($criadoPor) && empty($criadoPor))) {
            unset($this->CriadoPor);
        } else {
            $this->CriadoPor = $criadoPor;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get IDContacto value
     * @return string|null
     */
    public function getIDContacto()
    {
        return $this->IDContacto;
    }
    /**
     * Set IDContacto value
     * @param string $iDContacto
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setIDContacto($iDContacto = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDContacto) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDContacto, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDContacto) && !is_string($iDContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDContacto)), __LINE__);
        }
        $this->IDContacto = $iDContacto;
        return $this;
    }
    /**
     * Get Notas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotas()
    {
        return isset($this->Notas) ? $this->Notas : null;
    }
    /**
     * Set Notas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notas
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setNotas($notas = null)
    {
        // validation for constraint: string
        if (!is_null($notas) && !is_string($notas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notas)), __LINE__);
        }
        if (is_null($notas) || (is_array($notas) && empty($notas))) {
            unset($this->Notas);
        } else {
            $this->Notas = $notas;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Telefone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefone()
    {
        return isset($this->Telefone) ? $this->Telefone : null;
    }
    /**
     * Set Telefone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefone
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefone)), __LINE__);
        }
        if (is_null($telefone) || (is_array($telefone) && empty($telefone))) {
            unset($this->Telefone);
        } else {
            $this->Telefone = $telefone;
        }
        return $this;
    }
    /**
     * Get Telemovel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelemovel()
    {
        return isset($this->Telemovel) ? $this->Telemovel : null;
    }
    /**
     * Set Telemovel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telemovel
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setTelemovel($telemovel = null)
    {
        // validation for constraint: string
        if (!is_null($telemovel) && !is_string($telemovel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telemovel)), __LINE__);
        }
        if (is_null($telemovel) || (is_array($telemovel) && empty($telemovel))) {
            unset($this->Telemovel);
        } else {
            $this->Telemovel = $telemovel;
        }
        return $this;
    }
    /**
     * Get TipoContacto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoContacto()
    {
        return isset($this->TipoContacto) ? $this->TipoContacto : null;
    }
    /**
     * Set TipoContacto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoContacto
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setTipoContacto($tipoContacto = null)
    {
        // validation for constraint: string
        if (!is_null($tipoContacto) && !is_string($tipoContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoContacto)), __LINE__);
        }
        if (is_null($tipoContacto) || (is_array($tipoContacto) && empty($tipoContacto))) {
            unset($this->TipoContacto);
        } else {
            $this->TipoContacto = $tipoContacto;
        }
        return $this;
    }
    /**
     * Get TipoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidade()
    {
        return isset($this->TipoEntidade) ? $this->TipoEntidade : null;
    }
    /**
     * Set TipoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidade
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setTipoEntidade($tipoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidade) && !is_string($tipoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidade)), __LINE__);
        }
        if (is_null($tipoEntidade) || (is_array($tipoEntidade) && empty($tipoEntidade))) {
            unset($this->TipoEntidade);
        } else {
            $this->TipoEntidade = $tipoEntidade;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasContactoEntidadesERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
