<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasComprasERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasComprasERP
 * @subpackage Structs
 */
class LinhasComprasERP extends AbstractStructBase
{
    /**
     * The AcertoIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AcertoIVA;
    /**
     * The AnaliticaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnaliticaCBL;
    /**
     * The Armazem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Armazem;
    /**
     * The Arred
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Arred;
    /**
     * The Artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Artigo;
    /**
     * The AutoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AutoID;
    /**
     * The B2BNumLinhaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $B2BNumLinhaOrig;
    /**
     * The BaseCalculoIncidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseCalculoIncidencia;
    /**
     * The BaseIncidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseIncidencia;
    /**
     * The CCustoCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCustoCBL;
    /**
     * The CDU_FactorConversaoAlternativa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CDU_FactorConversaoAlternativa;
    /**
     * The CDU_QuantidadeAlternativa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CDU_QuantidadeAlternativa;
    /**
     * The CDU_UnidadeAlternativa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_UnidadeAlternativa;
    /**
     * The CambioDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioDocOrig;
    /**
     * The CambioMAltDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMAltDocOrig;
    /**
     * The CambioMBaseDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMBaseDocOrig;
    /**
     * The CategoriaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CategoriaID;
    /**
     * The ClasseID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClasseID;
    /**
     * The CodIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIva;
    /**
     * The CodIvaEcotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIvaEcotaxa;
    /**
     * The CodIvaIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIvaIEC;
    /**
     * The CodigoPautal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoPautal;
    /**
     * The Conferido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Conferido;
    /**
     * The ContaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCBL;
    /**
     * The ContaOrcamCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaOrcamCBL;
    /**
     * The ContratoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContratoID;
    /**
     * The CustoAdicionalManual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CustoAdicionalManual;
    /**
     * The CustoAdicionalRateio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CustoAdicionalRateio;
    /**
     * The DataDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDoc;
    /**
     * The DataEntrada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataEntrada;
    /**
     * The DataEntrega
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataEntrega;
    /**
     * The DescValor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DescValor;
    /**
     * The Desconto1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Desconto1;
    /**
     * The Desconto2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Desconto2;
    /**
     * The Desconto3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Desconto3;
    /**
     * The DescontoComercial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DescontoComercial;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The DifArredondamentoMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamentoMAlt;
    /**
     * The DifArredondamentoMBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamentoMBase;
    /**
     * The DifCambioMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifCambioMAlt;
    /**
     * The DifCambioMBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifCambioMBase;
    /**
     * The DifDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifDesc;
    /**
     * The DifIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifIVA;
    /**
     * The DifPreco
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifPreco;
    /**
     * The Ecotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Ecotaxa;
    /**
     * The EstadoAdi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoAdi;
    /**
     * The EstadoPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoPendente;
    /**
     * The FactorConv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FactorConv;
    /**
     * The Formula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Formula;
    /**
     * The FuncionalCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FuncionalCBL;
    /**
     * The IDB2BLinhaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDB2BLinhaOrig;
    /**
     * The IDLinhaEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDLinhaEstorno;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdCabecCompras
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCabecCompras;
    /**
     * The IdHistorico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdHistorico;
    /**
     * The IdLinhaOrigemCopia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhaOrigemCopia;
    /**
     * The IdLinhaPai
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhaPai;
    /**
     * The IdLinhaReqInterna
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhaReqInterna;
    /**
     * The IntrastatMassaLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IntrastatMassaLiq;
    /**
     * The IntrastatPaisOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntrastatPaisOrigem;
    /**
     * The IntrastatPautal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntrastatPautal;
    /**
     * The IntrastatRegiao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntrastatRegiao;
    /**
     * The IntrastatValorLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IntrastatValorLiq;
    /**
     * The IsentoPagDireitos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsentoPagDireitos;
    /**
     * The ItemCod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemCod;
    /**
     * The ItemDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDesc;
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The IvaNaoDedutivel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IvaNaoDedutivel;
    /**
     * The IvaRegraCalculo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IvaRegraCalculo;
    /**
     * The IvaValorDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IvaValorDesconto;
    /**
     * The LinhasEstados
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLinhasComprasStatusERP
     */
    public $LinhasEstados;
    /**
     * The LinhasTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLinhasComprasTransERP
     */
    public $LinhasTrans;
    /**
     * The Localizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localizacao;
    /**
     * The Lote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lote;
    /**
     * The ModuloOrigemCopia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModuloOrigemCopia;
    /**
     * The MoedaDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MoedaDocOrig;
    /**
     * The MotivoEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoEstorno;
    /**
     * The MovSTK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovSTK;
    /**
     * The NumDocExterno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumDocExterno;
    /**
     * The NumLinha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumLinha;
    /**
     * The NumLinhaSTKGerada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumLinhaSTKGerada;
    /**
     * The ObraID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObraID;
    /**
     * The OrganicaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganicaCBL;
    /**
     * The PercIncidenciaIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PercIncidenciaIVA;
    /**
     * The PercIvaDedutivel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercIvaDedutivel;
    /**
     * The PrecUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PrecUnit;
    /**
     * The PrecoLiquido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PrecoLiquido;
    /**
     * The ProcessoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessoID;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QntFormula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QntFormula;
    /**
     * The Quantidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantidade;
    /**
     * The RegimeIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegimeIva;
    /**
     * The RegraCalculoIncidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegraCalculoIncidencia;
    /**
     * The SubEmpID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubEmpID;
    /**
     * The SujeitoRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SujeitoRetencao;
    /**
     * The TaxaIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaIva;
    /**
     * The TaxaIvaEcotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaIvaEcotaxa;
    /**
     * The TaxaIvaIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaIvaIEC;
    /**
     * The TaxaProRata
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxaProRata;
    /**
     * The TaxaRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaRecargo;
    /**
     * The TipoAuto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoAuto;
    /**
     * The TipoLinha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoLinha;
    /**
     * The TipoOperacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoOperacao;
    /**
     * The TotalDA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDA;
    /**
     * The TotalDC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDC;
    /**
     * The TotalDF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDF;
    /**
     * The TotalEcotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalEcotaxa;
    /**
     * The TotalIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIEC;
    /**
     * The TotalIliquido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIliquido;
    /**
     * The TotalIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIva;
    /**
     * The TotalRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalRecargo;
    /**
     * The Unidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Unidade;
    /**
     * The ValorIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorIEC;
    /**
     * The ValorLiquidoDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorLiquidoDesconto;
    /**
     * The VariavelA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VariavelA;
    /**
     * The VariavelB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VariavelB;
    /**
     * The VariavelC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VariavelC;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * The WBSItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBSItem;
    /**
     * Constructor method for LinhasComprasERP
     * @uses LinhasComprasERP::setAcertoIVA()
     * @uses LinhasComprasERP::setAnaliticaCBL()
     * @uses LinhasComprasERP::setArmazem()
     * @uses LinhasComprasERP::setArred()
     * @uses LinhasComprasERP::setArtigo()
     * @uses LinhasComprasERP::setAutoID()
     * @uses LinhasComprasERP::setB2BNumLinhaOrig()
     * @uses LinhasComprasERP::setBaseCalculoIncidencia()
     * @uses LinhasComprasERP::setBaseIncidencia()
     * @uses LinhasComprasERP::setCCustoCBL()
     * @uses LinhasComprasERP::setCDU_FactorConversaoAlternativa()
     * @uses LinhasComprasERP::setCDU_QuantidadeAlternativa()
     * @uses LinhasComprasERP::setCDU_UnidadeAlternativa()
     * @uses LinhasComprasERP::setCambioDocOrig()
     * @uses LinhasComprasERP::setCambioMAltDocOrig()
     * @uses LinhasComprasERP::setCambioMBaseDocOrig()
     * @uses LinhasComprasERP::setCategoriaID()
     * @uses LinhasComprasERP::setClasseID()
     * @uses LinhasComprasERP::setCodIva()
     * @uses LinhasComprasERP::setCodIvaEcotaxa()
     * @uses LinhasComprasERP::setCodIvaIEC()
     * @uses LinhasComprasERP::setCodigoPautal()
     * @uses LinhasComprasERP::setConferido()
     * @uses LinhasComprasERP::setContaCBL()
     * @uses LinhasComprasERP::setContaOrcamCBL()
     * @uses LinhasComprasERP::setContratoID()
     * @uses LinhasComprasERP::setCustoAdicionalManual()
     * @uses LinhasComprasERP::setCustoAdicionalRateio()
     * @uses LinhasComprasERP::setDataDoc()
     * @uses LinhasComprasERP::setDataEntrada()
     * @uses LinhasComprasERP::setDataEntrega()
     * @uses LinhasComprasERP::setDescValor()
     * @uses LinhasComprasERP::setDesconto1()
     * @uses LinhasComprasERP::setDesconto2()
     * @uses LinhasComprasERP::setDesconto3()
     * @uses LinhasComprasERP::setDescontoComercial()
     * @uses LinhasComprasERP::setDescricao()
     * @uses LinhasComprasERP::setDifArredondamentoMAlt()
     * @uses LinhasComprasERP::setDifArredondamentoMBase()
     * @uses LinhasComprasERP::setDifCambioMAlt()
     * @uses LinhasComprasERP::setDifCambioMBase()
     * @uses LinhasComprasERP::setDifDesc()
     * @uses LinhasComprasERP::setDifIVA()
     * @uses LinhasComprasERP::setDifPreco()
     * @uses LinhasComprasERP::setEcotaxa()
     * @uses LinhasComprasERP::setEstadoAdi()
     * @uses LinhasComprasERP::setEstadoPendente()
     * @uses LinhasComprasERP::setFactorConv()
     * @uses LinhasComprasERP::setFormula()
     * @uses LinhasComprasERP::setFuncionalCBL()
     * @uses LinhasComprasERP::setIDB2BLinhaOrig()
     * @uses LinhasComprasERP::setIDLinhaEstorno()
     * @uses LinhasComprasERP::setId()
     * @uses LinhasComprasERP::setIdCabecCompras()
     * @uses LinhasComprasERP::setIdHistorico()
     * @uses LinhasComprasERP::setIdLinhaOrigemCopia()
     * @uses LinhasComprasERP::setIdLinhaPai()
     * @uses LinhasComprasERP::setIdLinhaReqInterna()
     * @uses LinhasComprasERP::setIntrastatMassaLiq()
     * @uses LinhasComprasERP::setIntrastatPaisOrigem()
     * @uses LinhasComprasERP::setIntrastatPautal()
     * @uses LinhasComprasERP::setIntrastatRegiao()
     * @uses LinhasComprasERP::setIntrastatValorLiq()
     * @uses LinhasComprasERP::setIsentoPagDireitos()
     * @uses LinhasComprasERP::setItemCod()
     * @uses LinhasComprasERP::setItemDesc()
     * @uses LinhasComprasERP::setItemId()
     * @uses LinhasComprasERP::setIvaNaoDedutivel()
     * @uses LinhasComprasERP::setIvaRegraCalculo()
     * @uses LinhasComprasERP::setIvaValorDesconto()
     * @uses LinhasComprasERP::setLinhasEstados()
     * @uses LinhasComprasERP::setLinhasTrans()
     * @uses LinhasComprasERP::setLocalizacao()
     * @uses LinhasComprasERP::setLote()
     * @uses LinhasComprasERP::setModuloOrigemCopia()
     * @uses LinhasComprasERP::setMoedaDocOrig()
     * @uses LinhasComprasERP::setMotivoEstorno()
     * @uses LinhasComprasERP::setMovSTK()
     * @uses LinhasComprasERP::setNumDocExterno()
     * @uses LinhasComprasERP::setNumLinha()
     * @uses LinhasComprasERP::setNumLinhaSTKGerada()
     * @uses LinhasComprasERP::setObraID()
     * @uses LinhasComprasERP::setOrganicaCBL()
     * @uses LinhasComprasERP::setPercIncidenciaIVA()
     * @uses LinhasComprasERP::setPercIvaDedutivel()
     * @uses LinhasComprasERP::setPrecUnit()
     * @uses LinhasComprasERP::setPrecoLiquido()
     * @uses LinhasComprasERP::setProcessoID()
     * @uses LinhasComprasERP::setProtegida()
     * @uses LinhasComprasERP::setQntFormula()
     * @uses LinhasComprasERP::setQuantidade()
     * @uses LinhasComprasERP::setRegimeIva()
     * @uses LinhasComprasERP::setRegraCalculoIncidencia()
     * @uses LinhasComprasERP::setSubEmpID()
     * @uses LinhasComprasERP::setSujeitoRetencao()
     * @uses LinhasComprasERP::setTaxaIva()
     * @uses LinhasComprasERP::setTaxaIvaEcotaxa()
     * @uses LinhasComprasERP::setTaxaIvaIEC()
     * @uses LinhasComprasERP::setTaxaProRata()
     * @uses LinhasComprasERP::setTaxaRecargo()
     * @uses LinhasComprasERP::setTipoAuto()
     * @uses LinhasComprasERP::setTipoLinha()
     * @uses LinhasComprasERP::setTipoOperacao()
     * @uses LinhasComprasERP::setTotalDA()
     * @uses LinhasComprasERP::setTotalDC()
     * @uses LinhasComprasERP::setTotalDF()
     * @uses LinhasComprasERP::setTotalEcotaxa()
     * @uses LinhasComprasERP::setTotalIEC()
     * @uses LinhasComprasERP::setTotalIliquido()
     * @uses LinhasComprasERP::setTotalIva()
     * @uses LinhasComprasERP::setTotalRecargo()
     * @uses LinhasComprasERP::setUnidade()
     * @uses LinhasComprasERP::setValorIEC()
     * @uses LinhasComprasERP::setValorLiquidoDesconto()
     * @uses LinhasComprasERP::setVariavelA()
     * @uses LinhasComprasERP::setVariavelB()
     * @uses LinhasComprasERP::setVariavelC()
     * @uses LinhasComprasERP::setVersaoUltAct()
     * @uses LinhasComprasERP::setWBSItem()
     * @param float $acertoIVA
     * @param string $analiticaCBL
     * @param string $armazem
     * @param int $arred
     * @param string $artigo
     * @param string $autoID
     * @param int $b2BNumLinhaOrig
     * @param float $baseCalculoIncidencia
     * @param float $baseIncidencia
     * @param string $cCustoCBL
     * @param float $cDU_FactorConversaoAlternativa
     * @param float $cDU_QuantidadeAlternativa
     * @param string $cDU_UnidadeAlternativa
     * @param float $cambioDocOrig
     * @param float $cambioMAltDocOrig
     * @param float $cambioMBaseDocOrig
     * @param int $categoriaID
     * @param int $classeID
     * @param string $codIva
     * @param string $codIvaEcotaxa
     * @param string $codIvaIEC
     * @param string $codigoPautal
     * @param bool $conferido
     * @param string $contaCBL
     * @param string $contaOrcamCBL
     * @param string $contratoID
     * @param float $custoAdicionalManual
     * @param float $custoAdicionalRateio
     * @param string $dataDoc
     * @param string $dataEntrada
     * @param string $dataEntrega
     * @param float $descValor
     * @param float $desconto1
     * @param float $desconto2
     * @param float $desconto3
     * @param float $descontoComercial
     * @param string $descricao
     * @param float $difArredondamentoMAlt
     * @param float $difArredondamentoMBase
     * @param float $difCambioMAlt
     * @param float $difCambioMBase
     * @param float $difDesc
     * @param float $difIVA
     * @param float $difPreco
     * @param float $ecotaxa
     * @param string $estadoAdi
     * @param string $estadoPendente
     * @param float $factorConv
     * @param string $formula
     * @param string $funcionalCBL
     * @param string $iDB2BLinhaOrig
     * @param string $iDLinhaEstorno
     * @param string $id
     * @param string $idCabecCompras
     * @param string $idHistorico
     * @param string $idLinhaOrigemCopia
     * @param string $idLinhaPai
     * @param string $idLinhaReqInterna
     * @param float $intrastatMassaLiq
     * @param string $intrastatPaisOrigem
     * @param string $intrastatPautal
     * @param string $intrastatRegiao
     * @param float $intrastatValorLiq
     * @param bool $isentoPagDireitos
     * @param string $itemCod
     * @param string $itemDesc
     * @param int $itemId
     * @param float $ivaNaoDedutivel
     * @param int $ivaRegraCalculo
     * @param float $ivaValorDesconto
     * @param \ArrayType\ArrayOfLinhasComprasStatusERP $linhasEstados
     * @param \ArrayType\ArrayOfLinhasComprasTransERP $linhasTrans
     * @param string $localizacao
     * @param string $lote
     * @param string $moduloOrigemCopia
     * @param string $moedaDocOrig
     * @param string $motivoEstorno
     * @param string $movSTK
     * @param string $numDocExterno
     * @param int $numLinha
     * @param int $numLinhaSTKGerada
     * @param string $obraID
     * @param string $organicaCBL
     * @param float $percIncidenciaIVA
     * @param float $percIvaDedutivel
     * @param float $precUnit
     * @param float $precoLiquido
     * @param string $processoID
     * @param bool $protegida
     * @param float $qntFormula
     * @param float $quantidade
     * @param string $regimeIva
     * @param string $regraCalculoIncidencia
     * @param int $subEmpID
     * @param bool $sujeitoRetencao
     * @param float $taxaIva
     * @param float $taxaIvaEcotaxa
     * @param float $taxaIvaIEC
     * @param float $taxaProRata
     * @param float $taxaRecargo
     * @param string $tipoAuto
     * @param string $tipoLinha
     * @param string $tipoOperacao
     * @param float $totalDA
     * @param float $totalDC
     * @param float $totalDF
     * @param float $totalEcotaxa
     * @param float $totalIEC
     * @param float $totalIliquido
     * @param float $totalIva
     * @param float $totalRecargo
     * @param string $unidade
     * @param float $valorIEC
     * @param float $valorLiquidoDesconto
     * @param float $variavelA
     * @param float $variavelB
     * @param float $variavelC
     * @param string $versaoUltAct
     * @param string $wBSItem
     */
    public function __construct($acertoIVA = null, $analiticaCBL = null, $armazem = null, $arred = null, $artigo = null, $autoID = null, $b2BNumLinhaOrig = null, $baseCalculoIncidencia = null, $baseIncidencia = null, $cCustoCBL = null, $cDU_FactorConversaoAlternativa = null, $cDU_QuantidadeAlternativa = null, $cDU_UnidadeAlternativa = null, $cambioDocOrig = null, $cambioMAltDocOrig = null, $cambioMBaseDocOrig = null, $categoriaID = null, $classeID = null, $codIva = null, $codIvaEcotaxa = null, $codIvaIEC = null, $codigoPautal = null, $conferido = null, $contaCBL = null, $contaOrcamCBL = null, $contratoID = null, $custoAdicionalManual = null, $custoAdicionalRateio = null, $dataDoc = null, $dataEntrada = null, $dataEntrega = null, $descValor = null, $desconto1 = null, $desconto2 = null, $desconto3 = null, $descontoComercial = null, $descricao = null, $difArredondamentoMAlt = null, $difArredondamentoMBase = null, $difCambioMAlt = null, $difCambioMBase = null, $difDesc = null, $difIVA = null, $difPreco = null, $ecotaxa = null, $estadoAdi = null, $estadoPendente = null, $factorConv = null, $formula = null, $funcionalCBL = null, $iDB2BLinhaOrig = null, $iDLinhaEstorno = null, $id = null, $idCabecCompras = null, $idHistorico = null, $idLinhaOrigemCopia = null, $idLinhaPai = null, $idLinhaReqInterna = null, $intrastatMassaLiq = null, $intrastatPaisOrigem = null, $intrastatPautal = null, $intrastatRegiao = null, $intrastatValorLiq = null, $isentoPagDireitos = null, $itemCod = null, $itemDesc = null, $itemId = null, $ivaNaoDedutivel = null, $ivaRegraCalculo = null, $ivaValorDesconto = null, \ArrayType\ArrayOfLinhasComprasStatusERP $linhasEstados = null, \ArrayType\ArrayOfLinhasComprasTransERP $linhasTrans = null, $localizacao = null, $lote = null, $moduloOrigemCopia = null, $moedaDocOrig = null, $motivoEstorno = null, $movSTK = null, $numDocExterno = null, $numLinha = null, $numLinhaSTKGerada = null, $obraID = null, $organicaCBL = null, $percIncidenciaIVA = null, $percIvaDedutivel = null, $precUnit = null, $precoLiquido = null, $processoID = null, $protegida = null, $qntFormula = null, $quantidade = null, $regimeIva = null, $regraCalculoIncidencia = null, $subEmpID = null, $sujeitoRetencao = null, $taxaIva = null, $taxaIvaEcotaxa = null, $taxaIvaIEC = null, $taxaProRata = null, $taxaRecargo = null, $tipoAuto = null, $tipoLinha = null, $tipoOperacao = null, $totalDA = null, $totalDC = null, $totalDF = null, $totalEcotaxa = null, $totalIEC = null, $totalIliquido = null, $totalIva = null, $totalRecargo = null, $unidade = null, $valorIEC = null, $valorLiquidoDesconto = null, $variavelA = null, $variavelB = null, $variavelC = null, $versaoUltAct = null, $wBSItem = null)
    {
        $this
            ->setAcertoIVA($acertoIVA)
            ->setAnaliticaCBL($analiticaCBL)
            ->setArmazem($armazem)
            ->setArred($arred)
            ->setArtigo($artigo)
            ->setAutoID($autoID)
            ->setB2BNumLinhaOrig($b2BNumLinhaOrig)
            ->setBaseCalculoIncidencia($baseCalculoIncidencia)
            ->setBaseIncidencia($baseIncidencia)
            ->setCCustoCBL($cCustoCBL)
            ->setCDU_FactorConversaoAlternativa($cDU_FactorConversaoAlternativa)
            ->setCDU_QuantidadeAlternativa($cDU_QuantidadeAlternativa)
            ->setCDU_UnidadeAlternativa($cDU_UnidadeAlternativa)
            ->setCambioDocOrig($cambioDocOrig)
            ->setCambioMAltDocOrig($cambioMAltDocOrig)
            ->setCambioMBaseDocOrig($cambioMBaseDocOrig)
            ->setCategoriaID($categoriaID)
            ->setClasseID($classeID)
            ->setCodIva($codIva)
            ->setCodIvaEcotaxa($codIvaEcotaxa)
            ->setCodIvaIEC($codIvaIEC)
            ->setCodigoPautal($codigoPautal)
            ->setConferido($conferido)
            ->setContaCBL($contaCBL)
            ->setContaOrcamCBL($contaOrcamCBL)
            ->setContratoID($contratoID)
            ->setCustoAdicionalManual($custoAdicionalManual)
            ->setCustoAdicionalRateio($custoAdicionalRateio)
            ->setDataDoc($dataDoc)
            ->setDataEntrada($dataEntrada)
            ->setDataEntrega($dataEntrega)
            ->setDescValor($descValor)
            ->setDesconto1($desconto1)
            ->setDesconto2($desconto2)
            ->setDesconto3($desconto3)
            ->setDescontoComercial($descontoComercial)
            ->setDescricao($descricao)
            ->setDifArredondamentoMAlt($difArredondamentoMAlt)
            ->setDifArredondamentoMBase($difArredondamentoMBase)
            ->setDifCambioMAlt($difCambioMAlt)
            ->setDifCambioMBase($difCambioMBase)
            ->setDifDesc($difDesc)
            ->setDifIVA($difIVA)
            ->setDifPreco($difPreco)
            ->setEcotaxa($ecotaxa)
            ->setEstadoAdi($estadoAdi)
            ->setEstadoPendente($estadoPendente)
            ->setFactorConv($factorConv)
            ->setFormula($formula)
            ->setFuncionalCBL($funcionalCBL)
            ->setIDB2BLinhaOrig($iDB2BLinhaOrig)
            ->setIDLinhaEstorno($iDLinhaEstorno)
            ->setId($id)
            ->setIdCabecCompras($idCabecCompras)
            ->setIdHistorico($idHistorico)
            ->setIdLinhaOrigemCopia($idLinhaOrigemCopia)
            ->setIdLinhaPai($idLinhaPai)
            ->setIdLinhaReqInterna($idLinhaReqInterna)
            ->setIntrastatMassaLiq($intrastatMassaLiq)
            ->setIntrastatPaisOrigem($intrastatPaisOrigem)
            ->setIntrastatPautal($intrastatPautal)
            ->setIntrastatRegiao($intrastatRegiao)
            ->setIntrastatValorLiq($intrastatValorLiq)
            ->setIsentoPagDireitos($isentoPagDireitos)
            ->setItemCod($itemCod)
            ->setItemDesc($itemDesc)
            ->setItemId($itemId)
            ->setIvaNaoDedutivel($ivaNaoDedutivel)
            ->setIvaRegraCalculo($ivaRegraCalculo)
            ->setIvaValorDesconto($ivaValorDesconto)
            ->setLinhasEstados($linhasEstados)
            ->setLinhasTrans($linhasTrans)
            ->setLocalizacao($localizacao)
            ->setLote($lote)
            ->setModuloOrigemCopia($moduloOrigemCopia)
            ->setMoedaDocOrig($moedaDocOrig)
            ->setMotivoEstorno($motivoEstorno)
            ->setMovSTK($movSTK)
            ->setNumDocExterno($numDocExterno)
            ->setNumLinha($numLinha)
            ->setNumLinhaSTKGerada($numLinhaSTKGerada)
            ->setObraID($obraID)
            ->setOrganicaCBL($organicaCBL)
            ->setPercIncidenciaIVA($percIncidenciaIVA)
            ->setPercIvaDedutivel($percIvaDedutivel)
            ->setPrecUnit($precUnit)
            ->setPrecoLiquido($precoLiquido)
            ->setProcessoID($processoID)
            ->setProtegida($protegida)
            ->setQntFormula($qntFormula)
            ->setQuantidade($quantidade)
            ->setRegimeIva($regimeIva)
            ->setRegraCalculoIncidencia($regraCalculoIncidencia)
            ->setSubEmpID($subEmpID)
            ->setSujeitoRetencao($sujeitoRetencao)
            ->setTaxaIva($taxaIva)
            ->setTaxaIvaEcotaxa($taxaIvaEcotaxa)
            ->setTaxaIvaIEC($taxaIvaIEC)
            ->setTaxaProRata($taxaProRata)
            ->setTaxaRecargo($taxaRecargo)
            ->setTipoAuto($tipoAuto)
            ->setTipoLinha($tipoLinha)
            ->setTipoOperacao($tipoOperacao)
            ->setTotalDA($totalDA)
            ->setTotalDC($totalDC)
            ->setTotalDF($totalDF)
            ->setTotalEcotaxa($totalEcotaxa)
            ->setTotalIEC($totalIEC)
            ->setTotalIliquido($totalIliquido)
            ->setTotalIva($totalIva)
            ->setTotalRecargo($totalRecargo)
            ->setUnidade($unidade)
            ->setValorIEC($valorIEC)
            ->setValorLiquidoDesconto($valorLiquidoDesconto)
            ->setVariavelA($variavelA)
            ->setVariavelB($variavelB)
            ->setVariavelC($variavelC)
            ->setVersaoUltAct($versaoUltAct)
            ->setWBSItem($wBSItem);
    }
    /**
     * Get AcertoIVA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAcertoIVA()
    {
        return isset($this->AcertoIVA) ? $this->AcertoIVA : null;
    }
    /**
     * Set AcertoIVA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $acertoIVA
     * @return \StructType\LinhasComprasERP
     */
    public function setAcertoIVA($acertoIVA = null)
    {
        if (is_null($acertoIVA) || (is_array($acertoIVA) && empty($acertoIVA))) {
            unset($this->AcertoIVA);
        } else {
            $this->AcertoIVA = $acertoIVA;
        }
        return $this;
    }
    /**
     * Get AnaliticaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnaliticaCBL()
    {
        return isset($this->AnaliticaCBL) ? $this->AnaliticaCBL : null;
    }
    /**
     * Set AnaliticaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $analiticaCBL
     * @return \StructType\LinhasComprasERP
     */
    public function setAnaliticaCBL($analiticaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($analiticaCBL) && !is_string($analiticaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($analiticaCBL)), __LINE__);
        }
        if (is_null($analiticaCBL) || (is_array($analiticaCBL) && empty($analiticaCBL))) {
            unset($this->AnaliticaCBL);
        } else {
            $this->AnaliticaCBL = $analiticaCBL;
        }
        return $this;
    }
    /**
     * Get Armazem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArmazem()
    {
        return isset($this->Armazem) ? $this->Armazem : null;
    }
    /**
     * Set Armazem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $armazem
     * @return \StructType\LinhasComprasERP
     */
    public function setArmazem($armazem = null)
    {
        // validation for constraint: string
        if (!is_null($armazem) && !is_string($armazem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($armazem)), __LINE__);
        }
        if (is_null($armazem) || (is_array($armazem) && empty($armazem))) {
            unset($this->Armazem);
        } else {
            $this->Armazem = $armazem;
        }
        return $this;
    }
    /**
     * Get Arred value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArred()
    {
        return isset($this->Arred) ? $this->Arred : null;
    }
    /**
     * Set Arred value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $arred
     * @return \StructType\LinhasComprasERP
     */
    public function setArred($arred = null)
    {
        // validation for constraint: int
        if (!is_null($arred) && !is_numeric($arred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($arred)), __LINE__);
        }
        if (is_null($arred) || (is_array($arred) && empty($arred))) {
            unset($this->Arred);
        } else {
            $this->Arred = $arred;
        }
        return $this;
    }
    /**
     * Get Artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->Artigo) ? $this->Artigo : null;
    }
    /**
     * Set Artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\LinhasComprasERP
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->Artigo);
        } else {
            $this->Artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get AutoID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutoID()
    {
        return isset($this->AutoID) ? $this->AutoID : null;
    }
    /**
     * Set AutoID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $autoID
     * @return \StructType\LinhasComprasERP
     */
    public function setAutoID($autoID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($autoID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $autoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($autoID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($autoID) && !is_string($autoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoID)), __LINE__);
        }
        if (is_null($autoID) || (is_array($autoID) && empty($autoID))) {
            unset($this->AutoID);
        } else {
            $this->AutoID = $autoID;
        }
        return $this;
    }
    /**
     * Get B2BNumLinhaOrig value
     * @return int|null
     */
    public function getB2BNumLinhaOrig()
    {
        return $this->B2BNumLinhaOrig;
    }
    /**
     * Set B2BNumLinhaOrig value
     * @param int $b2BNumLinhaOrig
     * @return \StructType\LinhasComprasERP
     */
    public function setB2BNumLinhaOrig($b2BNumLinhaOrig = null)
    {
        // validation for constraint: int
        if (!is_null($b2BNumLinhaOrig) && !is_numeric($b2BNumLinhaOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($b2BNumLinhaOrig)), __LINE__);
        }
        $this->B2BNumLinhaOrig = $b2BNumLinhaOrig;
        return $this;
    }
    /**
     * Get BaseCalculoIncidencia value
     * @return float|null
     */
    public function getBaseCalculoIncidencia()
    {
        return $this->BaseCalculoIncidencia;
    }
    /**
     * Set BaseCalculoIncidencia value
     * @param float $baseCalculoIncidencia
     * @return \StructType\LinhasComprasERP
     */
    public function setBaseCalculoIncidencia($baseCalculoIncidencia = null)
    {
        $this->BaseCalculoIncidencia = $baseCalculoIncidencia;
        return $this;
    }
    /**
     * Get BaseIncidencia value
     * @return float|null
     */
    public function getBaseIncidencia()
    {
        return $this->BaseIncidencia;
    }
    /**
     * Set BaseIncidencia value
     * @param float $baseIncidencia
     * @return \StructType\LinhasComprasERP
     */
    public function setBaseIncidencia($baseIncidencia = null)
    {
        $this->BaseIncidencia = $baseIncidencia;
        return $this;
    }
    /**
     * Get CCustoCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCustoCBL()
    {
        return isset($this->CCustoCBL) ? $this->CCustoCBL : null;
    }
    /**
     * Set CCustoCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCustoCBL
     * @return \StructType\LinhasComprasERP
     */
    public function setCCustoCBL($cCustoCBL = null)
    {
        // validation for constraint: string
        if (!is_null($cCustoCBL) && !is_string($cCustoCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCustoCBL)), __LINE__);
        }
        if (is_null($cCustoCBL) || (is_array($cCustoCBL) && empty($cCustoCBL))) {
            unset($this->CCustoCBL);
        } else {
            $this->CCustoCBL = $cCustoCBL;
        }
        return $this;
    }
    /**
     * Get CDU_FactorConversaoAlternativa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCDU_FactorConversaoAlternativa()
    {
        return isset($this->CDU_FactorConversaoAlternativa) ? $this->CDU_FactorConversaoAlternativa : null;
    }
    /**
     * Set CDU_FactorConversaoAlternativa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cDU_FactorConversaoAlternativa
     * @return \StructType\LinhasComprasERP
     */
    public function setCDU_FactorConversaoAlternativa($cDU_FactorConversaoAlternativa = null)
    {
        if (is_null($cDU_FactorConversaoAlternativa) || (is_array($cDU_FactorConversaoAlternativa) && empty($cDU_FactorConversaoAlternativa))) {
            unset($this->CDU_FactorConversaoAlternativa);
        } else {
            $this->CDU_FactorConversaoAlternativa = $cDU_FactorConversaoAlternativa;
        }
        return $this;
    }
    /**
     * Get CDU_QuantidadeAlternativa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCDU_QuantidadeAlternativa()
    {
        return isset($this->CDU_QuantidadeAlternativa) ? $this->CDU_QuantidadeAlternativa : null;
    }
    /**
     * Set CDU_QuantidadeAlternativa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cDU_QuantidadeAlternativa
     * @return \StructType\LinhasComprasERP
     */
    public function setCDU_QuantidadeAlternativa($cDU_QuantidadeAlternativa = null)
    {
        if (is_null($cDU_QuantidadeAlternativa) || (is_array($cDU_QuantidadeAlternativa) && empty($cDU_QuantidadeAlternativa))) {
            unset($this->CDU_QuantidadeAlternativa);
        } else {
            $this->CDU_QuantidadeAlternativa = $cDU_QuantidadeAlternativa;
        }
        return $this;
    }
    /**
     * Get CDU_UnidadeAlternativa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_UnidadeAlternativa()
    {
        return isset($this->CDU_UnidadeAlternativa) ? $this->CDU_UnidadeAlternativa : null;
    }
    /**
     * Set CDU_UnidadeAlternativa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_UnidadeAlternativa
     * @return \StructType\LinhasComprasERP
     */
    public function setCDU_UnidadeAlternativa($cDU_UnidadeAlternativa = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_UnidadeAlternativa) && !is_string($cDU_UnidadeAlternativa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_UnidadeAlternativa)), __LINE__);
        }
        if (is_null($cDU_UnidadeAlternativa) || (is_array($cDU_UnidadeAlternativa) && empty($cDU_UnidadeAlternativa))) {
            unset($this->CDU_UnidadeAlternativa);
        } else {
            $this->CDU_UnidadeAlternativa = $cDU_UnidadeAlternativa;
        }
        return $this;
    }
    /**
     * Get CambioDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioDocOrig()
    {
        return isset($this->CambioDocOrig) ? $this->CambioDocOrig : null;
    }
    /**
     * Set CambioDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioDocOrig
     * @return \StructType\LinhasComprasERP
     */
    public function setCambioDocOrig($cambioDocOrig = null)
    {
        if (is_null($cambioDocOrig) || (is_array($cambioDocOrig) && empty($cambioDocOrig))) {
            unset($this->CambioDocOrig);
        } else {
            $this->CambioDocOrig = $cambioDocOrig;
        }
        return $this;
    }
    /**
     * Get CambioMAltDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMAltDocOrig()
    {
        return isset($this->CambioMAltDocOrig) ? $this->CambioMAltDocOrig : null;
    }
    /**
     * Set CambioMAltDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMAltDocOrig
     * @return \StructType\LinhasComprasERP
     */
    public function setCambioMAltDocOrig($cambioMAltDocOrig = null)
    {
        if (is_null($cambioMAltDocOrig) || (is_array($cambioMAltDocOrig) && empty($cambioMAltDocOrig))) {
            unset($this->CambioMAltDocOrig);
        } else {
            $this->CambioMAltDocOrig = $cambioMAltDocOrig;
        }
        return $this;
    }
    /**
     * Get CambioMBaseDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMBaseDocOrig()
    {
        return isset($this->CambioMBaseDocOrig) ? $this->CambioMBaseDocOrig : null;
    }
    /**
     * Set CambioMBaseDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMBaseDocOrig
     * @return \StructType\LinhasComprasERP
     */
    public function setCambioMBaseDocOrig($cambioMBaseDocOrig = null)
    {
        if (is_null($cambioMBaseDocOrig) || (is_array($cambioMBaseDocOrig) && empty($cambioMBaseDocOrig))) {
            unset($this->CambioMBaseDocOrig);
        } else {
            $this->CambioMBaseDocOrig = $cambioMBaseDocOrig;
        }
        return $this;
    }
    /**
     * Get CategoriaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCategoriaID()
    {
        return isset($this->CategoriaID) ? $this->CategoriaID : null;
    }
    /**
     * Set CategoriaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $categoriaID
     * @return \StructType\LinhasComprasERP
     */
    public function setCategoriaID($categoriaID = null)
    {
        // validation for constraint: int
        if (!is_null($categoriaID) && !is_numeric($categoriaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoriaID)), __LINE__);
        }
        if (is_null($categoriaID) || (is_array($categoriaID) && empty($categoriaID))) {
            unset($this->CategoriaID);
        } else {
            $this->CategoriaID = $categoriaID;
        }
        return $this;
    }
    /**
     * Get ClasseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClasseID()
    {
        return isset($this->ClasseID) ? $this->ClasseID : null;
    }
    /**
     * Set ClasseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $classeID
     * @return \StructType\LinhasComprasERP
     */
    public function setClasseID($classeID = null)
    {
        // validation for constraint: int
        if (!is_null($classeID) && !is_numeric($classeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($classeID)), __LINE__);
        }
        if (is_null($classeID) || (is_array($classeID) && empty($classeID))) {
            unset($this->ClasseID);
        } else {
            $this->ClasseID = $classeID;
        }
        return $this;
    }
    /**
     * Get CodIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIva()
    {
        return isset($this->CodIva) ? $this->CodIva : null;
    }
    /**
     * Set CodIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIva
     * @return \StructType\LinhasComprasERP
     */
    public function setCodIva($codIva = null)
    {
        // validation for constraint: string
        if (!is_null($codIva) && !is_string($codIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIva)), __LINE__);
        }
        if (is_null($codIva) || (is_array($codIva) && empty($codIva))) {
            unset($this->CodIva);
        } else {
            $this->CodIva = $codIva;
        }
        return $this;
    }
    /**
     * Get CodIvaEcotaxa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIvaEcotaxa()
    {
        return isset($this->CodIvaEcotaxa) ? $this->CodIvaEcotaxa : null;
    }
    /**
     * Set CodIvaEcotaxa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIvaEcotaxa
     * @return \StructType\LinhasComprasERP
     */
    public function setCodIvaEcotaxa($codIvaEcotaxa = null)
    {
        // validation for constraint: string
        if (!is_null($codIvaEcotaxa) && !is_string($codIvaEcotaxa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIvaEcotaxa)), __LINE__);
        }
        if (is_null($codIvaEcotaxa) || (is_array($codIvaEcotaxa) && empty($codIvaEcotaxa))) {
            unset($this->CodIvaEcotaxa);
        } else {
            $this->CodIvaEcotaxa = $codIvaEcotaxa;
        }
        return $this;
    }
    /**
     * Get CodIvaIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIvaIEC()
    {
        return isset($this->CodIvaIEC) ? $this->CodIvaIEC : null;
    }
    /**
     * Set CodIvaIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIvaIEC
     * @return \StructType\LinhasComprasERP
     */
    public function setCodIvaIEC($codIvaIEC = null)
    {
        // validation for constraint: string
        if (!is_null($codIvaIEC) && !is_string($codIvaIEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIvaIEC)), __LINE__);
        }
        if (is_null($codIvaIEC) || (is_array($codIvaIEC) && empty($codIvaIEC))) {
            unset($this->CodIvaIEC);
        } else {
            $this->CodIvaIEC = $codIvaIEC;
        }
        return $this;
    }
    /**
     * Get CodigoPautal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoPautal()
    {
        return isset($this->CodigoPautal) ? $this->CodigoPautal : null;
    }
    /**
     * Set CodigoPautal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoPautal
     * @return \StructType\LinhasComprasERP
     */
    public function setCodigoPautal($codigoPautal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPautal) && !is_string($codigoPautal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoPautal)), __LINE__);
        }
        if (is_null($codigoPautal) || (is_array($codigoPautal) && empty($codigoPautal))) {
            unset($this->CodigoPautal);
        } else {
            $this->CodigoPautal = $codigoPautal;
        }
        return $this;
    }
    /**
     * Get Conferido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getConferido()
    {
        return isset($this->Conferido) ? $this->Conferido : null;
    }
    /**
     * Set Conferido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $conferido
     * @return \StructType\LinhasComprasERP
     */
    public function setConferido($conferido = null)
    {
        // validation for constraint: boolean
        if (!is_null($conferido) && !is_bool($conferido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($conferido)), __LINE__);
        }
        if (is_null($conferido) || (is_array($conferido) && empty($conferido))) {
            unset($this->Conferido);
        } else {
            $this->Conferido = $conferido;
        }
        return $this;
    }
    /**
     * Get ContaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCBL()
    {
        return isset($this->ContaCBL) ? $this->ContaCBL : null;
    }
    /**
     * Set ContaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCBL
     * @return \StructType\LinhasComprasERP
     */
    public function setContaCBL($contaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($contaCBL) && !is_string($contaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaCBL)), __LINE__);
        }
        if (is_null($contaCBL) || (is_array($contaCBL) && empty($contaCBL))) {
            unset($this->ContaCBL);
        } else {
            $this->ContaCBL = $contaCBL;
        }
        return $this;
    }
    /**
     * Get ContaOrcamCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaOrcamCBL()
    {
        return isset($this->ContaOrcamCBL) ? $this->ContaOrcamCBL : null;
    }
    /**
     * Set ContaOrcamCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaOrcamCBL
     * @return \StructType\LinhasComprasERP
     */
    public function setContaOrcamCBL($contaOrcamCBL = null)
    {
        // validation for constraint: string
        if (!is_null($contaOrcamCBL) && !is_string($contaOrcamCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaOrcamCBL)), __LINE__);
        }
        if (is_null($contaOrcamCBL) || (is_array($contaOrcamCBL) && empty($contaOrcamCBL))) {
            unset($this->ContaOrcamCBL);
        } else {
            $this->ContaOrcamCBL = $contaOrcamCBL;
        }
        return $this;
    }
    /**
     * Get ContratoID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContratoID()
    {
        return isset($this->ContratoID) ? $this->ContratoID : null;
    }
    /**
     * Set ContratoID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contratoID
     * @return \StructType\LinhasComprasERP
     */
    public function setContratoID($contratoID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($contratoID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contratoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($contratoID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contratoID) && !is_string($contratoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contratoID)), __LINE__);
        }
        if (is_null($contratoID) || (is_array($contratoID) && empty($contratoID))) {
            unset($this->ContratoID);
        } else {
            $this->ContratoID = $contratoID;
        }
        return $this;
    }
    /**
     * Get CustoAdicionalManual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCustoAdicionalManual()
    {
        return isset($this->CustoAdicionalManual) ? $this->CustoAdicionalManual : null;
    }
    /**
     * Set CustoAdicionalManual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $custoAdicionalManual
     * @return \StructType\LinhasComprasERP
     */
    public function setCustoAdicionalManual($custoAdicionalManual = null)
    {
        if (is_null($custoAdicionalManual) || (is_array($custoAdicionalManual) && empty($custoAdicionalManual))) {
            unset($this->CustoAdicionalManual);
        } else {
            $this->CustoAdicionalManual = $custoAdicionalManual;
        }
        return $this;
    }
    /**
     * Get CustoAdicionalRateio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCustoAdicionalRateio()
    {
        return isset($this->CustoAdicionalRateio) ? $this->CustoAdicionalRateio : null;
    }
    /**
     * Set CustoAdicionalRateio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $custoAdicionalRateio
     * @return \StructType\LinhasComprasERP
     */
    public function setCustoAdicionalRateio($custoAdicionalRateio = null)
    {
        if (is_null($custoAdicionalRateio) || (is_array($custoAdicionalRateio) && empty($custoAdicionalRateio))) {
            unset($this->CustoAdicionalRateio);
        } else {
            $this->CustoAdicionalRateio = $custoAdicionalRateio;
        }
        return $this;
    }
    /**
     * Get DataDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDoc()
    {
        return isset($this->DataDoc) ? $this->DataDoc : null;
    }
    /**
     * Set DataDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDoc
     * @return \StructType\LinhasComprasERP
     */
    public function setDataDoc($dataDoc = null)
    {
        // validation for constraint: string
        if (!is_null($dataDoc) && !is_string($dataDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDoc)), __LINE__);
        }
        if (is_null($dataDoc) || (is_array($dataDoc) && empty($dataDoc))) {
            unset($this->DataDoc);
        } else {
            $this->DataDoc = $dataDoc;
        }
        return $this;
    }
    /**
     * Get DataEntrada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataEntrada()
    {
        return isset($this->DataEntrada) ? $this->DataEntrada : null;
    }
    /**
     * Set DataEntrada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataEntrada
     * @return \StructType\LinhasComprasERP
     */
    public function setDataEntrada($dataEntrada = null)
    {
        // validation for constraint: string
        if (!is_null($dataEntrada) && !is_string($dataEntrada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataEntrada)), __LINE__);
        }
        if (is_null($dataEntrada) || (is_array($dataEntrada) && empty($dataEntrada))) {
            unset($this->DataEntrada);
        } else {
            $this->DataEntrada = $dataEntrada;
        }
        return $this;
    }
    /**
     * Get DataEntrega value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataEntrega()
    {
        return isset($this->DataEntrega) ? $this->DataEntrega : null;
    }
    /**
     * Set DataEntrega value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataEntrega
     * @return \StructType\LinhasComprasERP
     */
    public function setDataEntrega($dataEntrega = null)
    {
        // validation for constraint: string
        if (!is_null($dataEntrega) && !is_string($dataEntrega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataEntrega)), __LINE__);
        }
        if (is_null($dataEntrega) || (is_array($dataEntrega) && empty($dataEntrega))) {
            unset($this->DataEntrega);
        } else {
            $this->DataEntrega = $dataEntrega;
        }
        return $this;
    }
    /**
     * Get DescValor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDescValor()
    {
        return isset($this->DescValor) ? $this->DescValor : null;
    }
    /**
     * Set DescValor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $descValor
     * @return \StructType\LinhasComprasERP
     */
    public function setDescValor($descValor = null)
    {
        if (is_null($descValor) || (is_array($descValor) && empty($descValor))) {
            unset($this->DescValor);
        } else {
            $this->DescValor = $descValor;
        }
        return $this;
    }
    /**
     * Get Desconto1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDesconto1()
    {
        return isset($this->Desconto1) ? $this->Desconto1 : null;
    }
    /**
     * Set Desconto1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $desconto1
     * @return \StructType\LinhasComprasERP
     */
    public function setDesconto1($desconto1 = null)
    {
        if (is_null($desconto1) || (is_array($desconto1) && empty($desconto1))) {
            unset($this->Desconto1);
        } else {
            $this->Desconto1 = $desconto1;
        }
        return $this;
    }
    /**
     * Get Desconto2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDesconto2()
    {
        return isset($this->Desconto2) ? $this->Desconto2 : null;
    }
    /**
     * Set Desconto2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $desconto2
     * @return \StructType\LinhasComprasERP
     */
    public function setDesconto2($desconto2 = null)
    {
        if (is_null($desconto2) || (is_array($desconto2) && empty($desconto2))) {
            unset($this->Desconto2);
        } else {
            $this->Desconto2 = $desconto2;
        }
        return $this;
    }
    /**
     * Get Desconto3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDesconto3()
    {
        return isset($this->Desconto3) ? $this->Desconto3 : null;
    }
    /**
     * Set Desconto3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $desconto3
     * @return \StructType\LinhasComprasERP
     */
    public function setDesconto3($desconto3 = null)
    {
        if (is_null($desconto3) || (is_array($desconto3) && empty($desconto3))) {
            unset($this->Desconto3);
        } else {
            $this->Desconto3 = $desconto3;
        }
        return $this;
    }
    /**
     * Get DescontoComercial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDescontoComercial()
    {
        return isset($this->DescontoComercial) ? $this->DescontoComercial : null;
    }
    /**
     * Set DescontoComercial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $descontoComercial
     * @return \StructType\LinhasComprasERP
     */
    public function setDescontoComercial($descontoComercial = null)
    {
        if (is_null($descontoComercial) || (is_array($descontoComercial) && empty($descontoComercial))) {
            unset($this->DescontoComercial);
        } else {
            $this->DescontoComercial = $descontoComercial;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\LinhasComprasERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get DifArredondamentoMAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamentoMAlt()
    {
        return isset($this->DifArredondamentoMAlt) ? $this->DifArredondamentoMAlt : null;
    }
    /**
     * Set DifArredondamentoMAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamentoMAlt
     * @return \StructType\LinhasComprasERP
     */
    public function setDifArredondamentoMAlt($difArredondamentoMAlt = null)
    {
        if (is_null($difArredondamentoMAlt) || (is_array($difArredondamentoMAlt) && empty($difArredondamentoMAlt))) {
            unset($this->DifArredondamentoMAlt);
        } else {
            $this->DifArredondamentoMAlt = $difArredondamentoMAlt;
        }
        return $this;
    }
    /**
     * Get DifArredondamentoMBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamentoMBase()
    {
        return isset($this->DifArredondamentoMBase) ? $this->DifArredondamentoMBase : null;
    }
    /**
     * Set DifArredondamentoMBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamentoMBase
     * @return \StructType\LinhasComprasERP
     */
    public function setDifArredondamentoMBase($difArredondamentoMBase = null)
    {
        if (is_null($difArredondamentoMBase) || (is_array($difArredondamentoMBase) && empty($difArredondamentoMBase))) {
            unset($this->DifArredondamentoMBase);
        } else {
            $this->DifArredondamentoMBase = $difArredondamentoMBase;
        }
        return $this;
    }
    /**
     * Get DifCambioMAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifCambioMAlt()
    {
        return isset($this->DifCambioMAlt) ? $this->DifCambioMAlt : null;
    }
    /**
     * Set DifCambioMAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difCambioMAlt
     * @return \StructType\LinhasComprasERP
     */
    public function setDifCambioMAlt($difCambioMAlt = null)
    {
        if (is_null($difCambioMAlt) || (is_array($difCambioMAlt) && empty($difCambioMAlt))) {
            unset($this->DifCambioMAlt);
        } else {
            $this->DifCambioMAlt = $difCambioMAlt;
        }
        return $this;
    }
    /**
     * Get DifCambioMBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifCambioMBase()
    {
        return isset($this->DifCambioMBase) ? $this->DifCambioMBase : null;
    }
    /**
     * Set DifCambioMBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difCambioMBase
     * @return \StructType\LinhasComprasERP
     */
    public function setDifCambioMBase($difCambioMBase = null)
    {
        if (is_null($difCambioMBase) || (is_array($difCambioMBase) && empty($difCambioMBase))) {
            unset($this->DifCambioMBase);
        } else {
            $this->DifCambioMBase = $difCambioMBase;
        }
        return $this;
    }
    /**
     * Get DifDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifDesc()
    {
        return isset($this->DifDesc) ? $this->DifDesc : null;
    }
    /**
     * Set DifDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difDesc
     * @return \StructType\LinhasComprasERP
     */
    public function setDifDesc($difDesc = null)
    {
        if (is_null($difDesc) || (is_array($difDesc) && empty($difDesc))) {
            unset($this->DifDesc);
        } else {
            $this->DifDesc = $difDesc;
        }
        return $this;
    }
    /**
     * Get DifIVA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifIVA()
    {
        return isset($this->DifIVA) ? $this->DifIVA : null;
    }
    /**
     * Set DifIVA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difIVA
     * @return \StructType\LinhasComprasERP
     */
    public function setDifIVA($difIVA = null)
    {
        if (is_null($difIVA) || (is_array($difIVA) && empty($difIVA))) {
            unset($this->DifIVA);
        } else {
            $this->DifIVA = $difIVA;
        }
        return $this;
    }
    /**
     * Get DifPreco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifPreco()
    {
        return isset($this->DifPreco) ? $this->DifPreco : null;
    }
    /**
     * Set DifPreco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difPreco
     * @return \StructType\LinhasComprasERP
     */
    public function setDifPreco($difPreco = null)
    {
        if (is_null($difPreco) || (is_array($difPreco) && empty($difPreco))) {
            unset($this->DifPreco);
        } else {
            $this->DifPreco = $difPreco;
        }
        return $this;
    }
    /**
     * Get Ecotaxa value
     * @return float|null
     */
    public function getEcotaxa()
    {
        return $this->Ecotaxa;
    }
    /**
     * Set Ecotaxa value
     * @param float $ecotaxa
     * @return \StructType\LinhasComprasERP
     */
    public function setEcotaxa($ecotaxa = null)
    {
        $this->Ecotaxa = $ecotaxa;
        return $this;
    }
    /**
     * Get EstadoAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoAdi()
    {
        return isset($this->EstadoAdi) ? $this->EstadoAdi : null;
    }
    /**
     * Set EstadoAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoAdi
     * @return \StructType\LinhasComprasERP
     */
    public function setEstadoAdi($estadoAdi = null)
    {
        // validation for constraint: string
        if (!is_null($estadoAdi) && !is_string($estadoAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoAdi)), __LINE__);
        }
        if (is_null($estadoAdi) || (is_array($estadoAdi) && empty($estadoAdi))) {
            unset($this->EstadoAdi);
        } else {
            $this->EstadoAdi = $estadoAdi;
        }
        return $this;
    }
    /**
     * Get EstadoPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoPendente()
    {
        return isset($this->EstadoPendente) ? $this->EstadoPendente : null;
    }
    /**
     * Set EstadoPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoPendente
     * @return \StructType\LinhasComprasERP
     */
    public function setEstadoPendente($estadoPendente = null)
    {
        // validation for constraint: string
        if (!is_null($estadoPendente) && !is_string($estadoPendente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoPendente)), __LINE__);
        }
        if (is_null($estadoPendente) || (is_array($estadoPendente) && empty($estadoPendente))) {
            unset($this->EstadoPendente);
        } else {
            $this->EstadoPendente = $estadoPendente;
        }
        return $this;
    }
    /**
     * Get FactorConv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFactorConv()
    {
        return isset($this->FactorConv) ? $this->FactorConv : null;
    }
    /**
     * Set FactorConv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $factorConv
     * @return \StructType\LinhasComprasERP
     */
    public function setFactorConv($factorConv = null)
    {
        if (is_null($factorConv) || (is_array($factorConv) && empty($factorConv))) {
            unset($this->FactorConv);
        } else {
            $this->FactorConv = $factorConv;
        }
        return $this;
    }
    /**
     * Get Formula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormula()
    {
        return isset($this->Formula) ? $this->Formula : null;
    }
    /**
     * Set Formula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formula
     * @return \StructType\LinhasComprasERP
     */
    public function setFormula($formula = null)
    {
        // validation for constraint: string
        if (!is_null($formula) && !is_string($formula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formula)), __LINE__);
        }
        if (is_null($formula) || (is_array($formula) && empty($formula))) {
            unset($this->Formula);
        } else {
            $this->Formula = $formula;
        }
        return $this;
    }
    /**
     * Get FuncionalCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFuncionalCBL()
    {
        return isset($this->FuncionalCBL) ? $this->FuncionalCBL : null;
    }
    /**
     * Set FuncionalCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $funcionalCBL
     * @return \StructType\LinhasComprasERP
     */
    public function setFuncionalCBL($funcionalCBL = null)
    {
        // validation for constraint: string
        if (!is_null($funcionalCBL) && !is_string($funcionalCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($funcionalCBL)), __LINE__);
        }
        if (is_null($funcionalCBL) || (is_array($funcionalCBL) && empty($funcionalCBL))) {
            unset($this->FuncionalCBL);
        } else {
            $this->FuncionalCBL = $funcionalCBL;
        }
        return $this;
    }
    /**
     * Get IDB2BLinhaOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDB2BLinhaOrig()
    {
        return isset($this->IDB2BLinhaOrig) ? $this->IDB2BLinhaOrig : null;
    }
    /**
     * Set IDB2BLinhaOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDB2BLinhaOrig
     * @return \StructType\LinhasComprasERP
     */
    public function setIDB2BLinhaOrig($iDB2BLinhaOrig = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDB2BLinhaOrig) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDB2BLinhaOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDB2BLinhaOrig, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDB2BLinhaOrig) && !is_string($iDB2BLinhaOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDB2BLinhaOrig)), __LINE__);
        }
        if (is_null($iDB2BLinhaOrig) || (is_array($iDB2BLinhaOrig) && empty($iDB2BLinhaOrig))) {
            unset($this->IDB2BLinhaOrig);
        } else {
            $this->IDB2BLinhaOrig = $iDB2BLinhaOrig;
        }
        return $this;
    }
    /**
     * Get IDLinhaEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDLinhaEstorno()
    {
        return isset($this->IDLinhaEstorno) ? $this->IDLinhaEstorno : null;
    }
    /**
     * Set IDLinhaEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDLinhaEstorno
     * @return \StructType\LinhasComprasERP
     */
    public function setIDLinhaEstorno($iDLinhaEstorno = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDLinhaEstorno) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDLinhaEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDLinhaEstorno, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDLinhaEstorno) && !is_string($iDLinhaEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDLinhaEstorno)), __LINE__);
        }
        if (is_null($iDLinhaEstorno) || (is_array($iDLinhaEstorno) && empty($iDLinhaEstorno))) {
            unset($this->IDLinhaEstorno);
        } else {
            $this->IDLinhaEstorno = $iDLinhaEstorno;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\LinhasComprasERP
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdCabecCompras value
     * @return string|null
     */
    public function getIdCabecCompras()
    {
        return $this->IdCabecCompras;
    }
    /**
     * Set IdCabecCompras value
     * @param string $idCabecCompras
     * @return \StructType\LinhasComprasERP
     */
    public function setIdCabecCompras($idCabecCompras = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCabecCompras) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCabecCompras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCabecCompras, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCabecCompras) && !is_string($idCabecCompras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCabecCompras)), __LINE__);
        }
        $this->IdCabecCompras = $idCabecCompras;
        return $this;
    }
    /**
     * Get IdHistorico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdHistorico()
    {
        return isset($this->IdHistorico) ? $this->IdHistorico : null;
    }
    /**
     * Set IdHistorico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idHistorico
     * @return \StructType\LinhasComprasERP
     */
    public function setIdHistorico($idHistorico = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idHistorico) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idHistorico, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idHistorico) && !is_string($idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idHistorico)), __LINE__);
        }
        if (is_null($idHistorico) || (is_array($idHistorico) && empty($idHistorico))) {
            unset($this->IdHistorico);
        } else {
            $this->IdHistorico = $idHistorico;
        }
        return $this;
    }
    /**
     * Get IdLinhaOrigemCopia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhaOrigemCopia()
    {
        return isset($this->IdLinhaOrigemCopia) ? $this->IdLinhaOrigemCopia : null;
    }
    /**
     * Set IdLinhaOrigemCopia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhaOrigemCopia
     * @return \StructType\LinhasComprasERP
     */
    public function setIdLinhaOrigemCopia($idLinhaOrigemCopia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhaOrigemCopia) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhaOrigemCopia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhaOrigemCopia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhaOrigemCopia) && !is_string($idLinhaOrigemCopia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhaOrigemCopia)), __LINE__);
        }
        if (is_null($idLinhaOrigemCopia) || (is_array($idLinhaOrigemCopia) && empty($idLinhaOrigemCopia))) {
            unset($this->IdLinhaOrigemCopia);
        } else {
            $this->IdLinhaOrigemCopia = $idLinhaOrigemCopia;
        }
        return $this;
    }
    /**
     * Get IdLinhaPai value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhaPai()
    {
        return isset($this->IdLinhaPai) ? $this->IdLinhaPai : null;
    }
    /**
     * Set IdLinhaPai value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhaPai
     * @return \StructType\LinhasComprasERP
     */
    public function setIdLinhaPai($idLinhaPai = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhaPai) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhaPai)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhaPai, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhaPai) && !is_string($idLinhaPai)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhaPai)), __LINE__);
        }
        if (is_null($idLinhaPai) || (is_array($idLinhaPai) && empty($idLinhaPai))) {
            unset($this->IdLinhaPai);
        } else {
            $this->IdLinhaPai = $idLinhaPai;
        }
        return $this;
    }
    /**
     * Get IdLinhaReqInterna value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhaReqInterna()
    {
        return isset($this->IdLinhaReqInterna) ? $this->IdLinhaReqInterna : null;
    }
    /**
     * Set IdLinhaReqInterna value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhaReqInterna
     * @return \StructType\LinhasComprasERP
     */
    public function setIdLinhaReqInterna($idLinhaReqInterna = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhaReqInterna) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhaReqInterna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhaReqInterna, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhaReqInterna) && !is_string($idLinhaReqInterna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhaReqInterna)), __LINE__);
        }
        if (is_null($idLinhaReqInterna) || (is_array($idLinhaReqInterna) && empty($idLinhaReqInterna))) {
            unset($this->IdLinhaReqInterna);
        } else {
            $this->IdLinhaReqInterna = $idLinhaReqInterna;
        }
        return $this;
    }
    /**
     * Get IntrastatMassaLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIntrastatMassaLiq()
    {
        return isset($this->IntrastatMassaLiq) ? $this->IntrastatMassaLiq : null;
    }
    /**
     * Set IntrastatMassaLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $intrastatMassaLiq
     * @return \StructType\LinhasComprasERP
     */
    public function setIntrastatMassaLiq($intrastatMassaLiq = null)
    {
        if (is_null($intrastatMassaLiq) || (is_array($intrastatMassaLiq) && empty($intrastatMassaLiq))) {
            unset($this->IntrastatMassaLiq);
        } else {
            $this->IntrastatMassaLiq = $intrastatMassaLiq;
        }
        return $this;
    }
    /**
     * Get IntrastatPaisOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntrastatPaisOrigem()
    {
        return isset($this->IntrastatPaisOrigem) ? $this->IntrastatPaisOrigem : null;
    }
    /**
     * Set IntrastatPaisOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intrastatPaisOrigem
     * @return \StructType\LinhasComprasERP
     */
    public function setIntrastatPaisOrigem($intrastatPaisOrigem = null)
    {
        // validation for constraint: string
        if (!is_null($intrastatPaisOrigem) && !is_string($intrastatPaisOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intrastatPaisOrigem)), __LINE__);
        }
        if (is_null($intrastatPaisOrigem) || (is_array($intrastatPaisOrigem) && empty($intrastatPaisOrigem))) {
            unset($this->IntrastatPaisOrigem);
        } else {
            $this->IntrastatPaisOrigem = $intrastatPaisOrigem;
        }
        return $this;
    }
    /**
     * Get IntrastatPautal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntrastatPautal()
    {
        return isset($this->IntrastatPautal) ? $this->IntrastatPautal : null;
    }
    /**
     * Set IntrastatPautal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intrastatPautal
     * @return \StructType\LinhasComprasERP
     */
    public function setIntrastatPautal($intrastatPautal = null)
    {
        // validation for constraint: string
        if (!is_null($intrastatPautal) && !is_string($intrastatPautal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intrastatPautal)), __LINE__);
        }
        if (is_null($intrastatPautal) || (is_array($intrastatPautal) && empty($intrastatPautal))) {
            unset($this->IntrastatPautal);
        } else {
            $this->IntrastatPautal = $intrastatPautal;
        }
        return $this;
    }
    /**
     * Get IntrastatRegiao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntrastatRegiao()
    {
        return isset($this->IntrastatRegiao) ? $this->IntrastatRegiao : null;
    }
    /**
     * Set IntrastatRegiao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intrastatRegiao
     * @return \StructType\LinhasComprasERP
     */
    public function setIntrastatRegiao($intrastatRegiao = null)
    {
        // validation for constraint: string
        if (!is_null($intrastatRegiao) && !is_string($intrastatRegiao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intrastatRegiao)), __LINE__);
        }
        if (is_null($intrastatRegiao) || (is_array($intrastatRegiao) && empty($intrastatRegiao))) {
            unset($this->IntrastatRegiao);
        } else {
            $this->IntrastatRegiao = $intrastatRegiao;
        }
        return $this;
    }
    /**
     * Get IntrastatValorLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIntrastatValorLiq()
    {
        return isset($this->IntrastatValorLiq) ? $this->IntrastatValorLiq : null;
    }
    /**
     * Set IntrastatValorLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $intrastatValorLiq
     * @return \StructType\LinhasComprasERP
     */
    public function setIntrastatValorLiq($intrastatValorLiq = null)
    {
        if (is_null($intrastatValorLiq) || (is_array($intrastatValorLiq) && empty($intrastatValorLiq))) {
            unset($this->IntrastatValorLiq);
        } else {
            $this->IntrastatValorLiq = $intrastatValorLiq;
        }
        return $this;
    }
    /**
     * Get IsentoPagDireitos value
     * @return bool|null
     */
    public function getIsentoPagDireitos()
    {
        return $this->IsentoPagDireitos;
    }
    /**
     * Set IsentoPagDireitos value
     * @param bool $isentoPagDireitos
     * @return \StructType\LinhasComprasERP
     */
    public function setIsentoPagDireitos($isentoPagDireitos = null)
    {
        // validation for constraint: boolean
        if (!is_null($isentoPagDireitos) && !is_bool($isentoPagDireitos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isentoPagDireitos)), __LINE__);
        }
        $this->IsentoPagDireitos = $isentoPagDireitos;
        return $this;
    }
    /**
     * Get ItemCod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemCod()
    {
        return isset($this->ItemCod) ? $this->ItemCod : null;
    }
    /**
     * Set ItemCod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemCod
     * @return \StructType\LinhasComprasERP
     */
    public function setItemCod($itemCod = null)
    {
        // validation for constraint: string
        if (!is_null($itemCod) && !is_string($itemCod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCod)), __LINE__);
        }
        if (is_null($itemCod) || (is_array($itemCod) && empty($itemCod))) {
            unset($this->ItemCod);
        } else {
            $this->ItemCod = $itemCod;
        }
        return $this;
    }
    /**
     * Get ItemDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDesc()
    {
        return isset($this->ItemDesc) ? $this->ItemDesc : null;
    }
    /**
     * Set ItemDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDesc
     * @return \StructType\LinhasComprasERP
     */
    public function setItemDesc($itemDesc = null)
    {
        // validation for constraint: string
        if (!is_null($itemDesc) && !is_string($itemDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDesc)), __LINE__);
        }
        if (is_null($itemDesc) || (is_array($itemDesc) && empty($itemDesc))) {
            unset($this->ItemDesc);
        } else {
            $this->ItemDesc = $itemDesc;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \StructType\LinhasComprasERP
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get IvaNaoDedutivel value
     * @return float|null
     */
    public function getIvaNaoDedutivel()
    {
        return $this->IvaNaoDedutivel;
    }
    /**
     * Set IvaNaoDedutivel value
     * @param float $ivaNaoDedutivel
     * @return \StructType\LinhasComprasERP
     */
    public function setIvaNaoDedutivel($ivaNaoDedutivel = null)
    {
        $this->IvaNaoDedutivel = $ivaNaoDedutivel;
        return $this;
    }
    /**
     * Get IvaRegraCalculo value
     * @return int|null
     */
    public function getIvaRegraCalculo()
    {
        return $this->IvaRegraCalculo;
    }
    /**
     * Set IvaRegraCalculo value
     * @param int $ivaRegraCalculo
     * @return \StructType\LinhasComprasERP
     */
    public function setIvaRegraCalculo($ivaRegraCalculo = null)
    {
        // validation for constraint: int
        if (!is_null($ivaRegraCalculo) && !is_numeric($ivaRegraCalculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ivaRegraCalculo)), __LINE__);
        }
        $this->IvaRegraCalculo = $ivaRegraCalculo;
        return $this;
    }
    /**
     * Get IvaValorDesconto value
     * @return float|null
     */
    public function getIvaValorDesconto()
    {
        return $this->IvaValorDesconto;
    }
    /**
     * Set IvaValorDesconto value
     * @param float $ivaValorDesconto
     * @return \StructType\LinhasComprasERP
     */
    public function setIvaValorDesconto($ivaValorDesconto = null)
    {
        $this->IvaValorDesconto = $ivaValorDesconto;
        return $this;
    }
    /**
     * Get LinhasEstados value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLinhasComprasStatusERP|null
     */
    public function getLinhasEstados()
    {
        return isset($this->LinhasEstados) ? $this->LinhasEstados : null;
    }
    /**
     * Set LinhasEstados value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLinhasComprasStatusERP $linhasEstados
     * @return \StructType\LinhasComprasERP
     */
    public function setLinhasEstados(\ArrayType\ArrayOfLinhasComprasStatusERP $linhasEstados = null)
    {
        if (is_null($linhasEstados) || (is_array($linhasEstados) && empty($linhasEstados))) {
            unset($this->LinhasEstados);
        } else {
            $this->LinhasEstados = $linhasEstados;
        }
        return $this;
    }
    /**
     * Get LinhasTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLinhasComprasTransERP|null
     */
    public function getLinhasTrans()
    {
        return isset($this->LinhasTrans) ? $this->LinhasTrans : null;
    }
    /**
     * Set LinhasTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLinhasComprasTransERP $linhasTrans
     * @return \StructType\LinhasComprasERP
     */
    public function setLinhasTrans(\ArrayType\ArrayOfLinhasComprasTransERP $linhasTrans = null)
    {
        if (is_null($linhasTrans) || (is_array($linhasTrans) && empty($linhasTrans))) {
            unset($this->LinhasTrans);
        } else {
            $this->LinhasTrans = $linhasTrans;
        }
        return $this;
    }
    /**
     * Get Localizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizacao()
    {
        return isset($this->Localizacao) ? $this->Localizacao : null;
    }
    /**
     * Set Localizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizacao
     * @return \StructType\LinhasComprasERP
     */
    public function setLocalizacao($localizacao = null)
    {
        // validation for constraint: string
        if (!is_null($localizacao) && !is_string($localizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizacao)), __LINE__);
        }
        if (is_null($localizacao) || (is_array($localizacao) && empty($localizacao))) {
            unset($this->Localizacao);
        } else {
            $this->Localizacao = $localizacao;
        }
        return $this;
    }
    /**
     * Get Lote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLote()
    {
        return isset($this->Lote) ? $this->Lote : null;
    }
    /**
     * Set Lote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lote
     * @return \StructType\LinhasComprasERP
     */
    public function setLote($lote = null)
    {
        // validation for constraint: string
        if (!is_null($lote) && !is_string($lote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lote)), __LINE__);
        }
        if (is_null($lote) || (is_array($lote) && empty($lote))) {
            unset($this->Lote);
        } else {
            $this->Lote = $lote;
        }
        return $this;
    }
    /**
     * Get ModuloOrigemCopia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModuloOrigemCopia()
    {
        return isset($this->ModuloOrigemCopia) ? $this->ModuloOrigemCopia : null;
    }
    /**
     * Set ModuloOrigemCopia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moduloOrigemCopia
     * @return \StructType\LinhasComprasERP
     */
    public function setModuloOrigemCopia($moduloOrigemCopia = null)
    {
        // validation for constraint: string
        if (!is_null($moduloOrigemCopia) && !is_string($moduloOrigemCopia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moduloOrigemCopia)), __LINE__);
        }
        if (is_null($moduloOrigemCopia) || (is_array($moduloOrigemCopia) && empty($moduloOrigemCopia))) {
            unset($this->ModuloOrigemCopia);
        } else {
            $this->ModuloOrigemCopia = $moduloOrigemCopia;
        }
        return $this;
    }
    /**
     * Get MoedaDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoedaDocOrig()
    {
        return isset($this->MoedaDocOrig) ? $this->MoedaDocOrig : null;
    }
    /**
     * Set MoedaDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moedaDocOrig
     * @return \StructType\LinhasComprasERP
     */
    public function setMoedaDocOrig($moedaDocOrig = null)
    {
        // validation for constraint: string
        if (!is_null($moedaDocOrig) && !is_string($moedaDocOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moedaDocOrig)), __LINE__);
        }
        if (is_null($moedaDocOrig) || (is_array($moedaDocOrig) && empty($moedaDocOrig))) {
            unset($this->MoedaDocOrig);
        } else {
            $this->MoedaDocOrig = $moedaDocOrig;
        }
        return $this;
    }
    /**
     * Get MotivoEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoEstorno()
    {
        return isset($this->MotivoEstorno) ? $this->MotivoEstorno : null;
    }
    /**
     * Set MotivoEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoEstorno
     * @return \StructType\LinhasComprasERP
     */
    public function setMotivoEstorno($motivoEstorno = null)
    {
        // validation for constraint: string
        if (!is_null($motivoEstorno) && !is_string($motivoEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivoEstorno)), __LINE__);
        }
        if (is_null($motivoEstorno) || (is_array($motivoEstorno) && empty($motivoEstorno))) {
            unset($this->MotivoEstorno);
        } else {
            $this->MotivoEstorno = $motivoEstorno;
        }
        return $this;
    }
    /**
     * Get MovSTK value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovSTK()
    {
        return isset($this->MovSTK) ? $this->MovSTK : null;
    }
    /**
     * Set MovSTK value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movSTK
     * @return \StructType\LinhasComprasERP
     */
    public function setMovSTK($movSTK = null)
    {
        // validation for constraint: string
        if (!is_null($movSTK) && !is_string($movSTK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($movSTK)), __LINE__);
        }
        if (is_null($movSTK) || (is_array($movSTK) && empty($movSTK))) {
            unset($this->MovSTK);
        } else {
            $this->MovSTK = $movSTK;
        }
        return $this;
    }
    /**
     * Get NumDocExterno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumDocExterno()
    {
        return isset($this->NumDocExterno) ? $this->NumDocExterno : null;
    }
    /**
     * Set NumDocExterno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numDocExterno
     * @return \StructType\LinhasComprasERP
     */
    public function setNumDocExterno($numDocExterno = null)
    {
        // validation for constraint: string
        if (!is_null($numDocExterno) && !is_string($numDocExterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numDocExterno)), __LINE__);
        }
        if (is_null($numDocExterno) || (is_array($numDocExterno) && empty($numDocExterno))) {
            unset($this->NumDocExterno);
        } else {
            $this->NumDocExterno = $numDocExterno;
        }
        return $this;
    }
    /**
     * Get NumLinha value
     * @return int|null
     */
    public function getNumLinha()
    {
        return $this->NumLinha;
    }
    /**
     * Set NumLinha value
     * @param int $numLinha
     * @return \StructType\LinhasComprasERP
     */
    public function setNumLinha($numLinha = null)
    {
        // validation for constraint: int
        if (!is_null($numLinha) && !is_numeric($numLinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numLinha)), __LINE__);
        }
        $this->NumLinha = $numLinha;
        return $this;
    }
    /**
     * Get NumLinhaSTKGerada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumLinhaSTKGerada()
    {
        return isset($this->NumLinhaSTKGerada) ? $this->NumLinhaSTKGerada : null;
    }
    /**
     * Set NumLinhaSTKGerada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numLinhaSTKGerada
     * @return \StructType\LinhasComprasERP
     */
    public function setNumLinhaSTKGerada($numLinhaSTKGerada = null)
    {
        // validation for constraint: int
        if (!is_null($numLinhaSTKGerada) && !is_numeric($numLinhaSTKGerada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numLinhaSTKGerada)), __LINE__);
        }
        if (is_null($numLinhaSTKGerada) || (is_array($numLinhaSTKGerada) && empty($numLinhaSTKGerada))) {
            unset($this->NumLinhaSTKGerada);
        } else {
            $this->NumLinhaSTKGerada = $numLinhaSTKGerada;
        }
        return $this;
    }
    /**
     * Get ObraID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObraID()
    {
        return isset($this->ObraID) ? $this->ObraID : null;
    }
    /**
     * Set ObraID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $obraID
     * @return \StructType\LinhasComprasERP
     */
    public function setObraID($obraID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($obraID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $obraID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($obraID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($obraID) && !is_string($obraID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obraID)), __LINE__);
        }
        if (is_null($obraID) || (is_array($obraID) && empty($obraID))) {
            unset($this->ObraID);
        } else {
            $this->ObraID = $obraID;
        }
        return $this;
    }
    /**
     * Get OrganicaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganicaCBL()
    {
        return isset($this->OrganicaCBL) ? $this->OrganicaCBL : null;
    }
    /**
     * Set OrganicaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organicaCBL
     * @return \StructType\LinhasComprasERP
     */
    public function setOrganicaCBL($organicaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($organicaCBL) && !is_string($organicaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organicaCBL)), __LINE__);
        }
        if (is_null($organicaCBL) || (is_array($organicaCBL) && empty($organicaCBL))) {
            unset($this->OrganicaCBL);
        } else {
            $this->OrganicaCBL = $organicaCBL;
        }
        return $this;
    }
    /**
     * Get PercIncidenciaIVA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPercIncidenciaIVA()
    {
        return isset($this->PercIncidenciaIVA) ? $this->PercIncidenciaIVA : null;
    }
    /**
     * Set PercIncidenciaIVA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $percIncidenciaIVA
     * @return \StructType\LinhasComprasERP
     */
    public function setPercIncidenciaIVA($percIncidenciaIVA = null)
    {
        if (is_null($percIncidenciaIVA) || (is_array($percIncidenciaIVA) && empty($percIncidenciaIVA))) {
            unset($this->PercIncidenciaIVA);
        } else {
            $this->PercIncidenciaIVA = $percIncidenciaIVA;
        }
        return $this;
    }
    /**
     * Get PercIvaDedutivel value
     * @return float|null
     */
    public function getPercIvaDedutivel()
    {
        return $this->PercIvaDedutivel;
    }
    /**
     * Set PercIvaDedutivel value
     * @param float $percIvaDedutivel
     * @return \StructType\LinhasComprasERP
     */
    public function setPercIvaDedutivel($percIvaDedutivel = null)
    {
        $this->PercIvaDedutivel = $percIvaDedutivel;
        return $this;
    }
    /**
     * Get PrecUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrecUnit()
    {
        return isset($this->PrecUnit) ? $this->PrecUnit : null;
    }
    /**
     * Set PrecUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $precUnit
     * @return \StructType\LinhasComprasERP
     */
    public function setPrecUnit($precUnit = null)
    {
        if (is_null($precUnit) || (is_array($precUnit) && empty($precUnit))) {
            unset($this->PrecUnit);
        } else {
            $this->PrecUnit = $precUnit;
        }
        return $this;
    }
    /**
     * Get PrecoLiquido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrecoLiquido()
    {
        return isset($this->PrecoLiquido) ? $this->PrecoLiquido : null;
    }
    /**
     * Set PrecoLiquido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $precoLiquido
     * @return \StructType\LinhasComprasERP
     */
    public function setPrecoLiquido($precoLiquido = null)
    {
        if (is_null($precoLiquido) || (is_array($precoLiquido) && empty($precoLiquido))) {
            unset($this->PrecoLiquido);
        } else {
            $this->PrecoLiquido = $precoLiquido;
        }
        return $this;
    }
    /**
     * Get ProcessoID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessoID()
    {
        return isset($this->ProcessoID) ? $this->ProcessoID : null;
    }
    /**
     * Set ProcessoID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processoID
     * @return \StructType\LinhasComprasERP
     */
    public function setProcessoID($processoID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($processoID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($processoID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($processoID) && !is_string($processoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processoID)), __LINE__);
        }
        if (is_null($processoID) || (is_array($processoID) && empty($processoID))) {
            unset($this->ProcessoID);
        } else {
            $this->ProcessoID = $processoID;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasComprasERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QntFormula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQntFormula()
    {
        return isset($this->QntFormula) ? $this->QntFormula : null;
    }
    /**
     * Set QntFormula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qntFormula
     * @return \StructType\LinhasComprasERP
     */
    public function setQntFormula($qntFormula = null)
    {
        if (is_null($qntFormula) || (is_array($qntFormula) && empty($qntFormula))) {
            unset($this->QntFormula);
        } else {
            $this->QntFormula = $qntFormula;
        }
        return $this;
    }
    /**
     * Get Quantidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantidade()
    {
        return isset($this->Quantidade) ? $this->Quantidade : null;
    }
    /**
     * Set Quantidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantidade
     * @return \StructType\LinhasComprasERP
     */
    public function setQuantidade($quantidade = null)
    {
        if (is_null($quantidade) || (is_array($quantidade) && empty($quantidade))) {
            unset($this->Quantidade);
        } else {
            $this->Quantidade = $quantidade;
        }
        return $this;
    }
    /**
     * Get RegimeIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegimeIva()
    {
        return isset($this->RegimeIva) ? $this->RegimeIva : null;
    }
    /**
     * Set RegimeIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regimeIva
     * @return \StructType\LinhasComprasERP
     */
    public function setRegimeIva($regimeIva = null)
    {
        // validation for constraint: string
        if (!is_null($regimeIva) && !is_string($regimeIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regimeIva)), __LINE__);
        }
        if (is_null($regimeIva) || (is_array($regimeIva) && empty($regimeIva))) {
            unset($this->RegimeIva);
        } else {
            $this->RegimeIva = $regimeIva;
        }
        return $this;
    }
    /**
     * Get RegraCalculoIncidencia value
     * @return string|null
     */
    public function getRegraCalculoIncidencia()
    {
        return $this->RegraCalculoIncidencia;
    }
    /**
     * Set RegraCalculoIncidencia value
     * @param string $regraCalculoIncidencia
     * @return \StructType\LinhasComprasERP
     */
    public function setRegraCalculoIncidencia($regraCalculoIncidencia = null)
    {
        // validation for constraint: string
        if (!is_null($regraCalculoIncidencia) && !is_string($regraCalculoIncidencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regraCalculoIncidencia)), __LINE__);
        }
        $this->RegraCalculoIncidencia = $regraCalculoIncidencia;
        return $this;
    }
    /**
     * Get SubEmpID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubEmpID()
    {
        return isset($this->SubEmpID) ? $this->SubEmpID : null;
    }
    /**
     * Set SubEmpID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subEmpID
     * @return \StructType\LinhasComprasERP
     */
    public function setSubEmpID($subEmpID = null)
    {
        // validation for constraint: int
        if (!is_null($subEmpID) && !is_numeric($subEmpID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subEmpID)), __LINE__);
        }
        if (is_null($subEmpID) || (is_array($subEmpID) && empty($subEmpID))) {
            unset($this->SubEmpID);
        } else {
            $this->SubEmpID = $subEmpID;
        }
        return $this;
    }
    /**
     * Get SujeitoRetencao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSujeitoRetencao()
    {
        return isset($this->SujeitoRetencao) ? $this->SujeitoRetencao : null;
    }
    /**
     * Set SujeitoRetencao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sujeitoRetencao
     * @return \StructType\LinhasComprasERP
     */
    public function setSujeitoRetencao($sujeitoRetencao = null)
    {
        // validation for constraint: boolean
        if (!is_null($sujeitoRetencao) && !is_bool($sujeitoRetencao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sujeitoRetencao)), __LINE__);
        }
        if (is_null($sujeitoRetencao) || (is_array($sujeitoRetencao) && empty($sujeitoRetencao))) {
            unset($this->SujeitoRetencao);
        } else {
            $this->SujeitoRetencao = $sujeitoRetencao;
        }
        return $this;
    }
    /**
     * Get TaxaIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaIva()
    {
        return isset($this->TaxaIva) ? $this->TaxaIva : null;
    }
    /**
     * Set TaxaIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaIva
     * @return \StructType\LinhasComprasERP
     */
    public function setTaxaIva($taxaIva = null)
    {
        if (is_null($taxaIva) || (is_array($taxaIva) && empty($taxaIva))) {
            unset($this->TaxaIva);
        } else {
            $this->TaxaIva = $taxaIva;
        }
        return $this;
    }
    /**
     * Get TaxaIvaEcotaxa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaIvaEcotaxa()
    {
        return isset($this->TaxaIvaEcotaxa) ? $this->TaxaIvaEcotaxa : null;
    }
    /**
     * Set TaxaIvaEcotaxa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaIvaEcotaxa
     * @return \StructType\LinhasComprasERP
     */
    public function setTaxaIvaEcotaxa($taxaIvaEcotaxa = null)
    {
        if (is_null($taxaIvaEcotaxa) || (is_array($taxaIvaEcotaxa) && empty($taxaIvaEcotaxa))) {
            unset($this->TaxaIvaEcotaxa);
        } else {
            $this->TaxaIvaEcotaxa = $taxaIvaEcotaxa;
        }
        return $this;
    }
    /**
     * Get TaxaIvaIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaIvaIEC()
    {
        return isset($this->TaxaIvaIEC) ? $this->TaxaIvaIEC : null;
    }
    /**
     * Set TaxaIvaIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaIvaIEC
     * @return \StructType\LinhasComprasERP
     */
    public function setTaxaIvaIEC($taxaIvaIEC = null)
    {
        if (is_null($taxaIvaIEC) || (is_array($taxaIvaIEC) && empty($taxaIvaIEC))) {
            unset($this->TaxaIvaIEC);
        } else {
            $this->TaxaIvaIEC = $taxaIvaIEC;
        }
        return $this;
    }
    /**
     * Get TaxaProRata value
     * @return float|null
     */
    public function getTaxaProRata()
    {
        return $this->TaxaProRata;
    }
    /**
     * Set TaxaProRata value
     * @param float $taxaProRata
     * @return \StructType\LinhasComprasERP
     */
    public function setTaxaProRata($taxaProRata = null)
    {
        $this->TaxaProRata = $taxaProRata;
        return $this;
    }
    /**
     * Get TaxaRecargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaRecargo()
    {
        return isset($this->TaxaRecargo) ? $this->TaxaRecargo : null;
    }
    /**
     * Set TaxaRecargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaRecargo
     * @return \StructType\LinhasComprasERP
     */
    public function setTaxaRecargo($taxaRecargo = null)
    {
        if (is_null($taxaRecargo) || (is_array($taxaRecargo) && empty($taxaRecargo))) {
            unset($this->TaxaRecargo);
        } else {
            $this->TaxaRecargo = $taxaRecargo;
        }
        return $this;
    }
    /**
     * Get TipoAuto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoAuto()
    {
        return isset($this->TipoAuto) ? $this->TipoAuto : null;
    }
    /**
     * Set TipoAuto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoAuto
     * @return \StructType\LinhasComprasERP
     */
    public function setTipoAuto($tipoAuto = null)
    {
        // validation for constraint: string
        if (!is_null($tipoAuto) && !is_string($tipoAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoAuto)), __LINE__);
        }
        if (is_null($tipoAuto) || (is_array($tipoAuto) && empty($tipoAuto))) {
            unset($this->TipoAuto);
        } else {
            $this->TipoAuto = $tipoAuto;
        }
        return $this;
    }
    /**
     * Get TipoLinha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoLinha()
    {
        return isset($this->TipoLinha) ? $this->TipoLinha : null;
    }
    /**
     * Set TipoLinha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoLinha
     * @return \StructType\LinhasComprasERP
     */
    public function setTipoLinha($tipoLinha = null)
    {
        // validation for constraint: string
        if (!is_null($tipoLinha) && !is_string($tipoLinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoLinha)), __LINE__);
        }
        if (is_null($tipoLinha) || (is_array($tipoLinha) && empty($tipoLinha))) {
            unset($this->TipoLinha);
        } else {
            $this->TipoLinha = $tipoLinha;
        }
        return $this;
    }
    /**
     * Get TipoOperacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoOperacao()
    {
        return isset($this->TipoOperacao) ? $this->TipoOperacao : null;
    }
    /**
     * Set TipoOperacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoOperacao
     * @return \StructType\LinhasComprasERP
     */
    public function setTipoOperacao($tipoOperacao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoOperacao) && !is_string($tipoOperacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoOperacao)), __LINE__);
        }
        if (is_null($tipoOperacao) || (is_array($tipoOperacao) && empty($tipoOperacao))) {
            unset($this->TipoOperacao);
        } else {
            $this->TipoOperacao = $tipoOperacao;
        }
        return $this;
    }
    /**
     * Get TotalDA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDA()
    {
        return isset($this->TotalDA) ? $this->TotalDA : null;
    }
    /**
     * Set TotalDA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDA
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalDA($totalDA = null)
    {
        if (is_null($totalDA) || (is_array($totalDA) && empty($totalDA))) {
            unset($this->TotalDA);
        } else {
            $this->TotalDA = $totalDA;
        }
        return $this;
    }
    /**
     * Get TotalDC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDC()
    {
        return isset($this->TotalDC) ? $this->TotalDC : null;
    }
    /**
     * Set TotalDC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDC
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalDC($totalDC = null)
    {
        if (is_null($totalDC) || (is_array($totalDC) && empty($totalDC))) {
            unset($this->TotalDC);
        } else {
            $this->TotalDC = $totalDC;
        }
        return $this;
    }
    /**
     * Get TotalDF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDF()
    {
        return isset($this->TotalDF) ? $this->TotalDF : null;
    }
    /**
     * Set TotalDF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDF
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalDF($totalDF = null)
    {
        if (is_null($totalDF) || (is_array($totalDF) && empty($totalDF))) {
            unset($this->TotalDF);
        } else {
            $this->TotalDF = $totalDF;
        }
        return $this;
    }
    /**
     * Get TotalEcotaxa value
     * @return float|null
     */
    public function getTotalEcotaxa()
    {
        return $this->TotalEcotaxa;
    }
    /**
     * Set TotalEcotaxa value
     * @param float $totalEcotaxa
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalEcotaxa($totalEcotaxa = null)
    {
        $this->TotalEcotaxa = $totalEcotaxa;
        return $this;
    }
    /**
     * Get TotalIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIEC()
    {
        return isset($this->TotalIEC) ? $this->TotalIEC : null;
    }
    /**
     * Set TotalIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIEC
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalIEC($totalIEC = null)
    {
        if (is_null($totalIEC) || (is_array($totalIEC) && empty($totalIEC))) {
            unset($this->TotalIEC);
        } else {
            $this->TotalIEC = $totalIEC;
        }
        return $this;
    }
    /**
     * Get TotalIliquido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIliquido()
    {
        return isset($this->TotalIliquido) ? $this->TotalIliquido : null;
    }
    /**
     * Set TotalIliquido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIliquido
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalIliquido($totalIliquido = null)
    {
        if (is_null($totalIliquido) || (is_array($totalIliquido) && empty($totalIliquido))) {
            unset($this->TotalIliquido);
        } else {
            $this->TotalIliquido = $totalIliquido;
        }
        return $this;
    }
    /**
     * Get TotalIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIva()
    {
        return isset($this->TotalIva) ? $this->TotalIva : null;
    }
    /**
     * Set TotalIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIva
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalIva($totalIva = null)
    {
        if (is_null($totalIva) || (is_array($totalIva) && empty($totalIva))) {
            unset($this->TotalIva);
        } else {
            $this->TotalIva = $totalIva;
        }
        return $this;
    }
    /**
     * Get TotalRecargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalRecargo()
    {
        return isset($this->TotalRecargo) ? $this->TotalRecargo : null;
    }
    /**
     * Set TotalRecargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalRecargo
     * @return \StructType\LinhasComprasERP
     */
    public function setTotalRecargo($totalRecargo = null)
    {
        if (is_null($totalRecargo) || (is_array($totalRecargo) && empty($totalRecargo))) {
            unset($this->TotalRecargo);
        } else {
            $this->TotalRecargo = $totalRecargo;
        }
        return $this;
    }
    /**
     * Get Unidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidade()
    {
        return isset($this->Unidade) ? $this->Unidade : null;
    }
    /**
     * Set Unidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidade
     * @return \StructType\LinhasComprasERP
     */
    public function setUnidade($unidade = null)
    {
        // validation for constraint: string
        if (!is_null($unidade) && !is_string($unidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidade)), __LINE__);
        }
        if (is_null($unidade) || (is_array($unidade) && empty($unidade))) {
            unset($this->Unidade);
        } else {
            $this->Unidade = $unidade;
        }
        return $this;
    }
    /**
     * Get ValorIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorIEC()
    {
        return isset($this->ValorIEC) ? $this->ValorIEC : null;
    }
    /**
     * Set ValorIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorIEC
     * @return \StructType\LinhasComprasERP
     */
    public function setValorIEC($valorIEC = null)
    {
        if (is_null($valorIEC) || (is_array($valorIEC) && empty($valorIEC))) {
            unset($this->ValorIEC);
        } else {
            $this->ValorIEC = $valorIEC;
        }
        return $this;
    }
    /**
     * Get ValorLiquidoDesconto value
     * @return float|null
     */
    public function getValorLiquidoDesconto()
    {
        return $this->ValorLiquidoDesconto;
    }
    /**
     * Set ValorLiquidoDesconto value
     * @param float $valorLiquidoDesconto
     * @return \StructType\LinhasComprasERP
     */
    public function setValorLiquidoDesconto($valorLiquidoDesconto = null)
    {
        $this->ValorLiquidoDesconto = $valorLiquidoDesconto;
        return $this;
    }
    /**
     * Get VariavelA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVariavelA()
    {
        return isset($this->VariavelA) ? $this->VariavelA : null;
    }
    /**
     * Set VariavelA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $variavelA
     * @return \StructType\LinhasComprasERP
     */
    public function setVariavelA($variavelA = null)
    {
        if (is_null($variavelA) || (is_array($variavelA) && empty($variavelA))) {
            unset($this->VariavelA);
        } else {
            $this->VariavelA = $variavelA;
        }
        return $this;
    }
    /**
     * Get VariavelB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVariavelB()
    {
        return isset($this->VariavelB) ? $this->VariavelB : null;
    }
    /**
     * Set VariavelB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $variavelB
     * @return \StructType\LinhasComprasERP
     */
    public function setVariavelB($variavelB = null)
    {
        if (is_null($variavelB) || (is_array($variavelB) && empty($variavelB))) {
            unset($this->VariavelB);
        } else {
            $this->VariavelB = $variavelB;
        }
        return $this;
    }
    /**
     * Get VariavelC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVariavelC()
    {
        return isset($this->VariavelC) ? $this->VariavelC : null;
    }
    /**
     * Set VariavelC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $variavelC
     * @return \StructType\LinhasComprasERP
     */
    public function setVariavelC($variavelC = null)
    {
        if (is_null($variavelC) || (is_array($variavelC) && empty($variavelC))) {
            unset($this->VariavelC);
        } else {
            $this->VariavelC = $variavelC;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasComprasERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Get WBSItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBSItem()
    {
        return isset($this->WBSItem) ? $this->WBSItem : null;
    }
    /**
     * Set WBSItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBSItem
     * @return \StructType\LinhasComprasERP
     */
    public function setWBSItem($wBSItem = null)
    {
        // validation for constraint: string
        if (!is_null($wBSItem) && !is_string($wBSItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wBSItem)), __LINE__);
        }
        if (is_null($wBSItem) || (is_array($wBSItem) && empty($wBSItem))) {
            unset($this->WBSItem);
        } else {
            $this->WBSItem = $wBSItem;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasComprasERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
