<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstornarDocumentoDeVendaSimples StructType
 * @subpackage Structs
 */
class EstornarDocumentoDeVendaSimples extends AbstractStructBase
{
    /**
     * The documentoVenda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CabecDocERP
     */
    public $documentoVenda;
    /**
     * The motivoEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $motivoEstorno;
    /**
     * The dateEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEstorno;
    /**
     * Constructor method for EstornarDocumentoDeVendaSimples
     * @uses EstornarDocumentoDeVendaSimples::setDocumentoVenda()
     * @uses EstornarDocumentoDeVendaSimples::setMotivoEstorno()
     * @uses EstornarDocumentoDeVendaSimples::setDateEstorno()
     * @param \StructType\CabecDocERP $documentoVenda
     * @param string $motivoEstorno
     * @param string $dateEstorno
     */
    public function __construct(\StructType\CabecDocERP $documentoVenda = null, $motivoEstorno = null, $dateEstorno = null)
    {
        $this
            ->setDocumentoVenda($documentoVenda)
            ->setMotivoEstorno($motivoEstorno)
            ->setDateEstorno($dateEstorno);
    }
    /**
     * Get documentoVenda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CabecDocERP|null
     */
    public function getDocumentoVenda()
    {
        return isset($this->documentoVenda) ? $this->documentoVenda : null;
    }
    /**
     * Set documentoVenda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CabecDocERP $documentoVenda
     * @return \StructType\EstornarDocumentoDeVendaSimples
     */
    public function setDocumentoVenda(\StructType\CabecDocERP $documentoVenda = null)
    {
        if (is_null($documentoVenda) || (is_array($documentoVenda) && empty($documentoVenda))) {
            unset($this->documentoVenda);
        } else {
            $this->documentoVenda = $documentoVenda;
        }
        return $this;
    }
    /**
     * Get motivoEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoEstorno()
    {
        return isset($this->motivoEstorno) ? $this->motivoEstorno : null;
    }
    /**
     * Set motivoEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoEstorno
     * @return \StructType\EstornarDocumentoDeVendaSimples
     */
    public function setMotivoEstorno($motivoEstorno = null)
    {
        // validation for constraint: string
        if (!is_null($motivoEstorno) && !is_string($motivoEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivoEstorno)), __LINE__);
        }
        if (is_null($motivoEstorno) || (is_array($motivoEstorno) && empty($motivoEstorno))) {
            unset($this->motivoEstorno);
        } else {
            $this->motivoEstorno = $motivoEstorno;
        }
        return $this;
    }
    /**
     * Get dateEstorno value
     * @return string|null
     */
    public function getDateEstorno()
    {
        return $this->dateEstorno;
    }
    /**
     * Set dateEstorno value
     * @param string $dateEstorno
     * @return \StructType\EstornarDocumentoDeVendaSimples
     */
    public function setDateEstorno($dateEstorno = null)
    {
        // validation for constraint: string
        if (!is_null($dateEstorno) && !is_string($dateEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEstorno)), __LINE__);
        }
        $this->dateEstorno = $dateEstorno;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstornarDocumentoDeVendaSimples
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
