<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditaModelo StructType
 * @subpackage Structs
 */
class EditaModelo extends AbstractStructBase
{
    /**
     * The marca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $marca;
    /**
     * The modelo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $modelo;
    /**
     * The forceRefresh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $forceRefresh;
    /**
     * Constructor method for EditaModelo
     * @uses EditaModelo::setMarca()
     * @uses EditaModelo::setModelo()
     * @uses EditaModelo::setForceRefresh()
     * @param string $marca
     * @param string $modelo
     * @param bool $forceRefresh
     */
    public function __construct($marca = null, $modelo = null, $forceRefresh = null)
    {
        $this
            ->setMarca($marca)
            ->setModelo($modelo)
            ->setForceRefresh($forceRefresh);
    }
    /**
     * Get marca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarca()
    {
        return isset($this->marca) ? $this->marca : null;
    }
    /**
     * Set marca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marca
     * @return \StructType\EditaModelo
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marca)), __LINE__);
        }
        if (is_null($marca) || (is_array($marca) && empty($marca))) {
            unset($this->marca);
        } else {
            $this->marca = $marca;
        }
        return $this;
    }
    /**
     * Get modelo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModelo()
    {
        return isset($this->modelo) ? $this->modelo : null;
    }
    /**
     * Set modelo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modelo
     * @return \StructType\EditaModelo
     */
    public function setModelo($modelo = null)
    {
        // validation for constraint: string
        if (!is_null($modelo) && !is_string($modelo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelo)), __LINE__);
        }
        if (is_null($modelo) || (is_array($modelo) && empty($modelo))) {
            unset($this->modelo);
        } else {
            $this->modelo = $modelo;
        }
        return $this;
    }
    /**
     * Get forceRefresh value
     * @return bool|null
     */
    public function getForceRefresh()
    {
        return $this->forceRefresh;
    }
    /**
     * Set forceRefresh value
     * @param bool $forceRefresh
     * @return \StructType\EditaModelo
     */
    public function setForceRefresh($forceRefresh = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceRefresh) && !is_bool($forceRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceRefresh)), __LINE__);
        }
        $this->forceRefresh = $forceRefresh;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditaModelo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
