<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditaArtigoIdiomaJSON StructType
 * @subpackage Structs
 */
class EditaArtigoIdiomaJSON extends AbstractStructBase
{
    /**
     * The artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artigo;
    /**
     * The idioma
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idioma;
    /**
     * The forceRefresh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $forceRefresh;
    /**
     * Constructor method for EditaArtigoIdiomaJSON
     * @uses EditaArtigoIdiomaJSON::setArtigo()
     * @uses EditaArtigoIdiomaJSON::setIdioma()
     * @uses EditaArtigoIdiomaJSON::setForceRefresh()
     * @param string $artigo
     * @param string $idioma
     * @param bool $forceRefresh
     */
    public function __construct($artigo = null, $idioma = null, $forceRefresh = null)
    {
        $this
            ->setArtigo($artigo)
            ->setIdioma($idioma)
            ->setForceRefresh($forceRefresh);
    }
    /**
     * Get artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->artigo) ? $this->artigo : null;
    }
    /**
     * Set artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\EditaArtigoIdiomaJSON
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->artigo);
        } else {
            $this->artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get idioma value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdioma()
    {
        return isset($this->idioma) ? $this->idioma : null;
    }
    /**
     * Set idioma value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idioma
     * @return \StructType\EditaArtigoIdiomaJSON
     */
    public function setIdioma($idioma = null)
    {
        // validation for constraint: string
        if (!is_null($idioma) && !is_string($idioma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idioma)), __LINE__);
        }
        if (is_null($idioma) || (is_array($idioma) && empty($idioma))) {
            unset($this->idioma);
        } else {
            $this->idioma = $idioma;
        }
        return $this;
    }
    /**
     * Get forceRefresh value
     * @return bool|null
     */
    public function getForceRefresh()
    {
        return $this->forceRefresh;
    }
    /**
     * Set forceRefresh value
     * @param bool $forceRefresh
     * @return \StructType\EditaArtigoIdiomaJSON
     */
    public function setForceRefresh($forceRefresh = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceRefresh) && !is_bool($forceRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceRefresh)), __LINE__);
        }
        $this->forceRefresh = $forceRefresh;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditaArtigoIdiomaJSON
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
