<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabLiqERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CabLiqERP
 * @subpackage Structs
 */
class CabLiqERP extends AbstractStructBase
{
    /**
     * The AnoCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AnoCBL;
    /**
     * The B2BEnvioNaGravacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $B2BEnvioNaGravacao;
    /**
     * The B2BTrataTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $B2BTrataTrans;
    /**
     * The Balcao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Balcao;
    /**
     * The CDU_Estabelecimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_Estabelecimento;
    /**
     * The Cambio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Cambio;
    /**
     * The CambioMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CambioMAlt;
    /**
     * The CambioMBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CambioMBase;
    /**
     * The Comissao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Comissao;
    /**
     * The Conta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Conta;
    /**
     * The ContaAmortizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaAmortizacao;
    /**
     * The CorreccaoMonetaria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CorreccaoMonetaria;
    /**
     * The DataDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDoc;
    /**
     * The DataIntroducao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataIntroducao;
    /**
     * The DataMagnetico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataMagnetico;
    /**
     * The DataUltimaActualizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataUltimaActualizacao;
    /**
     * The DeduzLiquidaIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DeduzLiquidaIVA;
    /**
     * The Diario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Diario;
    /**
     * The DifArredondamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamento;
    /**
     * The DifArredondamentoMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamentoMAlt;
    /**
     * The DifCambio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifCambio;
    /**
     * The DifCambioMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DifCambioMAlt;
    /**
     * The DocLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocLiq;
    /**
     * The EfectuaRegularizacoes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EfectuaRegularizacoes;
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The EntidadeDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntidadeDestino;
    /**
     * The EntidadeFinanceira
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntidadeFinanceira;
    /**
     * The EstadoCBLEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EstadoCBLEntidade;
    /**
     * The EstadoDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoDestino;
    /**
     * The Estorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Estorno;
    /**
     * The Filial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filial;
    /**
     * The FolhaVenc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FolhaVenc;
    /**
     * The FormatoMagnetico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormatoMagnetico;
    /**
     * The GeradoMagnetico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GeradoMagnetico;
    /**
     * The IDDocB2B
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDDocB2B;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdCabecMovCbl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCabecMovCbl;
    /**
     * The IdCessao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCessao;
    /**
     * The IdGDOC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdGDOC;
    /**
     * The IdGuiaReceita
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdGuiaReceita;
    /**
     * The ImpostoSelo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ImpostoSelo;
    /**
     * The ImpostoSeloLivrancas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ImpostoSeloLivrancas;
    /**
     * The Impresso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Impresso;
    /**
     * The Linhas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLinhasLiqERP
     */
    public $Linhas;
    /**
     * The MantemEntidadePendentes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MantemEntidadePendentes;
    /**
     * The ModoPag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModoPag;
    /**
     * The Moeda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Moeda;
    /**
     * The MoedaDaUEM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MoedaDaUEM;
    /**
     * The MoradaAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MoradaAlt;
    /**
     * The MotivoEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoEstorno;
    /**
     * The MovContab
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MovContab;
    /**
     * The MovGesconta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MovGesconta;
    /**
     * The NumDiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumDiario;
    /**
     * The NumDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumDoc;
    /**
     * The NumRemessa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumRemessa;
    /**
     * The ObraId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObraId;
    /**
     * The Observacoes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacoes;
    /**
     * The Percentagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Percentagem;
    /**
     * The Plafond
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Plafond;
    /**
     * The Portes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Portes;
    /**
     * The Postecipado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Postecipado;
    /**
     * The Posto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Posto;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The SAFTTipoDocumento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SAFTTipoDocumento;
    /**
     * The Serie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serie;
    /**
     * The TaxaJuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaJuro;
    /**
     * The TipoConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoConta;
    /**
     * The TipoContaDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoContaDestino;
    /**
     * The TipoDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDoc;
    /**
     * The TipoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidade;
    /**
     * The TipoEntidadeDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidadeDestino;
    /**
     * The TipoLancamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoLancamento;
    /**
     * The TransferenciaEstado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TransferenciaEstado;
    /**
     * The Utilizador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Utilizador;
    /**
     * The ValorAmortizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorAmortizacao;
    /**
     * The ValorDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorDesconto;
    /**
     * The ValorRec
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRec;
    /**
     * The ValorRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencao;
    /**
     * The ValorRetencaoGarantia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoGarantia;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * The WBSItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBSItem;
    /**
     * Constructor method for CabLiqERP
     * @uses CabLiqERP::setAnoCBL()
     * @uses CabLiqERP::setB2BEnvioNaGravacao()
     * @uses CabLiqERP::setB2BTrataTrans()
     * @uses CabLiqERP::setBalcao()
     * @uses CabLiqERP::setCDU_Estabelecimento()
     * @uses CabLiqERP::setCambio()
     * @uses CabLiqERP::setCambioMAlt()
     * @uses CabLiqERP::setCambioMBase()
     * @uses CabLiqERP::setComissao()
     * @uses CabLiqERP::setConta()
     * @uses CabLiqERP::setContaAmortizacao()
     * @uses CabLiqERP::setCorreccaoMonetaria()
     * @uses CabLiqERP::setDataDoc()
     * @uses CabLiqERP::setDataIntroducao()
     * @uses CabLiqERP::setDataMagnetico()
     * @uses CabLiqERP::setDataUltimaActualizacao()
     * @uses CabLiqERP::setDeduzLiquidaIVA()
     * @uses CabLiqERP::setDiario()
     * @uses CabLiqERP::setDifArredondamento()
     * @uses CabLiqERP::setDifArredondamentoMAlt()
     * @uses CabLiqERP::setDifCambio()
     * @uses CabLiqERP::setDifCambioMAlt()
     * @uses CabLiqERP::setDocLiq()
     * @uses CabLiqERP::setEfectuaRegularizacoes()
     * @uses CabLiqERP::setEntidade()
     * @uses CabLiqERP::setEntidadeDestino()
     * @uses CabLiqERP::setEntidadeFinanceira()
     * @uses CabLiqERP::setEstadoCBLEntidade()
     * @uses CabLiqERP::setEstadoDestino()
     * @uses CabLiqERP::setEstorno()
     * @uses CabLiqERP::setFilial()
     * @uses CabLiqERP::setFolhaVenc()
     * @uses CabLiqERP::setFormatoMagnetico()
     * @uses CabLiqERP::setGeradoMagnetico()
     * @uses CabLiqERP::setIDDocB2B()
     * @uses CabLiqERP::setId()
     * @uses CabLiqERP::setIdCabecMovCbl()
     * @uses CabLiqERP::setIdCessao()
     * @uses CabLiqERP::setIdGDOC()
     * @uses CabLiqERP::setIdGuiaReceita()
     * @uses CabLiqERP::setImpostoSelo()
     * @uses CabLiqERP::setImpostoSeloLivrancas()
     * @uses CabLiqERP::setImpresso()
     * @uses CabLiqERP::setLinhas()
     * @uses CabLiqERP::setMantemEntidadePendentes()
     * @uses CabLiqERP::setModoPag()
     * @uses CabLiqERP::setMoeda()
     * @uses CabLiqERP::setMoedaDaUEM()
     * @uses CabLiqERP::setMoradaAlt()
     * @uses CabLiqERP::setMotivoEstorno()
     * @uses CabLiqERP::setMovContab()
     * @uses CabLiqERP::setMovGesconta()
     * @uses CabLiqERP::setNumDiario()
     * @uses CabLiqERP::setNumDoc()
     * @uses CabLiqERP::setNumRemessa()
     * @uses CabLiqERP::setObraId()
     * @uses CabLiqERP::setObservacoes()
     * @uses CabLiqERP::setPercentagem()
     * @uses CabLiqERP::setPlafond()
     * @uses CabLiqERP::setPortes()
     * @uses CabLiqERP::setPostecipado()
     * @uses CabLiqERP::setPosto()
     * @uses CabLiqERP::setProtegida()
     * @uses CabLiqERP::setSAFTTipoDocumento()
     * @uses CabLiqERP::setSerie()
     * @uses CabLiqERP::setTaxaJuro()
     * @uses CabLiqERP::setTipoConta()
     * @uses CabLiqERP::setTipoContaDestino()
     * @uses CabLiqERP::setTipoDoc()
     * @uses CabLiqERP::setTipoEntidade()
     * @uses CabLiqERP::setTipoEntidadeDestino()
     * @uses CabLiqERP::setTipoLancamento()
     * @uses CabLiqERP::setTransferenciaEstado()
     * @uses CabLiqERP::setUtilizador()
     * @uses CabLiqERP::setValorAmortizacao()
     * @uses CabLiqERP::setValorDesconto()
     * @uses CabLiqERP::setValorRec()
     * @uses CabLiqERP::setValorRetencao()
     * @uses CabLiqERP::setValorRetencaoGarantia()
     * @uses CabLiqERP::setVersaoUltAct()
     * @uses CabLiqERP::setWBSItem()
     * @param int $anoCBL
     * @param bool $b2BEnvioNaGravacao
     * @param bool $b2BTrataTrans
     * @param string $balcao
     * @param string $cDU_Estabelecimento
     * @param float $cambio
     * @param float $cambioMAlt
     * @param float $cambioMBase
     * @param float $comissao
     * @param string $conta
     * @param string $contaAmortizacao
     * @param float $correccaoMonetaria
     * @param string $dataDoc
     * @param string $dataIntroducao
     * @param string $dataMagnetico
     * @param string $dataUltimaActualizacao
     * @param bool $deduzLiquidaIVA
     * @param string $diario
     * @param float $difArredondamento
     * @param float $difArredondamentoMAlt
     * @param float $difCambio
     * @param float $difCambioMAlt
     * @param string $docLiq
     * @param bool $efectuaRegularizacoes
     * @param string $entidade
     * @param string $entidadeDestino
     * @param string $entidadeFinanceira
     * @param int $estadoCBLEntidade
     * @param string $estadoDestino
     * @param bool $estorno
     * @param string $filial
     * @param int $folhaVenc
     * @param string $formatoMagnetico
     * @param bool $geradoMagnetico
     * @param string $iDDocB2B
     * @param string $id
     * @param string $idCabecMovCbl
     * @param string $idCessao
     * @param string $idGDOC
     * @param string $idGuiaReceita
     * @param float $impostoSelo
     * @param float $impostoSeloLivrancas
     * @param bool $impresso
     * @param \ArrayType\ArrayOfLinhasLiqERP $linhas
     * @param bool $mantemEntidadePendentes
     * @param string $modoPag
     * @param string $moeda
     * @param bool $moedaDaUEM
     * @param string $moradaAlt
     * @param string $motivoEstorno
     * @param int $movContab
     * @param bool $movGesconta
     * @param int $numDiario
     * @param int $numDoc
     * @param int $numRemessa
     * @param string $obraId
     * @param string $observacoes
     * @param bool $percentagem
     * @param float $plafond
     * @param float $portes
     * @param bool $postecipado
     * @param string $posto
     * @param bool $protegida
     * @param string $sAFTTipoDocumento
     * @param string $serie
     * @param float $taxaJuro
     * @param string $tipoConta
     * @param string $tipoContaDestino
     * @param string $tipoDoc
     * @param string $tipoEntidade
     * @param string $tipoEntidadeDestino
     * @param string $tipoLancamento
     * @param bool $transferenciaEstado
     * @param string $utilizador
     * @param float $valorAmortizacao
     * @param float $valorDesconto
     * @param float $valorRec
     * @param float $valorRetencao
     * @param float $valorRetencaoGarantia
     * @param string $versaoUltAct
     * @param string $wBSItem
     */
    public function __construct($anoCBL = null, $b2BEnvioNaGravacao = null, $b2BTrataTrans = null, $balcao = null, $cDU_Estabelecimento = null, $cambio = null, $cambioMAlt = null, $cambioMBase = null, $comissao = null, $conta = null, $contaAmortizacao = null, $correccaoMonetaria = null, $dataDoc = null, $dataIntroducao = null, $dataMagnetico = null, $dataUltimaActualizacao = null, $deduzLiquidaIVA = null, $diario = null, $difArredondamento = null, $difArredondamentoMAlt = null, $difCambio = null, $difCambioMAlt = null, $docLiq = null, $efectuaRegularizacoes = null, $entidade = null, $entidadeDestino = null, $entidadeFinanceira = null, $estadoCBLEntidade = null, $estadoDestino = null, $estorno = null, $filial = null, $folhaVenc = null, $formatoMagnetico = null, $geradoMagnetico = null, $iDDocB2B = null, $id = null, $idCabecMovCbl = null, $idCessao = null, $idGDOC = null, $idGuiaReceita = null, $impostoSelo = null, $impostoSeloLivrancas = null, $impresso = null, \ArrayType\ArrayOfLinhasLiqERP $linhas = null, $mantemEntidadePendentes = null, $modoPag = null, $moeda = null, $moedaDaUEM = null, $moradaAlt = null, $motivoEstorno = null, $movContab = null, $movGesconta = null, $numDiario = null, $numDoc = null, $numRemessa = null, $obraId = null, $observacoes = null, $percentagem = null, $plafond = null, $portes = null, $postecipado = null, $posto = null, $protegida = null, $sAFTTipoDocumento = null, $serie = null, $taxaJuro = null, $tipoConta = null, $tipoContaDestino = null, $tipoDoc = null, $tipoEntidade = null, $tipoEntidadeDestino = null, $tipoLancamento = null, $transferenciaEstado = null, $utilizador = null, $valorAmortizacao = null, $valorDesconto = null, $valorRec = null, $valorRetencao = null, $valorRetencaoGarantia = null, $versaoUltAct = null, $wBSItem = null)
    {
        $this
            ->setAnoCBL($anoCBL)
            ->setB2BEnvioNaGravacao($b2BEnvioNaGravacao)
            ->setB2BTrataTrans($b2BTrataTrans)
            ->setBalcao($balcao)
            ->setCDU_Estabelecimento($cDU_Estabelecimento)
            ->setCambio($cambio)
            ->setCambioMAlt($cambioMAlt)
            ->setCambioMBase($cambioMBase)
            ->setComissao($comissao)
            ->setConta($conta)
            ->setContaAmortizacao($contaAmortizacao)
            ->setCorreccaoMonetaria($correccaoMonetaria)
            ->setDataDoc($dataDoc)
            ->setDataIntroducao($dataIntroducao)
            ->setDataMagnetico($dataMagnetico)
            ->setDataUltimaActualizacao($dataUltimaActualizacao)
            ->setDeduzLiquidaIVA($deduzLiquidaIVA)
            ->setDiario($diario)
            ->setDifArredondamento($difArredondamento)
            ->setDifArredondamentoMAlt($difArredondamentoMAlt)
            ->setDifCambio($difCambio)
            ->setDifCambioMAlt($difCambioMAlt)
            ->setDocLiq($docLiq)
            ->setEfectuaRegularizacoes($efectuaRegularizacoes)
            ->setEntidade($entidade)
            ->setEntidadeDestino($entidadeDestino)
            ->setEntidadeFinanceira($entidadeFinanceira)
            ->setEstadoCBLEntidade($estadoCBLEntidade)
            ->setEstadoDestino($estadoDestino)
            ->setEstorno($estorno)
            ->setFilial($filial)
            ->setFolhaVenc($folhaVenc)
            ->setFormatoMagnetico($formatoMagnetico)
            ->setGeradoMagnetico($geradoMagnetico)
            ->setIDDocB2B($iDDocB2B)
            ->setId($id)
            ->setIdCabecMovCbl($idCabecMovCbl)
            ->setIdCessao($idCessao)
            ->setIdGDOC($idGDOC)
            ->setIdGuiaReceita($idGuiaReceita)
            ->setImpostoSelo($impostoSelo)
            ->setImpostoSeloLivrancas($impostoSeloLivrancas)
            ->setImpresso($impresso)
            ->setLinhas($linhas)
            ->setMantemEntidadePendentes($mantemEntidadePendentes)
            ->setModoPag($modoPag)
            ->setMoeda($moeda)
            ->setMoedaDaUEM($moedaDaUEM)
            ->setMoradaAlt($moradaAlt)
            ->setMotivoEstorno($motivoEstorno)
            ->setMovContab($movContab)
            ->setMovGesconta($movGesconta)
            ->setNumDiario($numDiario)
            ->setNumDoc($numDoc)
            ->setNumRemessa($numRemessa)
            ->setObraId($obraId)
            ->setObservacoes($observacoes)
            ->setPercentagem($percentagem)
            ->setPlafond($plafond)
            ->setPortes($portes)
            ->setPostecipado($postecipado)
            ->setPosto($posto)
            ->setProtegida($protegida)
            ->setSAFTTipoDocumento($sAFTTipoDocumento)
            ->setSerie($serie)
            ->setTaxaJuro($taxaJuro)
            ->setTipoConta($tipoConta)
            ->setTipoContaDestino($tipoContaDestino)
            ->setTipoDoc($tipoDoc)
            ->setTipoEntidade($tipoEntidade)
            ->setTipoEntidadeDestino($tipoEntidadeDestino)
            ->setTipoLancamento($tipoLancamento)
            ->setTransferenciaEstado($transferenciaEstado)
            ->setUtilizador($utilizador)
            ->setValorAmortizacao($valorAmortizacao)
            ->setValorDesconto($valorDesconto)
            ->setValorRec($valorRec)
            ->setValorRetencao($valorRetencao)
            ->setValorRetencaoGarantia($valorRetencaoGarantia)
            ->setVersaoUltAct($versaoUltAct)
            ->setWBSItem($wBSItem);
    }
    /**
     * Get AnoCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAnoCBL()
    {
        return isset($this->AnoCBL) ? $this->AnoCBL : null;
    }
    /**
     * Set AnoCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $anoCBL
     * @return \StructType\CabLiqERP
     */
    public function setAnoCBL($anoCBL = null)
    {
        // validation for constraint: int
        if (!is_null($anoCBL) && !is_numeric($anoCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($anoCBL)), __LINE__);
        }
        if (is_null($anoCBL) || (is_array($anoCBL) && empty($anoCBL))) {
            unset($this->AnoCBL);
        } else {
            $this->AnoCBL = $anoCBL;
        }
        return $this;
    }
    /**
     * Get B2BEnvioNaGravacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getB2BEnvioNaGravacao()
    {
        return isset($this->B2BEnvioNaGravacao) ? $this->B2BEnvioNaGravacao : null;
    }
    /**
     * Set B2BEnvioNaGravacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $b2BEnvioNaGravacao
     * @return \StructType\CabLiqERP
     */
    public function setB2BEnvioNaGravacao($b2BEnvioNaGravacao = null)
    {
        // validation for constraint: boolean
        if (!is_null($b2BEnvioNaGravacao) && !is_bool($b2BEnvioNaGravacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($b2BEnvioNaGravacao)), __LINE__);
        }
        if (is_null($b2BEnvioNaGravacao) || (is_array($b2BEnvioNaGravacao) && empty($b2BEnvioNaGravacao))) {
            unset($this->B2BEnvioNaGravacao);
        } else {
            $this->B2BEnvioNaGravacao = $b2BEnvioNaGravacao;
        }
        return $this;
    }
    /**
     * Get B2BTrataTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getB2BTrataTrans()
    {
        return isset($this->B2BTrataTrans) ? $this->B2BTrataTrans : null;
    }
    /**
     * Set B2BTrataTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $b2BTrataTrans
     * @return \StructType\CabLiqERP
     */
    public function setB2BTrataTrans($b2BTrataTrans = null)
    {
        // validation for constraint: boolean
        if (!is_null($b2BTrataTrans) && !is_bool($b2BTrataTrans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($b2BTrataTrans)), __LINE__);
        }
        if (is_null($b2BTrataTrans) || (is_array($b2BTrataTrans) && empty($b2BTrataTrans))) {
            unset($this->B2BTrataTrans);
        } else {
            $this->B2BTrataTrans = $b2BTrataTrans;
        }
        return $this;
    }
    /**
     * Get Balcao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBalcao()
    {
        return isset($this->Balcao) ? $this->Balcao : null;
    }
    /**
     * Set Balcao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $balcao
     * @return \StructType\CabLiqERP
     */
    public function setBalcao($balcao = null)
    {
        // validation for constraint: string
        if (!is_null($balcao) && !is_string($balcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balcao)), __LINE__);
        }
        if (is_null($balcao) || (is_array($balcao) && empty($balcao))) {
            unset($this->Balcao);
        } else {
            $this->Balcao = $balcao;
        }
        return $this;
    }
    /**
     * Get CDU_Estabelecimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_Estabelecimento()
    {
        return isset($this->CDU_Estabelecimento) ? $this->CDU_Estabelecimento : null;
    }
    /**
     * Set CDU_Estabelecimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_Estabelecimento
     * @return \StructType\CabLiqERP
     */
    public function setCDU_Estabelecimento($cDU_Estabelecimento = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_Estabelecimento) && !is_string($cDU_Estabelecimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_Estabelecimento)), __LINE__);
        }
        if (is_null($cDU_Estabelecimento) || (is_array($cDU_Estabelecimento) && empty($cDU_Estabelecimento))) {
            unset($this->CDU_Estabelecimento);
        } else {
            $this->CDU_Estabelecimento = $cDU_Estabelecimento;
        }
        return $this;
    }
    /**
     * Get Cambio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambio()
    {
        return isset($this->Cambio) ? $this->Cambio : null;
    }
    /**
     * Set Cambio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambio
     * @return \StructType\CabLiqERP
     */
    public function setCambio($cambio = null)
    {
        if (is_null($cambio) || (is_array($cambio) && empty($cambio))) {
            unset($this->Cambio);
        } else {
            $this->Cambio = $cambio;
        }
        return $this;
    }
    /**
     * Get CambioMAlt value
     * @return float|null
     */
    public function getCambioMAlt()
    {
        return $this->CambioMAlt;
    }
    /**
     * Set CambioMAlt value
     * @param float $cambioMAlt
     * @return \StructType\CabLiqERP
     */
    public function setCambioMAlt($cambioMAlt = null)
    {
        $this->CambioMAlt = $cambioMAlt;
        return $this;
    }
    /**
     * Get CambioMBase value
     * @return float|null
     */
    public function getCambioMBase()
    {
        return $this->CambioMBase;
    }
    /**
     * Set CambioMBase value
     * @param float $cambioMBase
     * @return \StructType\CabLiqERP
     */
    public function setCambioMBase($cambioMBase = null)
    {
        $this->CambioMBase = $cambioMBase;
        return $this;
    }
    /**
     * Get Comissao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getComissao()
    {
        return isset($this->Comissao) ? $this->Comissao : null;
    }
    /**
     * Set Comissao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $comissao
     * @return \StructType\CabLiqERP
     */
    public function setComissao($comissao = null)
    {
        if (is_null($comissao) || (is_array($comissao) && empty($comissao))) {
            unset($this->Comissao);
        } else {
            $this->Comissao = $comissao;
        }
        return $this;
    }
    /**
     * Get Conta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConta()
    {
        return isset($this->Conta) ? $this->Conta : null;
    }
    /**
     * Set Conta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conta
     * @return \StructType\CabLiqERP
     */
    public function setConta($conta = null)
    {
        // validation for constraint: string
        if (!is_null($conta) && !is_string($conta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conta)), __LINE__);
        }
        if (is_null($conta) || (is_array($conta) && empty($conta))) {
            unset($this->Conta);
        } else {
            $this->Conta = $conta;
        }
        return $this;
    }
    /**
     * Get ContaAmortizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaAmortizacao()
    {
        return isset($this->ContaAmortizacao) ? $this->ContaAmortizacao : null;
    }
    /**
     * Set ContaAmortizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaAmortizacao
     * @return \StructType\CabLiqERP
     */
    public function setContaAmortizacao($contaAmortizacao = null)
    {
        // validation for constraint: string
        if (!is_null($contaAmortizacao) && !is_string($contaAmortizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaAmortizacao)), __LINE__);
        }
        if (is_null($contaAmortizacao) || (is_array($contaAmortizacao) && empty($contaAmortizacao))) {
            unset($this->ContaAmortizacao);
        } else {
            $this->ContaAmortizacao = $contaAmortizacao;
        }
        return $this;
    }
    /**
     * Get CorreccaoMonetaria value
     * @return float|null
     */
    public function getCorreccaoMonetaria()
    {
        return $this->CorreccaoMonetaria;
    }
    /**
     * Set CorreccaoMonetaria value
     * @param float $correccaoMonetaria
     * @return \StructType\CabLiqERP
     */
    public function setCorreccaoMonetaria($correccaoMonetaria = null)
    {
        $this->CorreccaoMonetaria = $correccaoMonetaria;
        return $this;
    }
    /**
     * Get DataDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDoc()
    {
        return isset($this->DataDoc) ? $this->DataDoc : null;
    }
    /**
     * Set DataDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDoc
     * @return \StructType\CabLiqERP
     */
    public function setDataDoc($dataDoc = null)
    {
        // validation for constraint: string
        if (!is_null($dataDoc) && !is_string($dataDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDoc)), __LINE__);
        }
        if (is_null($dataDoc) || (is_array($dataDoc) && empty($dataDoc))) {
            unset($this->DataDoc);
        } else {
            $this->DataDoc = $dataDoc;
        }
        return $this;
    }
    /**
     * Get DataIntroducao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataIntroducao()
    {
        return isset($this->DataIntroducao) ? $this->DataIntroducao : null;
    }
    /**
     * Set DataIntroducao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataIntroducao
     * @return \StructType\CabLiqERP
     */
    public function setDataIntroducao($dataIntroducao = null)
    {
        // validation for constraint: string
        if (!is_null($dataIntroducao) && !is_string($dataIntroducao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataIntroducao)), __LINE__);
        }
        if (is_null($dataIntroducao) || (is_array($dataIntroducao) && empty($dataIntroducao))) {
            unset($this->DataIntroducao);
        } else {
            $this->DataIntroducao = $dataIntroducao;
        }
        return $this;
    }
    /**
     * Get DataMagnetico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataMagnetico()
    {
        return isset($this->DataMagnetico) ? $this->DataMagnetico : null;
    }
    /**
     * Set DataMagnetico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataMagnetico
     * @return \StructType\CabLiqERP
     */
    public function setDataMagnetico($dataMagnetico = null)
    {
        // validation for constraint: string
        if (!is_null($dataMagnetico) && !is_string($dataMagnetico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataMagnetico)), __LINE__);
        }
        if (is_null($dataMagnetico) || (is_array($dataMagnetico) && empty($dataMagnetico))) {
            unset($this->DataMagnetico);
        } else {
            $this->DataMagnetico = $dataMagnetico;
        }
        return $this;
    }
    /**
     * Get DataUltimaActualizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataUltimaActualizacao()
    {
        return isset($this->DataUltimaActualizacao) ? $this->DataUltimaActualizacao : null;
    }
    /**
     * Set DataUltimaActualizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataUltimaActualizacao
     * @return \StructType\CabLiqERP
     */
    public function setDataUltimaActualizacao($dataUltimaActualizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataUltimaActualizacao) && !is_string($dataUltimaActualizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataUltimaActualizacao)), __LINE__);
        }
        if (is_null($dataUltimaActualizacao) || (is_array($dataUltimaActualizacao) && empty($dataUltimaActualizacao))) {
            unset($this->DataUltimaActualizacao);
        } else {
            $this->DataUltimaActualizacao = $dataUltimaActualizacao;
        }
        return $this;
    }
    /**
     * Get DeduzLiquidaIVA value
     * @return bool|null
     */
    public function getDeduzLiquidaIVA()
    {
        return $this->DeduzLiquidaIVA;
    }
    /**
     * Set DeduzLiquidaIVA value
     * @param bool $deduzLiquidaIVA
     * @return \StructType\CabLiqERP
     */
    public function setDeduzLiquidaIVA($deduzLiquidaIVA = null)
    {
        // validation for constraint: boolean
        if (!is_null($deduzLiquidaIVA) && !is_bool($deduzLiquidaIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deduzLiquidaIVA)), __LINE__);
        }
        $this->DeduzLiquidaIVA = $deduzLiquidaIVA;
        return $this;
    }
    /**
     * Get Diario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiario()
    {
        return isset($this->Diario) ? $this->Diario : null;
    }
    /**
     * Set Diario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $diario
     * @return \StructType\CabLiqERP
     */
    public function setDiario($diario = null)
    {
        // validation for constraint: string
        if (!is_null($diario) && !is_string($diario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($diario)), __LINE__);
        }
        if (is_null($diario) || (is_array($diario) && empty($diario))) {
            unset($this->Diario);
        } else {
            $this->Diario = $diario;
        }
        return $this;
    }
    /**
     * Get DifArredondamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamento()
    {
        return isset($this->DifArredondamento) ? $this->DifArredondamento : null;
    }
    /**
     * Set DifArredondamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamento
     * @return \StructType\CabLiqERP
     */
    public function setDifArredondamento($difArredondamento = null)
    {
        if (is_null($difArredondamento) || (is_array($difArredondamento) && empty($difArredondamento))) {
            unset($this->DifArredondamento);
        } else {
            $this->DifArredondamento = $difArredondamento;
        }
        return $this;
    }
    /**
     * Get DifArredondamentoMAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamentoMAlt()
    {
        return isset($this->DifArredondamentoMAlt) ? $this->DifArredondamentoMAlt : null;
    }
    /**
     * Set DifArredondamentoMAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamentoMAlt
     * @return \StructType\CabLiqERP
     */
    public function setDifArredondamentoMAlt($difArredondamentoMAlt = null)
    {
        if (is_null($difArredondamentoMAlt) || (is_array($difArredondamentoMAlt) && empty($difArredondamentoMAlt))) {
            unset($this->DifArredondamentoMAlt);
        } else {
            $this->DifArredondamentoMAlt = $difArredondamentoMAlt;
        }
        return $this;
    }
    /**
     * Get DifCambio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifCambio()
    {
        return isset($this->DifCambio) ? $this->DifCambio : null;
    }
    /**
     * Set DifCambio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difCambio
     * @return \StructType\CabLiqERP
     */
    public function setDifCambio($difCambio = null)
    {
        if (is_null($difCambio) || (is_array($difCambio) && empty($difCambio))) {
            unset($this->DifCambio);
        } else {
            $this->DifCambio = $difCambio;
        }
        return $this;
    }
    /**
     * Get DifCambioMAlt value
     * @return float|null
     */
    public function getDifCambioMAlt()
    {
        return $this->DifCambioMAlt;
    }
    /**
     * Set DifCambioMAlt value
     * @param float $difCambioMAlt
     * @return \StructType\CabLiqERP
     */
    public function setDifCambioMAlt($difCambioMAlt = null)
    {
        $this->DifCambioMAlt = $difCambioMAlt;
        return $this;
    }
    /**
     * Get DocLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocLiq()
    {
        return isset($this->DocLiq) ? $this->DocLiq : null;
    }
    /**
     * Set DocLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $docLiq
     * @return \StructType\CabLiqERP
     */
    public function setDocLiq($docLiq = null)
    {
        // validation for constraint: string
        if (!is_null($docLiq) && !is_string($docLiq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docLiq)), __LINE__);
        }
        if (is_null($docLiq) || (is_array($docLiq) && empty($docLiq))) {
            unset($this->DocLiq);
        } else {
            $this->DocLiq = $docLiq;
        }
        return $this;
    }
    /**
     * Get EfectuaRegularizacoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEfectuaRegularizacoes()
    {
        return isset($this->EfectuaRegularizacoes) ? $this->EfectuaRegularizacoes : null;
    }
    /**
     * Set EfectuaRegularizacoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $efectuaRegularizacoes
     * @return \StructType\CabLiqERP
     */
    public function setEfectuaRegularizacoes($efectuaRegularizacoes = null)
    {
        // validation for constraint: boolean
        if (!is_null($efectuaRegularizacoes) && !is_bool($efectuaRegularizacoes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($efectuaRegularizacoes)), __LINE__);
        }
        if (is_null($efectuaRegularizacoes) || (is_array($efectuaRegularizacoes) && empty($efectuaRegularizacoes))) {
            unset($this->EfectuaRegularizacoes);
        } else {
            $this->EfectuaRegularizacoes = $efectuaRegularizacoes;
        }
        return $this;
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\CabLiqERP
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get EntidadeDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidadeDestino()
    {
        return isset($this->EntidadeDestino) ? $this->EntidadeDestino : null;
    }
    /**
     * Set EntidadeDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidadeDestino
     * @return \StructType\CabLiqERP
     */
    public function setEntidadeDestino($entidadeDestino = null)
    {
        // validation for constraint: string
        if (!is_null($entidadeDestino) && !is_string($entidadeDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidadeDestino)), __LINE__);
        }
        if (is_null($entidadeDestino) || (is_array($entidadeDestino) && empty($entidadeDestino))) {
            unset($this->EntidadeDestino);
        } else {
            $this->EntidadeDestino = $entidadeDestino;
        }
        return $this;
    }
    /**
     * Get EntidadeFinanceira value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidadeFinanceira()
    {
        return isset($this->EntidadeFinanceira) ? $this->EntidadeFinanceira : null;
    }
    /**
     * Set EntidadeFinanceira value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidadeFinanceira
     * @return \StructType\CabLiqERP
     */
    public function setEntidadeFinanceira($entidadeFinanceira = null)
    {
        // validation for constraint: string
        if (!is_null($entidadeFinanceira) && !is_string($entidadeFinanceira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidadeFinanceira)), __LINE__);
        }
        if (is_null($entidadeFinanceira) || (is_array($entidadeFinanceira) && empty($entidadeFinanceira))) {
            unset($this->EntidadeFinanceira);
        } else {
            $this->EntidadeFinanceira = $entidadeFinanceira;
        }
        return $this;
    }
    /**
     * Get EstadoCBLEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEstadoCBLEntidade()
    {
        return isset($this->EstadoCBLEntidade) ? $this->EstadoCBLEntidade : null;
    }
    /**
     * Set EstadoCBLEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $estadoCBLEntidade
     * @return \StructType\CabLiqERP
     */
    public function setEstadoCBLEntidade($estadoCBLEntidade = null)
    {
        // validation for constraint: int
        if (!is_null($estadoCBLEntidade) && !is_numeric($estadoCBLEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($estadoCBLEntidade)), __LINE__);
        }
        if (is_null($estadoCBLEntidade) || (is_array($estadoCBLEntidade) && empty($estadoCBLEntidade))) {
            unset($this->EstadoCBLEntidade);
        } else {
            $this->EstadoCBLEntidade = $estadoCBLEntidade;
        }
        return $this;
    }
    /**
     * Get EstadoDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoDestino()
    {
        return isset($this->EstadoDestino) ? $this->EstadoDestino : null;
    }
    /**
     * Set EstadoDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoDestino
     * @return \StructType\CabLiqERP
     */
    public function setEstadoDestino($estadoDestino = null)
    {
        // validation for constraint: string
        if (!is_null($estadoDestino) && !is_string($estadoDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoDestino)), __LINE__);
        }
        if (is_null($estadoDestino) || (is_array($estadoDestino) && empty($estadoDestino))) {
            unset($this->EstadoDestino);
        } else {
            $this->EstadoDestino = $estadoDestino;
        }
        return $this;
    }
    /**
     * Get Estorno value
     * @return bool|null
     */
    public function getEstorno()
    {
        return $this->Estorno;
    }
    /**
     * Set Estorno value
     * @param bool $estorno
     * @return \StructType\CabLiqERP
     */
    public function setEstorno($estorno = null)
    {
        // validation for constraint: boolean
        if (!is_null($estorno) && !is_bool($estorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estorno)), __LINE__);
        }
        $this->Estorno = $estorno;
        return $this;
    }
    /**
     * Get Filial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilial()
    {
        return isset($this->Filial) ? $this->Filial : null;
    }
    /**
     * Set Filial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filial
     * @return \StructType\CabLiqERP
     */
    public function setFilial($filial = null)
    {
        // validation for constraint: string
        if (!is_null($filial) && !is_string($filial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filial)), __LINE__);
        }
        if (is_null($filial) || (is_array($filial) && empty($filial))) {
            unset($this->Filial);
        } else {
            $this->Filial = $filial;
        }
        return $this;
    }
    /**
     * Get FolhaVenc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFolhaVenc()
    {
        return isset($this->FolhaVenc) ? $this->FolhaVenc : null;
    }
    /**
     * Set FolhaVenc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $folhaVenc
     * @return \StructType\CabLiqERP
     */
    public function setFolhaVenc($folhaVenc = null)
    {
        // validation for constraint: int
        if (!is_null($folhaVenc) && !is_numeric($folhaVenc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($folhaVenc)), __LINE__);
        }
        if (is_null($folhaVenc) || (is_array($folhaVenc) && empty($folhaVenc))) {
            unset($this->FolhaVenc);
        } else {
            $this->FolhaVenc = $folhaVenc;
        }
        return $this;
    }
    /**
     * Get FormatoMagnetico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormatoMagnetico()
    {
        return isset($this->FormatoMagnetico) ? $this->FormatoMagnetico : null;
    }
    /**
     * Set FormatoMagnetico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formatoMagnetico
     * @return \StructType\CabLiqERP
     */
    public function setFormatoMagnetico($formatoMagnetico = null)
    {
        // validation for constraint: string
        if (!is_null($formatoMagnetico) && !is_string($formatoMagnetico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formatoMagnetico)), __LINE__);
        }
        if (is_null($formatoMagnetico) || (is_array($formatoMagnetico) && empty($formatoMagnetico))) {
            unset($this->FormatoMagnetico);
        } else {
            $this->FormatoMagnetico = $formatoMagnetico;
        }
        return $this;
    }
    /**
     * Get GeradoMagnetico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeradoMagnetico()
    {
        return isset($this->GeradoMagnetico) ? $this->GeradoMagnetico : null;
    }
    /**
     * Set GeradoMagnetico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geradoMagnetico
     * @return \StructType\CabLiqERP
     */
    public function setGeradoMagnetico($geradoMagnetico = null)
    {
        // validation for constraint: boolean
        if (!is_null($geradoMagnetico) && !is_bool($geradoMagnetico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($geradoMagnetico)), __LINE__);
        }
        if (is_null($geradoMagnetico) || (is_array($geradoMagnetico) && empty($geradoMagnetico))) {
            unset($this->GeradoMagnetico);
        } else {
            $this->GeradoMagnetico = $geradoMagnetico;
        }
        return $this;
    }
    /**
     * Get IDDocB2B value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDDocB2B()
    {
        return isset($this->IDDocB2B) ? $this->IDDocB2B : null;
    }
    /**
     * Set IDDocB2B value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDDocB2B
     * @return \StructType\CabLiqERP
     */
    public function setIDDocB2B($iDDocB2B = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDDocB2B) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDDocB2B)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDDocB2B, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDocB2B) && !is_string($iDDocB2B)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDocB2B)), __LINE__);
        }
        if (is_null($iDDocB2B) || (is_array($iDDocB2B) && empty($iDDocB2B))) {
            unset($this->IDDocB2B);
        } else {
            $this->IDDocB2B = $iDDocB2B;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CabLiqERP
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdCabecMovCbl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCabecMovCbl()
    {
        return isset($this->IdCabecMovCbl) ? $this->IdCabecMovCbl : null;
    }
    /**
     * Set IdCabecMovCbl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCabecMovCbl
     * @return \StructType\CabLiqERP
     */
    public function setIdCabecMovCbl($idCabecMovCbl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCabecMovCbl) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCabecMovCbl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCabecMovCbl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCabecMovCbl) && !is_string($idCabecMovCbl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCabecMovCbl)), __LINE__);
        }
        if (is_null($idCabecMovCbl) || (is_array($idCabecMovCbl) && empty($idCabecMovCbl))) {
            unset($this->IdCabecMovCbl);
        } else {
            $this->IdCabecMovCbl = $idCabecMovCbl;
        }
        return $this;
    }
    /**
     * Get IdCessao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCessao()
    {
        return isset($this->IdCessao) ? $this->IdCessao : null;
    }
    /**
     * Set IdCessao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCessao
     * @return \StructType\CabLiqERP
     */
    public function setIdCessao($idCessao = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCessao) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCessao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCessao, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCessao) && !is_string($idCessao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCessao)), __LINE__);
        }
        if (is_null($idCessao) || (is_array($idCessao) && empty($idCessao))) {
            unset($this->IdCessao);
        } else {
            $this->IdCessao = $idCessao;
        }
        return $this;
    }
    /**
     * Get IdGDOC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdGDOC()
    {
        return isset($this->IdGDOC) ? $this->IdGDOC : null;
    }
    /**
     * Set IdGDOC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idGDOC
     * @return \StructType\CabLiqERP
     */
    public function setIdGDOC($idGDOC = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idGDOC) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idGDOC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idGDOC, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idGDOC) && !is_string($idGDOC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idGDOC)), __LINE__);
        }
        if (is_null($idGDOC) || (is_array($idGDOC) && empty($idGDOC))) {
            unset($this->IdGDOC);
        } else {
            $this->IdGDOC = $idGDOC;
        }
        return $this;
    }
    /**
     * Get IdGuiaReceita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdGuiaReceita()
    {
        return isset($this->IdGuiaReceita) ? $this->IdGuiaReceita : null;
    }
    /**
     * Set IdGuiaReceita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idGuiaReceita
     * @return \StructType\CabLiqERP
     */
    public function setIdGuiaReceita($idGuiaReceita = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idGuiaReceita) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idGuiaReceita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idGuiaReceita, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idGuiaReceita) && !is_string($idGuiaReceita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idGuiaReceita)), __LINE__);
        }
        if (is_null($idGuiaReceita) || (is_array($idGuiaReceita) && empty($idGuiaReceita))) {
            unset($this->IdGuiaReceita);
        } else {
            $this->IdGuiaReceita = $idGuiaReceita;
        }
        return $this;
    }
    /**
     * Get ImpostoSelo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getImpostoSelo()
    {
        return isset($this->ImpostoSelo) ? $this->ImpostoSelo : null;
    }
    /**
     * Set ImpostoSelo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $impostoSelo
     * @return \StructType\CabLiqERP
     */
    public function setImpostoSelo($impostoSelo = null)
    {
        if (is_null($impostoSelo) || (is_array($impostoSelo) && empty($impostoSelo))) {
            unset($this->ImpostoSelo);
        } else {
            $this->ImpostoSelo = $impostoSelo;
        }
        return $this;
    }
    /**
     * Get ImpostoSeloLivrancas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getImpostoSeloLivrancas()
    {
        return isset($this->ImpostoSeloLivrancas) ? $this->ImpostoSeloLivrancas : null;
    }
    /**
     * Set ImpostoSeloLivrancas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $impostoSeloLivrancas
     * @return \StructType\CabLiqERP
     */
    public function setImpostoSeloLivrancas($impostoSeloLivrancas = null)
    {
        if (is_null($impostoSeloLivrancas) || (is_array($impostoSeloLivrancas) && empty($impostoSeloLivrancas))) {
            unset($this->ImpostoSeloLivrancas);
        } else {
            $this->ImpostoSeloLivrancas = $impostoSeloLivrancas;
        }
        return $this;
    }
    /**
     * Get Impresso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getImpresso()
    {
        return isset($this->Impresso) ? $this->Impresso : null;
    }
    /**
     * Set Impresso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $impresso
     * @return \StructType\CabLiqERP
     */
    public function setImpresso($impresso = null)
    {
        // validation for constraint: boolean
        if (!is_null($impresso) && !is_bool($impresso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($impresso)), __LINE__);
        }
        if (is_null($impresso) || (is_array($impresso) && empty($impresso))) {
            unset($this->Impresso);
        } else {
            $this->Impresso = $impresso;
        }
        return $this;
    }
    /**
     * Get Linhas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLinhasLiqERP|null
     */
    public function getLinhas()
    {
        return isset($this->Linhas) ? $this->Linhas : null;
    }
    /**
     * Set Linhas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLinhasLiqERP $linhas
     * @return \StructType\CabLiqERP
     */
    public function setLinhas(\ArrayType\ArrayOfLinhasLiqERP $linhas = null)
    {
        if (is_null($linhas) || (is_array($linhas) && empty($linhas))) {
            unset($this->Linhas);
        } else {
            $this->Linhas = $linhas;
        }
        return $this;
    }
    /**
     * Get MantemEntidadePendentes value
     * @return bool|null
     */
    public function getMantemEntidadePendentes()
    {
        return $this->MantemEntidadePendentes;
    }
    /**
     * Set MantemEntidadePendentes value
     * @param bool $mantemEntidadePendentes
     * @return \StructType\CabLiqERP
     */
    public function setMantemEntidadePendentes($mantemEntidadePendentes = null)
    {
        // validation for constraint: boolean
        if (!is_null($mantemEntidadePendentes) && !is_bool($mantemEntidadePendentes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mantemEntidadePendentes)), __LINE__);
        }
        $this->MantemEntidadePendentes = $mantemEntidadePendentes;
        return $this;
    }
    /**
     * Get ModoPag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModoPag()
    {
        return isset($this->ModoPag) ? $this->ModoPag : null;
    }
    /**
     * Set ModoPag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modoPag
     * @return \StructType\CabLiqERP
     */
    public function setModoPag($modoPag = null)
    {
        // validation for constraint: string
        if (!is_null($modoPag) && !is_string($modoPag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modoPag)), __LINE__);
        }
        if (is_null($modoPag) || (is_array($modoPag) && empty($modoPag))) {
            unset($this->ModoPag);
        } else {
            $this->ModoPag = $modoPag;
        }
        return $this;
    }
    /**
     * Get Moeda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoeda()
    {
        return isset($this->Moeda) ? $this->Moeda : null;
    }
    /**
     * Set Moeda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moeda
     * @return \StructType\CabLiqERP
     */
    public function setMoeda($moeda = null)
    {
        // validation for constraint: string
        if (!is_null($moeda) && !is_string($moeda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moeda)), __LINE__);
        }
        if (is_null($moeda) || (is_array($moeda) && empty($moeda))) {
            unset($this->Moeda);
        } else {
            $this->Moeda = $moeda;
        }
        return $this;
    }
    /**
     * Get MoedaDaUEM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMoedaDaUEM()
    {
        return isset($this->MoedaDaUEM) ? $this->MoedaDaUEM : null;
    }
    /**
     * Set MoedaDaUEM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $moedaDaUEM
     * @return \StructType\CabLiqERP
     */
    public function setMoedaDaUEM($moedaDaUEM = null)
    {
        // validation for constraint: boolean
        if (!is_null($moedaDaUEM) && !is_bool($moedaDaUEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moedaDaUEM)), __LINE__);
        }
        if (is_null($moedaDaUEM) || (is_array($moedaDaUEM) && empty($moedaDaUEM))) {
            unset($this->MoedaDaUEM);
        } else {
            $this->MoedaDaUEM = $moedaDaUEM;
        }
        return $this;
    }
    /**
     * Get MoradaAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoradaAlt()
    {
        return isset($this->MoradaAlt) ? $this->MoradaAlt : null;
    }
    /**
     * Set MoradaAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moradaAlt
     * @return \StructType\CabLiqERP
     */
    public function setMoradaAlt($moradaAlt = null)
    {
        // validation for constraint: string
        if (!is_null($moradaAlt) && !is_string($moradaAlt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moradaAlt)), __LINE__);
        }
        if (is_null($moradaAlt) || (is_array($moradaAlt) && empty($moradaAlt))) {
            unset($this->MoradaAlt);
        } else {
            $this->MoradaAlt = $moradaAlt;
        }
        return $this;
    }
    /**
     * Get MotivoEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoEstorno()
    {
        return isset($this->MotivoEstorno) ? $this->MotivoEstorno : null;
    }
    /**
     * Set MotivoEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoEstorno
     * @return \StructType\CabLiqERP
     */
    public function setMotivoEstorno($motivoEstorno = null)
    {
        // validation for constraint: string
        if (!is_null($motivoEstorno) && !is_string($motivoEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivoEstorno)), __LINE__);
        }
        if (is_null($motivoEstorno) || (is_array($motivoEstorno) && empty($motivoEstorno))) {
            unset($this->MotivoEstorno);
        } else {
            $this->MotivoEstorno = $motivoEstorno;
        }
        return $this;
    }
    /**
     * Get MovContab value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMovContab()
    {
        return isset($this->MovContab) ? $this->MovContab : null;
    }
    /**
     * Set MovContab value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $movContab
     * @return \StructType\CabLiqERP
     */
    public function setMovContab($movContab = null)
    {
        // validation for constraint: int
        if (!is_null($movContab) && !is_numeric($movContab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($movContab)), __LINE__);
        }
        if (is_null($movContab) || (is_array($movContab) && empty($movContab))) {
            unset($this->MovContab);
        } else {
            $this->MovContab = $movContab;
        }
        return $this;
    }
    /**
     * Get MovGesconta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMovGesconta()
    {
        return isset($this->MovGesconta) ? $this->MovGesconta : null;
    }
    /**
     * Set MovGesconta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $movGesconta
     * @return \StructType\CabLiqERP
     */
    public function setMovGesconta($movGesconta = null)
    {
        // validation for constraint: boolean
        if (!is_null($movGesconta) && !is_bool($movGesconta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($movGesconta)), __LINE__);
        }
        if (is_null($movGesconta) || (is_array($movGesconta) && empty($movGesconta))) {
            unset($this->MovGesconta);
        } else {
            $this->MovGesconta = $movGesconta;
        }
        return $this;
    }
    /**
     * Get NumDiario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumDiario()
    {
        return isset($this->NumDiario) ? $this->NumDiario : null;
    }
    /**
     * Set NumDiario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numDiario
     * @return \StructType\CabLiqERP
     */
    public function setNumDiario($numDiario = null)
    {
        // validation for constraint: int
        if (!is_null($numDiario) && !is_numeric($numDiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDiario)), __LINE__);
        }
        if (is_null($numDiario) || (is_array($numDiario) && empty($numDiario))) {
            unset($this->NumDiario);
        } else {
            $this->NumDiario = $numDiario;
        }
        return $this;
    }
    /**
     * Get NumDoc value
     * @return int|null
     */
    public function getNumDoc()
    {
        return $this->NumDoc;
    }
    /**
     * Set NumDoc value
     * @param int $numDoc
     * @return \StructType\CabLiqERP
     */
    public function setNumDoc($numDoc = null)
    {
        // validation for constraint: int
        if (!is_null($numDoc) && !is_numeric($numDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDoc)), __LINE__);
        }
        $this->NumDoc = $numDoc;
        return $this;
    }
    /**
     * Get NumRemessa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumRemessa()
    {
        return isset($this->NumRemessa) ? $this->NumRemessa : null;
    }
    /**
     * Set NumRemessa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numRemessa
     * @return \StructType\CabLiqERP
     */
    public function setNumRemessa($numRemessa = null)
    {
        // validation for constraint: int
        if (!is_null($numRemessa) && !is_numeric($numRemessa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numRemessa)), __LINE__);
        }
        if (is_null($numRemessa) || (is_array($numRemessa) && empty($numRemessa))) {
            unset($this->NumRemessa);
        } else {
            $this->NumRemessa = $numRemessa;
        }
        return $this;
    }
    /**
     * Get ObraId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObraId()
    {
        return isset($this->ObraId) ? $this->ObraId : null;
    }
    /**
     * Set ObraId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $obraId
     * @return \StructType\CabLiqERP
     */
    public function setObraId($obraId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($obraId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $obraId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($obraId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($obraId) && !is_string($obraId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obraId)), __LINE__);
        }
        if (is_null($obraId) || (is_array($obraId) && empty($obraId))) {
            unset($this->ObraId);
        } else {
            $this->ObraId = $obraId;
        }
        return $this;
    }
    /**
     * Get Observacoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacoes()
    {
        return isset($this->Observacoes) ? $this->Observacoes : null;
    }
    /**
     * Set Observacoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacoes
     * @return \StructType\CabLiqERP
     */
    public function setObservacoes($observacoes = null)
    {
        // validation for constraint: string
        if (!is_null($observacoes) && !is_string($observacoes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($observacoes)), __LINE__);
        }
        if (is_null($observacoes) || (is_array($observacoes) && empty($observacoes))) {
            unset($this->Observacoes);
        } else {
            $this->Observacoes = $observacoes;
        }
        return $this;
    }
    /**
     * Get Percentagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPercentagem()
    {
        return isset($this->Percentagem) ? $this->Percentagem : null;
    }
    /**
     * Set Percentagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $percentagem
     * @return \StructType\CabLiqERP
     */
    public function setPercentagem($percentagem = null)
    {
        // validation for constraint: boolean
        if (!is_null($percentagem) && !is_bool($percentagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($percentagem)), __LINE__);
        }
        if (is_null($percentagem) || (is_array($percentagem) && empty($percentagem))) {
            unset($this->Percentagem);
        } else {
            $this->Percentagem = $percentagem;
        }
        return $this;
    }
    /**
     * Get Plafond value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlafond()
    {
        return isset($this->Plafond) ? $this->Plafond : null;
    }
    /**
     * Set Plafond value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $plafond
     * @return \StructType\CabLiqERP
     */
    public function setPlafond($plafond = null)
    {
        if (is_null($plafond) || (is_array($plafond) && empty($plafond))) {
            unset($this->Plafond);
        } else {
            $this->Plafond = $plafond;
        }
        return $this;
    }
    /**
     * Get Portes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPortes()
    {
        return isset($this->Portes) ? $this->Portes : null;
    }
    /**
     * Set Portes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $portes
     * @return \StructType\CabLiqERP
     */
    public function setPortes($portes = null)
    {
        if (is_null($portes) || (is_array($portes) && empty($portes))) {
            unset($this->Portes);
        } else {
            $this->Portes = $portes;
        }
        return $this;
    }
    /**
     * Get Postecipado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPostecipado()
    {
        return isset($this->Postecipado) ? $this->Postecipado : null;
    }
    /**
     * Set Postecipado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $postecipado
     * @return \StructType\CabLiqERP
     */
    public function setPostecipado($postecipado = null)
    {
        // validation for constraint: boolean
        if (!is_null($postecipado) && !is_bool($postecipado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($postecipado)), __LINE__);
        }
        if (is_null($postecipado) || (is_array($postecipado) && empty($postecipado))) {
            unset($this->Postecipado);
        } else {
            $this->Postecipado = $postecipado;
        }
        return $this;
    }
    /**
     * Get Posto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosto()
    {
        return isset($this->Posto) ? $this->Posto : null;
    }
    /**
     * Set Posto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $posto
     * @return \StructType\CabLiqERP
     */
    public function setPosto($posto = null)
    {
        // validation for constraint: string
        if (!is_null($posto) && !is_string($posto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($posto)), __LINE__);
        }
        if (is_null($posto) || (is_array($posto) && empty($posto))) {
            unset($this->Posto);
        } else {
            $this->Posto = $posto;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\CabLiqERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get SAFTTipoDocumento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSAFTTipoDocumento()
    {
        return isset($this->SAFTTipoDocumento) ? $this->SAFTTipoDocumento : null;
    }
    /**
     * Set SAFTTipoDocumento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sAFTTipoDocumento
     * @return \StructType\CabLiqERP
     */
    public function setSAFTTipoDocumento($sAFTTipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($sAFTTipoDocumento) && !is_string($sAFTTipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sAFTTipoDocumento)), __LINE__);
        }
        if (is_null($sAFTTipoDocumento) || (is_array($sAFTTipoDocumento) && empty($sAFTTipoDocumento))) {
            unset($this->SAFTTipoDocumento);
        } else {
            $this->SAFTTipoDocumento = $sAFTTipoDocumento;
        }
        return $this;
    }
    /**
     * Get Serie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerie()
    {
        return isset($this->Serie) ? $this->Serie : null;
    }
    /**
     * Set Serie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serie
     * @return \StructType\CabLiqERP
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serie)), __LINE__);
        }
        if (is_null($serie) || (is_array($serie) && empty($serie))) {
            unset($this->Serie);
        } else {
            $this->Serie = $serie;
        }
        return $this;
    }
    /**
     * Get TaxaJuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaJuro()
    {
        return isset($this->TaxaJuro) ? $this->TaxaJuro : null;
    }
    /**
     * Set TaxaJuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaJuro
     * @return \StructType\CabLiqERP
     */
    public function setTaxaJuro($taxaJuro = null)
    {
        if (is_null($taxaJuro) || (is_array($taxaJuro) && empty($taxaJuro))) {
            unset($this->TaxaJuro);
        } else {
            $this->TaxaJuro = $taxaJuro;
        }
        return $this;
    }
    /**
     * Get TipoConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoConta()
    {
        return isset($this->TipoConta) ? $this->TipoConta : null;
    }
    /**
     * Set TipoConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoConta
     * @return \StructType\CabLiqERP
     */
    public function setTipoConta($tipoConta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoConta) && !is_string($tipoConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoConta)), __LINE__);
        }
        if (is_null($tipoConta) || (is_array($tipoConta) && empty($tipoConta))) {
            unset($this->TipoConta);
        } else {
            $this->TipoConta = $tipoConta;
        }
        return $this;
    }
    /**
     * Get TipoContaDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoContaDestino()
    {
        return isset($this->TipoContaDestino) ? $this->TipoContaDestino : null;
    }
    /**
     * Set TipoContaDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoContaDestino
     * @return \StructType\CabLiqERP
     */
    public function setTipoContaDestino($tipoContaDestino = null)
    {
        // validation for constraint: string
        if (!is_null($tipoContaDestino) && !is_string($tipoContaDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoContaDestino)), __LINE__);
        }
        if (is_null($tipoContaDestino) || (is_array($tipoContaDestino) && empty($tipoContaDestino))) {
            unset($this->TipoContaDestino);
        } else {
            $this->TipoContaDestino = $tipoContaDestino;
        }
        return $this;
    }
    /**
     * Get TipoDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDoc()
    {
        return isset($this->TipoDoc) ? $this->TipoDoc : null;
    }
    /**
     * Set TipoDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDoc
     * @return \StructType\CabLiqERP
     */
    public function setTipoDoc($tipoDoc = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDoc) && !is_string($tipoDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDoc)), __LINE__);
        }
        if (is_null($tipoDoc) || (is_array($tipoDoc) && empty($tipoDoc))) {
            unset($this->TipoDoc);
        } else {
            $this->TipoDoc = $tipoDoc;
        }
        return $this;
    }
    /**
     * Get TipoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidade()
    {
        return isset($this->TipoEntidade) ? $this->TipoEntidade : null;
    }
    /**
     * Set TipoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidade
     * @return \StructType\CabLiqERP
     */
    public function setTipoEntidade($tipoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidade) && !is_string($tipoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidade)), __LINE__);
        }
        if (is_null($tipoEntidade) || (is_array($tipoEntidade) && empty($tipoEntidade))) {
            unset($this->TipoEntidade);
        } else {
            $this->TipoEntidade = $tipoEntidade;
        }
        return $this;
    }
    /**
     * Get TipoEntidadeDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidadeDestino()
    {
        return isset($this->TipoEntidadeDestino) ? $this->TipoEntidadeDestino : null;
    }
    /**
     * Set TipoEntidadeDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidadeDestino
     * @return \StructType\CabLiqERP
     */
    public function setTipoEntidadeDestino($tipoEntidadeDestino = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidadeDestino) && !is_string($tipoEntidadeDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidadeDestino)), __LINE__);
        }
        if (is_null($tipoEntidadeDestino) || (is_array($tipoEntidadeDestino) && empty($tipoEntidadeDestino))) {
            unset($this->TipoEntidadeDestino);
        } else {
            $this->TipoEntidadeDestino = $tipoEntidadeDestino;
        }
        return $this;
    }
    /**
     * Get TipoLancamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoLancamento()
    {
        return isset($this->TipoLancamento) ? $this->TipoLancamento : null;
    }
    /**
     * Set TipoLancamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoLancamento
     * @return \StructType\CabLiqERP
     */
    public function setTipoLancamento($tipoLancamento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoLancamento) && !is_string($tipoLancamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoLancamento)), __LINE__);
        }
        if (is_null($tipoLancamento) || (is_array($tipoLancamento) && empty($tipoLancamento))) {
            unset($this->TipoLancamento);
        } else {
            $this->TipoLancamento = $tipoLancamento;
        }
        return $this;
    }
    /**
     * Get TransferenciaEstado value
     * @return bool|null
     */
    public function getTransferenciaEstado()
    {
        return $this->TransferenciaEstado;
    }
    /**
     * Set TransferenciaEstado value
     * @param bool $transferenciaEstado
     * @return \StructType\CabLiqERP
     */
    public function setTransferenciaEstado($transferenciaEstado = null)
    {
        // validation for constraint: boolean
        if (!is_null($transferenciaEstado) && !is_bool($transferenciaEstado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($transferenciaEstado)), __LINE__);
        }
        $this->TransferenciaEstado = $transferenciaEstado;
        return $this;
    }
    /**
     * Get Utilizador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUtilizador()
    {
        return isset($this->Utilizador) ? $this->Utilizador : null;
    }
    /**
     * Set Utilizador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $utilizador
     * @return \StructType\CabLiqERP
     */
    public function setUtilizador($utilizador = null)
    {
        // validation for constraint: string
        if (!is_null($utilizador) && !is_string($utilizador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($utilizador)), __LINE__);
        }
        if (is_null($utilizador) || (is_array($utilizador) && empty($utilizador))) {
            unset($this->Utilizador);
        } else {
            $this->Utilizador = $utilizador;
        }
        return $this;
    }
    /**
     * Get ValorAmortizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorAmortizacao()
    {
        return isset($this->ValorAmortizacao) ? $this->ValorAmortizacao : null;
    }
    /**
     * Set ValorAmortizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorAmortizacao
     * @return \StructType\CabLiqERP
     */
    public function setValorAmortizacao($valorAmortizacao = null)
    {
        if (is_null($valorAmortizacao) || (is_array($valorAmortizacao) && empty($valorAmortizacao))) {
            unset($this->ValorAmortizacao);
        } else {
            $this->ValorAmortizacao = $valorAmortizacao;
        }
        return $this;
    }
    /**
     * Get ValorDesconto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorDesconto()
    {
        return isset($this->ValorDesconto) ? $this->ValorDesconto : null;
    }
    /**
     * Set ValorDesconto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorDesconto
     * @return \StructType\CabLiqERP
     */
    public function setValorDesconto($valorDesconto = null)
    {
        if (is_null($valorDesconto) || (is_array($valorDesconto) && empty($valorDesconto))) {
            unset($this->ValorDesconto);
        } else {
            $this->ValorDesconto = $valorDesconto;
        }
        return $this;
    }
    /**
     * Get ValorRec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRec()
    {
        return isset($this->ValorRec) ? $this->ValorRec : null;
    }
    /**
     * Set ValorRec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRec
     * @return \StructType\CabLiqERP
     */
    public function setValorRec($valorRec = null)
    {
        if (is_null($valorRec) || (is_array($valorRec) && empty($valorRec))) {
            unset($this->ValorRec);
        } else {
            $this->ValorRec = $valorRec;
        }
        return $this;
    }
    /**
     * Get ValorRetencao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencao()
    {
        return isset($this->ValorRetencao) ? $this->ValorRetencao : null;
    }
    /**
     * Set ValorRetencao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencao
     * @return \StructType\CabLiqERP
     */
    public function setValorRetencao($valorRetencao = null)
    {
        if (is_null($valorRetencao) || (is_array($valorRetencao) && empty($valorRetencao))) {
            unset($this->ValorRetencao);
        } else {
            $this->ValorRetencao = $valorRetencao;
        }
        return $this;
    }
    /**
     * Get ValorRetencaoGarantia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoGarantia()
    {
        return isset($this->ValorRetencaoGarantia) ? $this->ValorRetencaoGarantia : null;
    }
    /**
     * Set ValorRetencaoGarantia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoGarantia
     * @return \StructType\CabLiqERP
     */
    public function setValorRetencaoGarantia($valorRetencaoGarantia = null)
    {
        if (is_null($valorRetencaoGarantia) || (is_array($valorRetencaoGarantia) && empty($valorRetencaoGarantia))) {
            unset($this->ValorRetencaoGarantia);
        } else {
            $this->ValorRetencaoGarantia = $valorRetencaoGarantia;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\CabLiqERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Get WBSItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBSItem()
    {
        return isset($this->WBSItem) ? $this->WBSItem : null;
    }
    /**
     * Set WBSItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBSItem
     * @return \StructType\CabLiqERP
     */
    public function setWBSItem($wBSItem = null)
    {
        // validation for constraint: string
        if (!is_null($wBSItem) && !is_string($wBSItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wBSItem)), __LINE__);
        }
        if (is_null($wBSItem) || (is_array($wBSItem) && empty($wBSItem))) {
            unset($this->WBSItem);
        } else {
            $this->WBSItem = $wBSItem;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabLiqERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
