<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtigoArmazemERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArtigoArmazemERP
 * @subpackage Structs
 */
class ArtigoArmazemERP extends AbstractStructBase
{
    /**
     * The Armazem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Armazem;
    /**
     * The Artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Artigo;
    /**
     * The BloqueadoInventario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BloqueadoInventario;
    /**
     * The DataUltimaContagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataUltimaContagem;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The Existencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Existencia;
    /**
     * The IdArtigoDim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdArtigoDim;
    /**
     * The Localizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localizacao;
    /**
     * The LocalizacaoArmazem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalizacaoArmazem;
    /**
     * The Lote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lote;
    /**
     * The PCMedio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PCMedio;
    /**
     * The PCUltimo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PCUltimo;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QtReservada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QtReservada;
    /**
     * The QtTransito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $QtTransito;
    /**
     * The StkActual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StkActual;
    /**
     * The UltimaContagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UltimaContagem;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ArtigoArmazemERP
     * @uses ArtigoArmazemERP::setArmazem()
     * @uses ArtigoArmazemERP::setArtigo()
     * @uses ArtigoArmazemERP::setBloqueadoInventario()
     * @uses ArtigoArmazemERP::setDataUltimaContagem()
     * @uses ArtigoArmazemERP::setEstado()
     * @uses ArtigoArmazemERP::setExistencia()
     * @uses ArtigoArmazemERP::setIdArtigoDim()
     * @uses ArtigoArmazemERP::setLocalizacao()
     * @uses ArtigoArmazemERP::setLocalizacaoArmazem()
     * @uses ArtigoArmazemERP::setLote()
     * @uses ArtigoArmazemERP::setPCMedio()
     * @uses ArtigoArmazemERP::setPCUltimo()
     * @uses ArtigoArmazemERP::setProtegida()
     * @uses ArtigoArmazemERP::setQtReservada()
     * @uses ArtigoArmazemERP::setQtTransito()
     * @uses ArtigoArmazemERP::setStkActual()
     * @uses ArtigoArmazemERP::setUltimaContagem()
     * @uses ArtigoArmazemERP::setVersaoUltAct()
     * @param string $armazem
     * @param string $artigo
     * @param bool $bloqueadoInventario
     * @param string $dataUltimaContagem
     * @param string $estado
     * @param float $existencia
     * @param string $idArtigoDim
     * @param string $localizacao
     * @param string $localizacaoArmazem
     * @param string $lote
     * @param float $pCMedio
     * @param float $pCUltimo
     * @param bool $protegida
     * @param float $qtReservada
     * @param float $qtTransito
     * @param float $stkActual
     * @param float $ultimaContagem
     * @param string $versaoUltAct
     */
    public function __construct($armazem = null, $artigo = null, $bloqueadoInventario = null, $dataUltimaContagem = null, $estado = null, $existencia = null, $idArtigoDim = null, $localizacao = null, $localizacaoArmazem = null, $lote = null, $pCMedio = null, $pCUltimo = null, $protegida = null, $qtReservada = null, $qtTransito = null, $stkActual = null, $ultimaContagem = null, $versaoUltAct = null)
    {
        $this
            ->setArmazem($armazem)
            ->setArtigo($artigo)
            ->setBloqueadoInventario($bloqueadoInventario)
            ->setDataUltimaContagem($dataUltimaContagem)
            ->setEstado($estado)
            ->setExistencia($existencia)
            ->setIdArtigoDim($idArtigoDim)
            ->setLocalizacao($localizacao)
            ->setLocalizacaoArmazem($localizacaoArmazem)
            ->setLote($lote)
            ->setPCMedio($pCMedio)
            ->setPCUltimo($pCUltimo)
            ->setProtegida($protegida)
            ->setQtReservada($qtReservada)
            ->setQtTransito($qtTransito)
            ->setStkActual($stkActual)
            ->setUltimaContagem($ultimaContagem)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Armazem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArmazem()
    {
        return isset($this->Armazem) ? $this->Armazem : null;
    }
    /**
     * Set Armazem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $armazem
     * @return \StructType\ArtigoArmazemERP
     */
    public function setArmazem($armazem = null)
    {
        // validation for constraint: string
        if (!is_null($armazem) && !is_string($armazem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($armazem)), __LINE__);
        }
        if (is_null($armazem) || (is_array($armazem) && empty($armazem))) {
            unset($this->Armazem);
        } else {
            $this->Armazem = $armazem;
        }
        return $this;
    }
    /**
     * Get Artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->Artigo) ? $this->Artigo : null;
    }
    /**
     * Set Artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\ArtigoArmazemERP
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->Artigo);
        } else {
            $this->Artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get BloqueadoInventario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBloqueadoInventario()
    {
        return isset($this->BloqueadoInventario) ? $this->BloqueadoInventario : null;
    }
    /**
     * Set BloqueadoInventario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bloqueadoInventario
     * @return \StructType\ArtigoArmazemERP
     */
    public function setBloqueadoInventario($bloqueadoInventario = null)
    {
        // validation for constraint: boolean
        if (!is_null($bloqueadoInventario) && !is_bool($bloqueadoInventario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bloqueadoInventario)), __LINE__);
        }
        if (is_null($bloqueadoInventario) || (is_array($bloqueadoInventario) && empty($bloqueadoInventario))) {
            unset($this->BloqueadoInventario);
        } else {
            $this->BloqueadoInventario = $bloqueadoInventario;
        }
        return $this;
    }
    /**
     * Get DataUltimaContagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataUltimaContagem()
    {
        return isset($this->DataUltimaContagem) ? $this->DataUltimaContagem : null;
    }
    /**
     * Set DataUltimaContagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataUltimaContagem
     * @return \StructType\ArtigoArmazemERP
     */
    public function setDataUltimaContagem($dataUltimaContagem = null)
    {
        // validation for constraint: string
        if (!is_null($dataUltimaContagem) && !is_string($dataUltimaContagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataUltimaContagem)), __LINE__);
        }
        if (is_null($dataUltimaContagem) || (is_array($dataUltimaContagem) && empty($dataUltimaContagem))) {
            unset($this->DataUltimaContagem);
        } else {
            $this->DataUltimaContagem = $dataUltimaContagem;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \StructType\ArtigoArmazemERP
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get Existencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExistencia()
    {
        return isset($this->Existencia) ? $this->Existencia : null;
    }
    /**
     * Set Existencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $existencia
     * @return \StructType\ArtigoArmazemERP
     */
    public function setExistencia($existencia = null)
    {
        if (is_null($existencia) || (is_array($existencia) && empty($existencia))) {
            unset($this->Existencia);
        } else {
            $this->Existencia = $existencia;
        }
        return $this;
    }
    /**
     * Get IdArtigoDim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdArtigoDim()
    {
        return isset($this->IdArtigoDim) ? $this->IdArtigoDim : null;
    }
    /**
     * Set IdArtigoDim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idArtigoDim
     * @return \StructType\ArtigoArmazemERP
     */
    public function setIdArtigoDim($idArtigoDim = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idArtigoDim) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idArtigoDim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idArtigoDim, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idArtigoDim) && !is_string($idArtigoDim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idArtigoDim)), __LINE__);
        }
        if (is_null($idArtigoDim) || (is_array($idArtigoDim) && empty($idArtigoDim))) {
            unset($this->IdArtigoDim);
        } else {
            $this->IdArtigoDim = $idArtigoDim;
        }
        return $this;
    }
    /**
     * Get Localizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizacao()
    {
        return isset($this->Localizacao) ? $this->Localizacao : null;
    }
    /**
     * Set Localizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizacao
     * @return \StructType\ArtigoArmazemERP
     */
    public function setLocalizacao($localizacao = null)
    {
        // validation for constraint: string
        if (!is_null($localizacao) && !is_string($localizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizacao)), __LINE__);
        }
        if (is_null($localizacao) || (is_array($localizacao) && empty($localizacao))) {
            unset($this->Localizacao);
        } else {
            $this->Localizacao = $localizacao;
        }
        return $this;
    }
    /**
     * Get LocalizacaoArmazem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizacaoArmazem()
    {
        return isset($this->LocalizacaoArmazem) ? $this->LocalizacaoArmazem : null;
    }
    /**
     * Set LocalizacaoArmazem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizacaoArmazem
     * @return \StructType\ArtigoArmazemERP
     */
    public function setLocalizacaoArmazem($localizacaoArmazem = null)
    {
        // validation for constraint: string
        if (!is_null($localizacaoArmazem) && !is_string($localizacaoArmazem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizacaoArmazem)), __LINE__);
        }
        if (is_null($localizacaoArmazem) || (is_array($localizacaoArmazem) && empty($localizacaoArmazem))) {
            unset($this->LocalizacaoArmazem);
        } else {
            $this->LocalizacaoArmazem = $localizacaoArmazem;
        }
        return $this;
    }
    /**
     * Get Lote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLote()
    {
        return isset($this->Lote) ? $this->Lote : null;
    }
    /**
     * Set Lote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lote
     * @return \StructType\ArtigoArmazemERP
     */
    public function setLote($lote = null)
    {
        // validation for constraint: string
        if (!is_null($lote) && !is_string($lote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lote)), __LINE__);
        }
        if (is_null($lote) || (is_array($lote) && empty($lote))) {
            unset($this->Lote);
        } else {
            $this->Lote = $lote;
        }
        return $this;
    }
    /**
     * Get PCMedio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPCMedio()
    {
        return isset($this->PCMedio) ? $this->PCMedio : null;
    }
    /**
     * Set PCMedio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pCMedio
     * @return \StructType\ArtigoArmazemERP
     */
    public function setPCMedio($pCMedio = null)
    {
        if (is_null($pCMedio) || (is_array($pCMedio) && empty($pCMedio))) {
            unset($this->PCMedio);
        } else {
            $this->PCMedio = $pCMedio;
        }
        return $this;
    }
    /**
     * Get PCUltimo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPCUltimo()
    {
        return isset($this->PCUltimo) ? $this->PCUltimo : null;
    }
    /**
     * Set PCUltimo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pCUltimo
     * @return \StructType\ArtigoArmazemERP
     */
    public function setPCUltimo($pCUltimo = null)
    {
        if (is_null($pCUltimo) || (is_array($pCUltimo) && empty($pCUltimo))) {
            unset($this->PCUltimo);
        } else {
            $this->PCUltimo = $pCUltimo;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ArtigoArmazemERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QtReservada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQtReservada()
    {
        return isset($this->QtReservada) ? $this->QtReservada : null;
    }
    /**
     * Set QtReservada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qtReservada
     * @return \StructType\ArtigoArmazemERP
     */
    public function setQtReservada($qtReservada = null)
    {
        if (is_null($qtReservada) || (is_array($qtReservada) && empty($qtReservada))) {
            unset($this->QtReservada);
        } else {
            $this->QtReservada = $qtReservada;
        }
        return $this;
    }
    /**
     * Get QtTransito value
     * @return float|null
     */
    public function getQtTransito()
    {
        return $this->QtTransito;
    }
    /**
     * Set QtTransito value
     * @param float $qtTransito
     * @return \StructType\ArtigoArmazemERP
     */
    public function setQtTransito($qtTransito = null)
    {
        $this->QtTransito = $qtTransito;
        return $this;
    }
    /**
     * Get StkActual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStkActual()
    {
        return isset($this->StkActual) ? $this->StkActual : null;
    }
    /**
     * Set StkActual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $stkActual
     * @return \StructType\ArtigoArmazemERP
     */
    public function setStkActual($stkActual = null)
    {
        if (is_null($stkActual) || (is_array($stkActual) && empty($stkActual))) {
            unset($this->StkActual);
        } else {
            $this->StkActual = $stkActual;
        }
        return $this;
    }
    /**
     * Get UltimaContagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUltimaContagem()
    {
        return isset($this->UltimaContagem) ? $this->UltimaContagem : null;
    }
    /**
     * Set UltimaContagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ultimaContagem
     * @return \StructType\ArtigoArmazemERP
     */
    public function setUltimaContagem($ultimaContagem = null)
    {
        if (is_null($ultimaContagem) || (is_array($ultimaContagem) && empty($ultimaContagem))) {
            unset($this->UltimaContagem);
        } else {
            $this->UltimaContagem = $ultimaContagem;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ArtigoArmazemERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArtigoArmazemERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
