<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fecha ServiceType
 * @subpackage Services
 */
class Fecha extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FechaPlataforma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FechaPlataforma $parameters
     * @return \StructType\FechaPlataformaResponse|bool
     */
    public function FechaPlataforma(\StructType\FechaPlataforma $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FechaPlataforma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FechaEmpresa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FechaEmpresa $parameters
     * @return \StructType\FechaEmpresaResponse|bool
     */
    public function FechaEmpresa(\StructType\FechaEmpresa $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FechaEmpresa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FechaEmpresaResponse|\StructType\FechaPlataformaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
