<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Estornar ServiceType
 * @subpackage Services
 */
class Estornar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EstornarDocumentoDeVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstornarDocumentoDeVenda $parameters
     * @return \StructType\EstornarDocumentoDeVendaResponse|bool
     */
    public function EstornarDocumentoDeVenda(\StructType\EstornarDocumentoDeVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EstornarDocumentoDeVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstornarDocumentoDeVendaSimples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstornarDocumentoDeVendaSimples $parameters
     * @return \StructType\EstornarDocumentoDeVendaSimplesResponse|bool
     */
    public function EstornarDocumentoDeVendaSimples(\StructType\EstornarDocumentoDeVendaSimples $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EstornarDocumentoDeVendaSimples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstornarDocumentoDeCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstornarDocumentoDeCompra $parameters
     * @return \StructType\EstornarDocumentoDeCompraResponse|bool
     */
    public function EstornarDocumentoDeCompra(\StructType\EstornarDocumentoDeCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EstornarDocumentoDeCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstornarDocumentoDeCompraSimples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstornarDocumentoDeCompraSimples $parameters
     * @return \StructType\EstornarDocumentoDeCompraSimplesResponse|bool
     */
    public function EstornarDocumentoDeCompraSimples(\StructType\EstornarDocumentoDeCompraSimples $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EstornarDocumentoDeCompraSimples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EstornarDocumentoDeCompraResponse|\StructType\EstornarDocumentoDeCompraSimplesResponse|\StructType\EstornarDocumentoDeVendaResponse|\StructType\EstornarDocumentoDeVendaSimplesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
