<?php

namespace EnumType;

/**
 * This class stands for EnumTipoPlataformaERP EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EnumTipoPlataformaERP
 * @subpackage Enumerations
 */
class EnumTipoPlataformaERP
{
    /**
     * Constant for value 'eEmpresarial'
     * @return string 'eEmpresarial'
     */
    const VALUE_E_EMPRESARIAL = 'eEmpresarial';
    /**
     * Constant for value 'eProfissional'
     * @return string 'eProfissional'
     */
    const VALUE_E_PROFISSIONAL = 'eProfissional';
    /**
     * Constant for value 'eFirst'
     * @return string 'eFirst'
     */
    const VALUE_E_FIRST = 'eFirst';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_EMPRESARIAL
     * @uses self::VALUE_E_PROFISSIONAL
     * @uses self::VALUE_E_FIRST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_EMPRESARIAL,
            self::VALUE_E_PROFISSIONAL,
            self::VALUE_E_FIRST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
