<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfref_detail ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfref_detail
 * @subpackage Arrays
 */
class ArrayOfref_detail extends AbstractStructArrayBase
{
    /**
     * The ref_detail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Ref_detail[]
     */
    public $ref_detail;
    /**
     * Constructor method for ArrayOfref_detail
     * @uses ArrayOfref_detail::setRef_detail()
     * @param \StructType\Ref_detail[] $ref_detail
     */
    public function __construct(array $ref_detail = array())
    {
        $this
            ->setRef_detail($ref_detail);
    }
    /**
     * Get ref_detail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Ref_detail[]|null
     */
    public function getRef_detail()
    {
        return isset($this->ref_detail) ? $this->ref_detail : null;
    }
    /**
     * Set ref_detail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ref_detail[] $ref_detail
     * @return \ArrayType\ArrayOfref_detail
     */
    public function setRef_detail(array $ref_detail = array())
    {
        foreach ($ref_detail as $arrayOfref_detailRef_detailItem) {
            // validation for constraint: itemType
            if (!$arrayOfref_detailRef_detailItem instanceof \StructType\Ref_detail) {
                throw new \InvalidArgumentException(sprintf('The ref_detail property can only contain items of \StructType\Ref_detail, "%s" given', is_object($arrayOfref_detailRef_detailItem) ? get_class($arrayOfref_detailRef_detailItem) : gettype($arrayOfref_detailRef_detailItem)), __LINE__);
            }
        }
        if (is_null($ref_detail) || (is_array($ref_detail) && empty($ref_detail))) {
            unset($this->ref_detail);
        } else {
            $this->ref_detail = $ref_detail;
        }
        return $this;
    }
    /**
     * Add item to ref_detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Ref_detail $item
     * @return \ArrayType\ArrayOfref_detail
     */
    public function addToRef_detail(\StructType\Ref_detail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ref_detail) {
            throw new \InvalidArgumentException(sprintf('The ref_detail property can only contain items of \StructType\Ref_detail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ref_detail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Ref_detail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Ref_detail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Ref_detail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Ref_detail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Ref_detail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ref_detail
     */
    public function getAttributeName()
    {
        return 'ref_detail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfref_detail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
