<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLinhasLiqERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLinhasLiqERP
 * @subpackage Arrays
 */
class ArrayOfLinhasLiqERP extends AbstractStructArrayBase
{
    /**
     * The LinhasLiqERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LinhasLiqERP[]
     */
    public $LinhasLiqERP;
    /**
     * Constructor method for ArrayOfLinhasLiqERP
     * @uses ArrayOfLinhasLiqERP::setLinhasLiqERP()
     * @param \StructType\LinhasLiqERP[] $linhasLiqERP
     */
    public function __construct(array $linhasLiqERP = array())
    {
        $this
            ->setLinhasLiqERP($linhasLiqERP);
    }
    /**
     * Get LinhasLiqERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LinhasLiqERP[]|null
     */
    public function getLinhasLiqERP()
    {
        return isset($this->LinhasLiqERP) ? $this->LinhasLiqERP : null;
    }
    /**
     * Set LinhasLiqERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LinhasLiqERP[] $linhasLiqERP
     * @return \ArrayType\ArrayOfLinhasLiqERP
     */
    public function setLinhasLiqERP(array $linhasLiqERP = array())
    {
        foreach ($linhasLiqERP as $arrayOfLinhasLiqERPLinhasLiqERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfLinhasLiqERPLinhasLiqERPItem instanceof \StructType\LinhasLiqERP) {
                throw new \InvalidArgumentException(sprintf('The LinhasLiqERP property can only contain items of \StructType\LinhasLiqERP, "%s" given', is_object($arrayOfLinhasLiqERPLinhasLiqERPItem) ? get_class($arrayOfLinhasLiqERPLinhasLiqERPItem) : gettype($arrayOfLinhasLiqERPLinhasLiqERPItem)), __LINE__);
            }
        }
        if (is_null($linhasLiqERP) || (is_array($linhasLiqERP) && empty($linhasLiqERP))) {
            unset($this->LinhasLiqERP);
        } else {
            $this->LinhasLiqERP = $linhasLiqERP;
        }
        return $this;
    }
    /**
     * Add item to LinhasLiqERP value
     * @throws \InvalidArgumentException
     * @param \StructType\LinhasLiqERP $item
     * @return \ArrayType\ArrayOfLinhasLiqERP
     */
    public function addToLinhasLiqERP(\StructType\LinhasLiqERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinhasLiqERP) {
            throw new \InvalidArgumentException(sprintf('The LinhasLiqERP property can only contain items of \StructType\LinhasLiqERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinhasLiqERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LinhasLiqERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LinhasLiqERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LinhasLiqERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LinhasLiqERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LinhasLiqERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LinhasLiqERP
     */
    public function getAttributeName()
    {
        return 'LinhasLiqERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLinhasLiqERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
