<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactoERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContactoERP
 * @subpackage Arrays
 */
class ArrayOfContactoERP extends AbstractStructArrayBase
{
    /**
     * The ContactoERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactoERP[]
     */
    public $ContactoERP;
    /**
     * Constructor method for ArrayOfContactoERP
     * @uses ArrayOfContactoERP::setContactoERP()
     * @param \StructType\ContactoERP[] $contactoERP
     */
    public function __construct(array $contactoERP = array())
    {
        $this
            ->setContactoERP($contactoERP);
    }
    /**
     * Get ContactoERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactoERP[]|null
     */
    public function getContactoERP()
    {
        return isset($this->ContactoERP) ? $this->ContactoERP : null;
    }
    /**
     * Set ContactoERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactoERP[] $contactoERP
     * @return \ArrayType\ArrayOfContactoERP
     */
    public function setContactoERP(array $contactoERP = array())
    {
        foreach ($contactoERP as $arrayOfContactoERPContactoERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactoERPContactoERPItem instanceof \StructType\ContactoERP) {
                throw new \InvalidArgumentException(sprintf('The ContactoERP property can only contain items of \StructType\ContactoERP, "%s" given', is_object($arrayOfContactoERPContactoERPItem) ? get_class($arrayOfContactoERPContactoERPItem) : gettype($arrayOfContactoERPContactoERPItem)), __LINE__);
            }
        }
        if (is_null($contactoERP) || (is_array($contactoERP) && empty($contactoERP))) {
            unset($this->ContactoERP);
        } else {
            $this->ContactoERP = $contactoERP;
        }
        return $this;
    }
    /**
     * Add item to ContactoERP value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactoERP $item
     * @return \ArrayType\ArrayOfContactoERP
     */
    public function addToContactoERP(\StructType\ContactoERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactoERP) {
            throw new \InvalidArgumentException(sprintf('The ContactoERP property can only contain items of \StructType\ContactoERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactoERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactoERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactoERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactoERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactoERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactoERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactoERP
     */
    public function getAttributeName()
    {
        return 'ContactoERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactoERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
